/**********************************************************************
* Written by WAVToCode
* Date:				Sun Mar 28 09:08:09 AM
* FileName:			bangmedium.h
* Interleaved:		N/A
* Signed:			No
* No. of channels:	1
* No. of samples:	10850
* Bits/Sample:		8
**********************************************************************/

#define NUM_BANG_MEDIUM_ELEMENTS 10850

const unsigned char gBangMediumData[NUM_BANG_MEDIUM_ELEMENTS] = {
123, 130, 147, 162, 177, 191, 193, 190, /* 0-7 */
181, 173, 171, 179, 192, 207, 215, 223, /* 8-15 */
223, 220, 217, 214, 212, 209, 206, 204, /* 16-23 */
202, 199, 197, 196, 188, 176, 175, 173, /* 24-31 */
172, 170, 169, 163, 156, 149, 143, 136, /* 32-39 */
130, 124, 117, 111, 106, 100,  95,  91, /* 40-47 */
 85,  81,  76,  71,  61,  46,  33,  19, /* 48-55 */
  6,   1,   5,   8,  12,  19,  14,   6, /* 56-63 */
  2,   0,   0,   0,   0,   0,   0,   0, /* 64-71 */
  0,   0,   4,   8,  15,  27,  40,  57, /* 72-79 */
 74,  70,  65,  60,  55,  50,  46,  41, /* 80-87 */
 38,  36,  42,  56,  70,  84,  96,  94, /* 88-95 */
 91,  89,  85,  88, 102, 115, 128, 142, /* 96-103 */
143, 137, 133, 128, 125, 135, 147, 158, /* 104-111 */
170, 175, 168, 161, 155, 148, 153, 164, /* 112-119 */
173, 183, 193, 202, 210, 218, 226, 232, /* 120-127 */
238, 243, 245, 247, 243, 228, 213, 198, /* 128-135 */
183, 169, 155, 142, 129, 118, 106,  91, /* 136-143 */
 85,  78,  83, 102, 114, 125, 134, 130, /* 144-151 */
123, 118, 112, 113, 125, 136, 147, 159, /* 152-159 */
159, 151, 146, 140, 133, 128, 122, 117, /* 160-167 */
111, 113, 126, 138, 150, 163, 164, 158, /* 168-175 */
154, 149, 144, 139, 135, 131, 127, 129, /* 176-183 */
144, 156, 169, 181, 194, 205, 216, 226, /* 184-191 */
234, 228, 218, 209, 199, 195, 202, 209, /* 192-199 */
215, 221, 216, 203, 192, 181, 171, 175, /* 200-207 */
181, 187, 188, 189, 195, 199, 206, 216, /* 208-215 */
215, 212, 209, 207, 204, 202, 200, 197, /* 216-223 */
195, 193, 191, 186, 167, 147, 139, 140, /* 224-231 */
138, 138, 137, 123, 108,  94,  80,  67, /* 232-239 */
 52,  39,  27,  16,   7,   0,   0,   0, /* 240-247 */
  0,   0,   0,   0,   0,   0,   0,   0, /* 248-255 */
  0,   0,   0,   0,   2,   5,   9,  25, /* 256-263 */
 47,  69,  90, 110, 129, 148, 165, 182, /* 264-271 */
186, 183, 180, 177, 173, 167, 155, 150, /* 272-279 */
145, 144, 162, 176, 187, 198, 209, 218, /* 280-287 */
227, 236, 241, 235, 223, 213, 201, 195, /* 288-295 */
201, 205, 209, 215, 209, 195, 183, 170, /* 296-303 */
160, 162, 167, 172, 178, 177, 164, 153, /* 304-311 */
141, 130, 119, 109,  99,  90,  82,  74, /* 312-319 */
 67,  61,  56,  52,  48,  45,  42,  42, /* 320-327 */
 43,  43,  45,  46,  47,  48,  49,  51, /* 328-335 */
 52,  55,  57,  60,  63,  66,  70,  73, /* 336-343 */
 77,  76,  77,  96, 114, 135, 160, 176, /* 344-351 */
193, 209, 223, 236, 239, 232, 226, 219, /* 352-359 */
212, 217, 225, 231, 233, 229, 226, 223, /* 360-367 */
220, 217, 215, 212, 209, 207, 204, 202, /* 368-375 */
200, 197, 195, 193, 191, 189, 187, 185, /* 376-383 */
183, 181, 179, 178, 176, 175, 169, 145, /* 384-391 */
121, 102,  99,  94,  91,  89,  87,  86, /* 392-399 */
 85,  85,  84,  84,  84,  84,  84,  79, /* 400-407 */
 61,  43,  26,  10,   5,   3,   4,   8, /* 408-415 */
 10,  20,  28,  34,  42,  49,  55,  60, /* 416-423 */
 63,  68,  60,  44,  30,  17,   8,   9, /* 424-431 */
 14,  18,  23,  30,  37,  44,  51,  59, /* 432-439 */
 66,  72,  79,  85,  90,  80,  66,  55, /* 440-447 */
 42,  36,  43,  49,  57,  64,  72,  80, /* 448-455 */
 88,  96, 104,  96,  85,  75,  66,  57, /* 456-463 */
 51,  52,  54,  57,  59,  61,  64,  69, /* 464-471 */
 81,  80,  77,  76,  76,  77,  79,  81, /* 472-479 */
 83,  84,  86,  88,  89,  91,  92,  94, /* 480-487 */
 95,  96,  98,  99, 107, 127, 147, 168, /* 488-495 */
178, 180, 182, 183, 185, 199, 216, 231, /* 496-503 */
246, 252, 250, 247, 244, 238, 242, 250, /* 504-511 */
255, 255, 255, 255, 255, 253, 248, 243, /* 512-519 */
232, 215, 206, 196, 196, 204, 211, 219, /* 520-527 */
226, 233, 240, 243, 247, 247, 242, 233, /* 528-535 */
222, 211, 207, 213, 217, 221, 224, 228, /* 536-543 */
232, 233, 230, 227, 222, 208, 195, 182, /* 544-551 */
168, 155, 143, 131, 120, 110, 101,  93, /* 552-559 */
 85,  82,  92, 101, 111, 121, 123, 117, /* 560-567 */
112, 106, 102, 109, 120, 130, 140, 149, /* 568-575 */
158, 166, 174, 181, 187, 193, 198, 202, /* 576-583 */
205, 203, 200, 198, 196, 194, 191, 176, /* 584-591 */
160, 143, 135, 136, 136, 136, 136, 124, /* 592-599 */
108,  95,  82,  71,  61,  51,  41,  31, /* 600-607 */
 22,  13,   6,   2,   0,   4,  15,  27, /* 608-615 */
 39,  51,  63,  75,  87,  98, 109, 118, /* 616-623 */
128, 136, 143, 137, 127, 118, 108,  99, /* 624-631 */
 89,  80,  72,  64,  64,  73,  82,  91, /* 632-639 */
 99, 109, 119, 127, 136, 144, 151, 157, /* 640-647 */
164, 170, 174, 178, 182, 184, 186, 175, /* 648-655 */
159, 145, 130, 117, 103,  89,  77,  66, /* 656-663 */
 63,  70,  76,  83,  90,  97, 105, 113, /* 664-671 */
119, 126, 133, 139, 144, 150, 147, 133, /* 672-679 */
122, 110,  98,  87,  77,  67,  57,  52, /* 680-687 */
 59,  68,  76,  85,  94, 103, 112, 121, /* 688-695 */
131, 140, 148, 155, 161, 163, 150, 138, /* 696-703 */
126, 113, 108, 114, 118, 122, 127, 132, /* 704-711 */
136, 141, 145, 146, 134, 122, 111,  99, /* 712-719 */
 95, 101, 106, 112, 117, 110,  99,  91, /* 720-727 */
 81,  75,  83,  90,  98, 107, 116, 124, /* 728-735 */
132, 140, 147, 154, 160, 166, 172, 176, /* 736-743 */
180, 184, 187, 189, 191, 193, 194, 194, /* 744-751 */
194, 181, 163, 147, 130, 118, 118, 120, /* 752-759 */
122, 124, 126, 129, 132, 135, 137, 127, /* 760-767 */
113, 100,  87,  78,  83,  87,  93,  98, /* 768-775 */
104, 110, 115, 121, 127, 132, 136, 141, /* 776-783 */
145, 148, 153, 158, 162, 165, 167, 168, /* 784-791 */
168, 167, 167, 153, 134, 118, 101,  86, /* 792-799 */
 71,  57,  45,  32,  29,  37,  44,  52, /* 800-807 */
 61,  70,  79,  89,  98, 104,  97,  89, /* 808-815 */
 83,  75,  75,  85,  94, 104, 113, 122, /* 816-823 */
132, 140, 149, 158, 165, 173, 179, 185, /* 824-831 */
183, 170, 159, 148, 136, 125, 115, 106, /* 832-839 */
 96,  90,  98, 107, 116, 125, 134, 144, /* 840-847 */
153, 161, 170, 178, 185, 192, 199, 201, /* 848-855 */
191, 179, 168, 156, 152, 158, 162, 167, /* 856-863 */
172, 176, 181, 186, 190, 194, 197, 200, /* 864-871 */
203, 205, 207, 208, 208, 208, 209, 209, /* 872-879 */
210, 210, 209, 205, 186, 166, 147, 128, /* 880-887 */
117, 117, 116, 116, 117, 106,  91,  77, /* 888-895 */
 65,  53,  42,  32,  23,  15,  10,   6, /* 896-903 */
  4,   3,   1,   5,  18,  33,  48,  63, /* 904-911 */
 78,  93, 107, 120, 133, 146, 158, 169, /* 912-919 */
178, 187, 195, 202, 208, 214, 218, 222, /* 920-927 */
225, 228, 222, 206, 191, 176, 161, 146, /* 928-935 */
132, 119, 107,  96,  86,  76,  68,  61, /* 936-943 */
 55,  50,  46,  43,  41,  50,  65,  80, /* 944-951 */
 94, 106, 106, 105, 104, 102, 107, 122, /* 952-959 */
135, 148, 160, 172, 183, 194, 203, 210, /* 960-967 */
203, 194, 188, 180, 179, 187, 193, 198, /* 968-975 */
203, 196, 183, 173, 162, 151, 141, 131, /* 976-983 */
122, 113, 111, 120, 128, 137, 145, 153, /* 984-991 */
161, 169, 176, 183, 190, 195, 200, 204, /* 992-999 */
202, 188, 175, 162, 149, 136, 124, 113, /* 1000-1007 */
102,  92,  83,  75,  68,  61,  56,  51, /* 1008-1015 */
 47,  44,  42,  40,  39,  39,  40,  41, /* 1016-1023 */
 42,  44,  47,  49,  52,  56,  59,  63, /* 1024-1031 */
 67,  71,  75,  80,  84,  90, 108, 127, /* 1032-1039 */
145, 162, 179, 194, 209, 222, 234, 234, /* 1040-1047 */
228, 223, 216, 211, 217, 224, 230, 235, /* 1048-1055 */
233, 230, 227, 224, 221, 218, 215, 212, /* 1056-1063 */
209, 198, 199, 199, 199, 198, 196, 194, /* 1064-1071 */
192, 190, 188, 184, 167, 151, 135, 119, /* 1072-1079 */
104,  89,  76,  63,  57,  62,  67,  72, /* 1080-1087 */
 78,  74,  64,  56,  48,  41,  34,  27, /* 1088-1095 */
 22,  17,  12,   9,   8,   7,   6,   6, /* 1096-1103 */
  7,   7,   8,  10,  24,  41,  58,  74, /* 1104-1111 */
 91, 106, 121, 135, 148, 150, 145, 141, /* 1112-1119 */
136, 131, 125, 120, 114, 109, 104, 100, /* 1120-1127 */
 96,  92,  89,  96, 109, 121, 134, 144, /* 1128-1135 */
141, 138, 134, 130, 126, 122, 118, 115, /* 1136-1143 */
111, 118, 131, 142, 153, 164, 174, 184, /* 1144-1151 */
193, 202, 206, 198, 191, 183, 173, 163, /* 1152-1159 */
152, 142, 133, 124, 115, 107, 100,  94, /* 1160-1167 */
 88,  83,  79,  76,  73,  80,  93, 106, /* 1168-1175 */
119, 131, 143, 155, 166, 176, 185, 194, /* 1176-1183 */
201, 208, 213, 218, 222, 225, 228, 227, /* 1184-1191 */
214, 199, 184, 169, 154, 140, 126, 112, /* 1192-1199 */
100,  89,  78,  68,  60,  54,  61,  70, /* 1200-1207 */
 79,  89,  93,  87,  82,  77,  72,  77, /* 1208-1215 */
 88,  98, 109, 117, 113, 107, 102,  95, /* 1216-1223 */
 95, 105, 114, 124, 132, 141, 150, 158, /* 1224-1231 */
165, 170, 162, 152, 142, 132, 122, 113, /* 1232-1239 */
103,  94,  86,  78,  71,  65,  61,  59, /* 1240-1247 */
 69,  81,  92, 102, 107, 102,  98,  94, /* 1248-1255 */
 89,  94, 105, 114, 124, 132, 129, 123, /* 1256-1263 */
119, 114, 113, 123, 132, 140, 149, 157, /* 1264-1271 */
165, 172, 179, 184, 177, 168, 159, 150, /* 1272-1279 */
141, 132, 124, 116, 109, 103,  98,  93, /* 1280-1287 */
 88,  84,  81,  79,  77,  76,  75,  75, /* 1288-1295 */
 75,  76,  77,  87, 103, 118, 133, 147, /* 1296-1303 */
161, 174, 186, 197, 208, 217, 226, 233, /* 1304-1311 */
239, 243, 245, 246, 248, 248, 246, 244, /* 1312-1319 */
242, 240, 238, 235, 232, 229, 226, 223, /* 1320-1327 */
216, 196, 178, 161, 157, 154, 152, 150, /* 1328-1335 */
144, 129, 116, 104,  91,  88,  90,  92, /* 1336-1343 */
 94,  96,  98, 101, 104, 108, 106,  94, /* 1344-1351 */
 83,  72,  62,  52,  42,  33,  26,  20, /* 1352-1359 */
 26,  35,  44,  53,  62,  72,  81,  91, /* 1360-1367 */
 99, 108, 115, 123, 130, 136, 141, 146, /* 1368-1375 */
151, 156, 160, 162, 165, 168, 169, 170, /* 1376-1383 */
171, 172, 172, 170, 156, 141, 125, 111, /* 1384-1391 */
 97,  83,  70,  59,  48,  39,  30,  23, /* 1392-1399 */
 17,  14,  12,  10,  10,  11,  13,  15, /* 1400-1407 */
 18,  20,  23,  26,  38,  56,  73,  89, /* 1408-1415 */
 94,  97,  99, 101, 103, 105, 106, 108, /* 1416-1423 */
109, 119, 135, 149, 163, 177, 192, 205, /* 1424-1431 */
218, 230, 240, 245, 249, 251, 253, 251, /* 1432-1439 */
245, 238, 226, 214, 202, 191, 180, 170, /* 1440-1447 */
164, 169, 174, 179, 184, 182, 172, 164, /* 1448-1455 */
156, 148, 141, 134, 127, 121, 119, 128, /* 1456-1463 */
136, 145, 154, 163, 171, 180, 188, 195, /* 1464-1471 */
201, 207, 212, 217, 217, 205, 193, 182, /* 1472-1479 */
170, 166, 170, 172, 174, 177, 179, 181, /* 1480-1487 */
183, 186, 183, 169, 157, 144, 131, 119, /* 1488-1495 */
107,  96,  86,  76,  68,  60,  53,  47, /* 1496-1503 */
 42,  38,  34,  32,  29,  36,  50,  63, /* 1504-1511 */
 76,  88,  89,  88,  87,  85,  84,  82, /* 1512-1519 */
 81,  81,  81,  90, 105, 118, 129, 140, /* 1520-1527 */
139, 135, 131, 128, 124, 120, 117, 113, /* 1528-1535 */
110, 107, 105, 103, 101,  99,  99,  97, /* 1536-1543 */
 97,  97, 101, 115, 129, 142, 155, 160, /* 1544-1551 */
158, 157, 154, 152, 162, 172, 182, 192, /* 1552-1559 */
198, 193, 187, 181, 176, 170, 163, 157, /* 1560-1567 */
152, 146, 141, 136, 131, 127, 126, 136, /* 1568-1575 */
146, 156, 166, 168, 162, 158, 153, 148, /* 1576-1583 */
154, 163, 171, 178, 186, 192, 198, 203, /* 1584-1591 */
209, 205, 194, 183, 172, 161, 150, 139, /* 1592-1599 */
129, 119, 113, 118, 124, 129, 135, 133, /* 1600-1607 */
123, 115, 107,  99,  92,  85,  80,  75, /* 1608-1615 */
 71,  67,  62,  58,  53,  49,  46,  44, /* 1616-1623 */
 42,  40,  39,  39,  39,  40,  41,  42, /* 1624-1631 */
 44,  46,  49,  51,  54,  57,  61,  64, /* 1632-1639 */
 67,  71,  75,  78,  85, 102, 119, 135, /* 1640-1647 */
150, 165, 178, 191, 203, 214, 214, 208, /* 1648-1655 */
203, 197, 190, 184, 177, 170, 163, 157, /* 1656-1663 */
151, 145, 139, 134, 141, 150, 158, 167, /* 1664-1671 */
173, 167, 161, 155, 150, 144, 138, 132, /* 1672-1679 */
127, 122, 128, 138, 146, 154, 163, 170, /* 1680-1687 */
178, 184, 190, 196, 200, 204, 207, 209, /* 1688-1695 */
200, 186, 173, 160, 147, 134, 122, 110, /* 1696-1703 */
 99,  96, 103, 109, 114, 119, 123, 126, /* 1704-1711 */
130, 133, 136, 139, 141, 143, 146, 140, /* 1712-1719 */
126, 113, 100,  87,  75,  64,  53,  43, /* 1720-1727 */
 34,  26,  18,  13,   9,  10,  19,  31, /* 1728-1735 */
 41,  51,  51,  47,  45,  42,  42,  54, /* 1736-1743 */
 66,  78,  89,  94,  90,  86,  83,  80, /* 1744-1751 */
 77,  74,  71,  69,  69,  81,  93, 105, /* 1752-1759 */
116, 128, 139, 149, 159, 168, 176, 184, /* 1760-1767 */
191, 197, 202, 207, 210, 213, 216, 211, /* 1768-1775 */
196, 183, 170, 157, 155, 157, 158, 160, /* 1776-1783 */
162, 164, 165, 167, 169, 170, 171, 172, /* 1784-1791 */
172, 173, 172, 172, 171, 172, 169, 154, /* 1792-1799 */
140, 125, 109,  94,  79,  65,  52,  41, /* 1800-1807 */
 30,  21,  14,  10,   7,   5,   4,   6, /* 1808-1815 */
  7,  11,  15,  23,  37,  52,  67,  81, /* 1816-1823 */
 95, 109, 119, 117, 114, 112, 108, 111, /* 1824-1831 */
123, 133, 143, 152, 151, 146, 142, 137, /* 1832-1839 */
134, 143, 152, 161, 170, 178, 186, 193, /* 1840-1847 */
200, 206, 201, 191, 183, 173, 164, 156, /* 1848-1855 */
147, 139, 131, 131, 139, 146, 154, 161, /* 1856-1863 */
169, 176, 184, 190, 196, 202, 208, 212, /* 1864-1871 */
216, 213, 200, 189, 177, 165, 154, 143, /* 1872-1879 */
133, 123, 114, 106,  98,  91,  84,  86, /* 1880-1887 */
 96, 107, 118, 129, 140, 149, 157, 165, /* 1888-1895 */
172, 178, 184, 189, 194, 198, 201, 204, /* 1896-1903 */
206, 208, 198, 184, 170, 156, 146, 147, /* 1904-1911 */
148, 150, 152, 148, 135, 123, 112, 101, /* 1912-1919 */
101, 106, 110, 116, 118, 109, 100,  92, /* 1920-1927 */
 84,  83,  91,  98, 105, 112, 109, 101, /* 1928-1935 */
 95,  89,  82,  77,  72,  67,  62,  59, /* 1936-1943 */
 56,  54,  52,  51,  51,  51,  51,  52, /* 1944-1951 */
 56,  71,  85, 100, 113, 127, 140, 152, /* 1952-1959 */
164, 174, 184, 194, 202, 209, 213, 207, /* 1960-1967 */
198, 191, 182, 179, 184, 187, 191, 194, /* 1968-1975 */
197, 200, 203, 205, 205, 195, 185, 175, /* 1976-1983 */
164, 154, 143, 131, 121, 111, 102,  93, /* 1984-1991 */
 86,  79,  73,  68,  64,  61,  58,  56, /* 1992-1999 */
 55,  54,  54,  54,  55,  57,  58,  60, /* 2000-2007 */
 65,  79,  95, 109, 124, 132, 132, 133, /* 2008-2015 */
133, 133, 133, 132, 132, 132, 134, 145, /* 2016-2023 */
157, 168, 179, 189, 198, 207, 215, 223, /* 2024-2031 */
229, 235, 238, 237, 233, 230, 224, 212, /* 2032-2039 */
201, 189, 178, 167, 157, 146, 146, 150, /* 2040-2047 */
153, 157, 160, 164, 168, 171, 174, 172, /* 2048-2055 */
161, 151, 140, 130, 129, 133, 135, 138, /* 2056-2063 */
139, 130, 120, 111, 101,  97, 101, 105, /* 2064-2071 */
110, 116, 113, 105,  98,  90,  81,  73, /* 2072-2079 */
 65,  58,  51,  45,  40,  36,  32,  30, /* 2080-2087 */
 27,  26,  25,  25,  26,  39,  52,  65, /* 2088-2095 */
 79,  86,  86,  86,  85,  85,  84,  84, /* 2096-2103 */
 83,  82,  83,  95, 107, 119, 130, 141, /* 2104-2111 */
152, 162, 172, 180, 188, 195, 201, 206, /* 2112-2119 */
211, 214, 217, 219, 221, 217, 203, 191, /* 2120-2127 */
178, 165, 161, 162, 162, 163, 162, 150, /* 2128-2135 */
138, 127, 115, 109, 113, 115, 118, 121, /* 2136-2143 */
125, 128, 131, 134, 137, 140, 142, 144, /* 2144-2151 */
146, 147, 148, 149, 149, 150, 140, 126, /* 2152-2159 */
112,  99,  88,  87,  89,  92,  95,  98, /* 2160-2167 */
102, 104, 105, 107, 108, 109, 110, 110, /* 2168-2175 */
111, 112, 112, 113, 114, 109,  95,  82, /* 2176-2183 */
 69,  57,  54,  58,  60,  63,  66,  70, /* 2184-2191 */
 74,  78,  82,  86,  90,  94,  98, 101, /* 2192-2199 */
104, 107, 110, 113, 114, 105,  93,  83, /* 2200-2207 */
 72,  67,  71,  75,  80,  84,  89,  94, /* 2208-2215 */
100, 105, 108, 101,  92,  84,  76,  73, /* 2216-2223 */
 80,  86,  92,  99,  97,  90,  84,  79, /* 2224-2231 */
 73,  69,  65,  61,  58,  60,  72,  83, /* 2232-2239 */
 94, 106, 109, 106, 105, 104, 103, 102, /* 2240-2247 */
101, 100, 100, 104, 118, 130, 142, 155, /* 2248-2255 */
159, 159, 160, 160, 159, 157, 154, 152, /* 2256-2263 */
150, 148, 146, 145, 144, 143, 143, 143, /* 2264-2271 */
143, 144, 146, 158, 172, 185, 197, 210, /* 2272-2279 */
221, 231, 241, 247, 251, 254, 255, 255, /* 2280-2287 */
255, 255, 252, 246, 241, 232, 221, 211, /* 2288-2295 */
202, 193, 184, 176, 168, 161, 155, 161, /* 2296-2303 */
168, 174, 182, 184, 178, 172, 166, 160, /* 2304-2311 */
154, 149, 144, 139, 135, 142, 150, 158, /* 2312-2319 */
167, 170, 164, 159, 154, 149, 151, 159, /* 2320-2327 */
166, 172, 178, 184, 189, 194, 198, 202, /* 2328-2335 */
203, 201, 199, 196, 194, 192, 190, 188, /* 2336-2343 */
186, 184, 182, 180, 179, 177, 176, 166, /* 2344-2351 */
150, 133, 125, 122, 119, 116, 113, 100, /* 2352-2359 */
 85,  72,  59,  47,  36,  26,  17,   9, /* 2360-2367 */
  9,  17,  23,  31,  37,  34,  29,  25, /* 2368-2375 */
 21,  17,  14,  12,  11,   9,  15,  27, /* 2376-2383 */
 39,  50,  61,  62,  61,  61,  60,  60, /* 2384-2391 */
 59,  58,  58,  58,  58,  59,  60,  61, /* 2392-2399 */
 62,  64,  66,  68,  70,  73,  76,  79, /* 2400-2407 */
 82,  85,  96, 113, 128, 143, 157, 171, /* 2408-2415 */
183, 195, 206, 216, 225, 233, 240, 243, /* 2416-2423 */
242, 234, 225, 216, 206, 196, 186, 177, /* 2424-2431 */
168, 159, 151, 143, 136, 129, 131, 139, /* 2432-2439 */
146, 155, 163, 160, 154, 148, 141, 135, /* 2440-2447 */
129, 123, 117, 112, 107, 103,  99,  96, /* 2448-2455 */
 94, 102, 113, 123, 133, 142, 152, 161, /* 2456-2463 */
168, 177, 176, 169, 163, 156, 149, 142, /* 2464-2471 */
135, 128, 122, 120, 126, 133, 140, 147, /* 2472-2479 */
147, 140, 135, 129, 123, 118, 113, 108, /* 2480-2487 */
103,  99,  95,  92,  89,  86,  91, 102, /* 2488-2495 */
112, 123, 133, 142, 152, 160, 168, 176, /* 2496-2503 */
182, 188, 193, 198, 194, 183, 173, 163, /* 2504-2511 */
153, 154, 157, 159, 161, 163, 165, 167, /* 2512-2519 */
169, 170, 171, 172, 172, 172, 171, 159, /* 2520-2527 */
144, 131, 117, 107, 109, 111, 113, 115, /* 2528-2535 */
117, 118, 118, 118, 119, 119, 119, 119, /* 2536-2543 */
119, 115, 101,  88,  75,  63,  51,  40, /* 2544-2551 */
 30,  21,  13,   8,   4,   2,   0,   0, /* 2552-2559 */
  0,   0,   0,   0,   3,   8,  18,  31, /* 2560-2567 */
 45,  48,  49,  51,  53,  55,  57,  58, /* 2568-2575 */
 60,  62,  71,  86, 100, 114, 127, 130, /* 2576-2583 */
129, 129, 129, 131, 143, 155, 165, 176, /* 2584-2591 */
179, 175, 172, 168, 164, 171, 180, 188, /* 2592-2599 */
195, 202, 209, 215, 221, 226, 224, 214, /* 2600-2607 */
205, 196, 187, 177, 168, 160, 152, 144, /* 2608-2615 */
137, 131, 125, 119, 121, 130, 138, 146, /* 2616-2623 */
156, 166, 175, 183, 190, 193, 184, 176, /* 2624-2631 */
168, 159, 158, 163, 166, 171, 174, 167, /* 2632-2639 */
158, 150, 141, 133, 125, 117, 111, 104, /* 2640-2647 */
105, 113, 119, 127, 134, 142, 149, 155, /* 2648-2655 */
162, 165, 157, 149, 141, 134, 126, 120, /* 2656-2663 */
113, 107, 101,  96,  91,  87,  83,  80, /* 2664-2671 */
 78,  76,  74,  73,  73,  73,  73,  74, /* 2672-2679 */
 75,  86, 100, 113, 126, 136, 135, 135, /* 2680-2687 */
135, 134, 139, 150, 160, 170, 179, 187, /* 2688-2695 */
195, 202, 208, 214, 218, 222, 225, 228, /* 2696-2703 */
224, 212, 201, 190, 179, 178, 179, 180, /* 2704-2711 */
180, 181, 181, 182, 183, 186, 180, 168, /* 2712-2719 */
157, 144, 131, 118, 107,  95,  85,  78, /* 2720-2727 */
 81,  85,  89,  93,  92,  84,  78,  71, /* 2728-2735 */
 65,  60,  55,  51,  46,  46,  55,  64, /* 2736-2743 */
 74,  83,  92, 101, 110, 118, 126, 133, /* 2744-2751 */
139, 145, 151, 156, 161, 166, 169, 172, /* 2752-2759 */
168, 156, 146, 136, 125, 115, 106,  97, /* 2760-2767 */
 88,  80,  73,  67,  61,  56,  52,  49, /* 2768-2775 */
 47,  45,  44,  53,  65,  77,  88,  97, /* 2776-2783 */
 97,  96,  96,  94,  94,  93,  92,  92, /* 2784-2791 */
 91,  92,  91,  92,  92,  95, 108, 121, /* 2792-2799 */
133, 145, 151, 150, 148, 147, 145, 143, /* 2800-2807 */
143, 143, 142, 144, 154, 164, 172, 180, /* 2808-2815 */
182, 177, 173, 168, 163, 159, 155, 150, /* 2816-2823 */
145, 144, 152, 160, 168, 176, 178, 172, /* 2824-2831 */
167, 162, 157, 153, 148, 143, 139, 134, /* 2832-2839 */
131, 127, 124, 121, 119, 117, 115, 114, /* 2840-2847 */
114, 113, 113, 113, 113, 114, 114, 115, /* 2848-2855 */
116, 116, 118, 119, 120, 122, 123, 134, /* 2856-2863 */
147, 160, 172, 183, 194, 204, 213, 221, /* 2864-2871 */
228, 234, 237, 233, 230, 227, 224, 219, /* 2872-2879 */
208, 198, 187, 176, 165, 155, 145, 136, /* 2880-2887 */
127, 120, 112, 115, 121, 126, 132, 137, /* 2888-2895 */
143, 148, 152, 158, 158, 150, 143, 135, /* 2896-2903 */
127, 127, 130, 132, 134, 134, 124, 114, /* 2904-2911 */
105,  95,  92,  96, 100, 103, 107, 111, /* 2912-2919 */
114, 118, 121, 124, 127, 129, 131, 133, /* 2920-2927 */
129, 117, 106,  95,  84,  83,  86,  88, /* 2928-2935 */
 90,  91,  82,  73,  65,  57,  50,  43, /* 2936-2943 */
 37,  31,  26,  22,  18,  16,  14,  15, /* 2944-2951 */
 25,  37,  48,  60,  66,  64,  64,  63, /* 2952-2959 */
 63,  71,  83,  94, 105, 114, 111, 109, /* 2960-2967 */
107, 104, 102,  99,  97,  95,  93,  92, /* 2968-2975 */
 90,  89,  89,  89,  89,  89,  90,  91, /* 2976-2983 */
 97, 111, 123, 136, 149, 160, 171, 182, /* 2984-2991 */
193, 204, 213, 221, 227, 232, 230, 219, /* 2992-2999 */
210, 200, 190, 188, 192, 193, 195, 196, /* 3000-3007 */
198, 199, 201, 201, 202, 202, 203, 202, /* 3008-3015 */
202, 192, 177, 164, 151, 139, 127, 115, /* 3016-3023 */
105,  94,  90,  95,  98, 103, 108, 104, /* 3024-3031 */
 97,  91,  85,  79,  74,  70,  66,  62, /* 3032-3039 */
 59,  56,  55,  53,  52,  61,  74,  85, /* 3040-3047 */
 97, 107, 106, 105, 105, 104, 103, 102, /* 3048-3055 */
101, 100,  99, 108, 120, 130, 141, 152, /* 3056-3063 */
162, 171, 180, 188, 191, 185, 179, 173, /* 3064-3071 */
167, 169, 175, 180, 186, 188, 181, 173, /* 3072-3079 */
165, 157, 154, 160, 166, 172, 177, 173, /* 3080-3087 */
164, 155, 146, 137, 129, 121, 114, 107, /* 3088-3095 */
101,  95,  90,  86,  82,  79,  77,  75, /* 3096-3103 */
 74,  73,  73,  72,  73,  73,  80,  94, /* 3104-3111 */
106, 119, 132, 135, 135, 134, 134, 133, /* 3112-3119 */
132, 130, 130, 129, 129, 128, 127, 127, /* 3120-3127 */
126, 135, 147, 158, 169, 178, 176, 174, /* 3128-3135 */
171, 168, 165, 162, 159, 156, 153, 150, /* 3136-3143 */
147, 144, 141, 141, 150, 160, 169, 179, /* 3144-3151 */
182, 178, 174, 170, 166, 170, 178, 184, /* 3152-3159 */
190, 197, 202, 207, 211, 215, 213, 203, /* 3160-3167 */
193, 183, 173, 163, 153, 143, 134, 126, /* 3168-3175 */
120, 114, 108, 102, 101, 107, 112, 117, /* 3176-3183 */
123, 121, 114, 108, 102,  97,  92,  87, /* 3184-3191 */
 82,  77,  78,  87,  96, 104, 112, 112, /* 3192-3199 */
107, 103, 100,  96,  92,  88,  85,  82, /* 3200-3207 */
 79,  76,  74,  72,  70,  77,  89, 100, /* 3208-3215 */
111, 121, 132, 141, 150, 158, 166, 173, /* 3216-3223 */
179, 184, 188, 183, 174, 165, 155, 147, /* 3224-3231 */
149, 152, 154, 156, 159, 161, 162, 164, /* 3232-3239 */
165, 166, 167, 167, 167, 167, 166, 165, /* 3240-3247 */
164, 163, 161, 159, 157, 154, 152, 149, /* 3248-3255 */
146, 143, 140, 136, 121, 105,  90,  75, /* 3256-3263 */
 61,  48,  36,  26,  18,  11,   6,   2, /* 3264-3271 */
  0,   0,   0,   3,  10,  16,  25,  35, /* 3272-3279 */
 44,  53,  62,  71,  79,  87,  94, 101, /* 3280-3287 */
108, 114, 119, 125, 125, 116, 107,  99, /* 3288-3295 */
 91,  91,  96, 101, 106, 109, 103,  95, /* 3296-3303 */
 88,  82,  76,  71,  67,  63,  59,  64, /* 3304-3311 */
 74,  84,  94, 104, 113, 123, 132, 141, /* 3312-3319 */
149, 157, 164, 171, 177, 182, 187, 192, /* 3320-3327 */
195, 197, 188, 178, 168, 157, 152, 155, /* 3328-3335 */
158, 161, 163, 166, 169, 172, 175, 176, /* 3336-3343 */
167, 156, 146, 137, 128, 119, 110, 103, /* 3344-3351 */
 96,  97, 104, 110, 117, 124, 131, 139, /* 3352-3359 */
147, 155, 162, 169, 173, 176, 180, 182, /* 3360-3367 */
184, 186, 188, 188, 177, 165, 154, 142, /* 3368-3375 */
135, 138, 139, 141, 144, 139, 128, 119, /* 3376-3383 */
110, 103, 107, 112, 116, 120, 123, 128, /* 3384-3391 */
132, 136, 139, 136, 127, 120, 113, 108, /* 3392-3399 */
112, 116, 121, 126, 131, 136, 140, 145, /* 3400-3407 */
149, 146, 138, 132, 125, 119, 122, 127, /* 3408-3415 */
131, 136, 137, 130, 124, 118, 113, 108, /* 3416-3423 */
103,  98,  94,  92,  98, 107, 115, 123, /* 3424-3431 */
128, 124, 122, 119, 117, 121, 130, 138, /* 3432-3439 */
146, 153, 161, 168, 174, 181, 183, 176, /* 3440-3447 */
170, 163, 157, 152, 148, 143, 138, 134, /* 3448-3455 */
128, 123, 118, 113, 109, 106, 103, 101, /* 3456-3463 */
 98, 104, 114, 124, 133, 142, 141, 139, /* 3464-3471 */
138, 136, 137, 147, 155, 163, 171, 172, /* 3472-3479 */
167, 163, 159, 156, 161, 168, 174, 179, /* 3480-3487 */
182, 176, 170, 165, 160, 155, 149, 144, /* 3488-3495 */
139, 135, 140, 147, 153, 160, 166, 172, /* 3496-3503 */
177, 182, 186, 190, 193, 196, 199, 200, /* 3504-3511 */
201, 202, 202, 201, 199, 197, 195, 192, /* 3512-3519 */
190, 188, 186, 185, 182, 178, 165, 150, /* 3520-3527 */
135, 121, 108,  95,  83,  72,  62,  52, /* 3528-3535 */
 43,  35,  29,  24,  28,  34,  41,  49, /* 3536-3543 */
 58,  67,  76,  82,  89,  88,  81,  76, /* 3544-3551 */
 70,  65,  70,  76,  81,  86,  92,  98, /* 3552-3559 */
103, 108, 113, 111, 104,  97,  91,  84, /* 3560-3567 */
 78,  72,  67,  62,  61,  68,  75,  82, /* 3568-3575 */
 89,  90,  86,  83,  80,  77,  75,  73, /* 3576-3583 */
 71,  70,  68,  68,  67,  67,  67,  74, /* 3584-3591 */
 87,  98, 109, 119, 121, 120, 120, 120, /* 3592-3599 */
119, 118, 117, 117, 116, 121, 132, 142, /* 3600-3607 */
152, 161, 170, 178, 186, 193, 199, 205, /* 3608-3615 */
210, 214, 218, 214, 205, 197, 188, 179, /* 3616-3623 */
170, 161, 153, 145, 138, 131, 124, 118, /* 3624-3631 */
112, 113, 120, 128, 136, 143, 142, 137, /* 3632-3639 */
132, 126, 124, 130, 135, 141, 146, 145, /* 3640-3647 */
139, 133, 128, 123, 127, 133, 138, 144, /* 3648-3655 */
146, 140, 134, 129, 122, 123, 129, 134, /* 3656-3663 */
139, 143, 139, 133, 127, 121, 116, 110, /* 3664-3671 */
105, 101,  97,  94,  91,  88,  86,  84, /* 3672-3679 */
 82,  81,  81,  80,  83,  95, 105, 116, /* 3680-3687 */
127, 132, 130, 129, 128, 127, 125, 124, /* 3688-3695 */
122, 120, 122, 132, 141, 150, 159, 161, /* 3696-3703 */
157, 155, 152, 148, 144, 142, 139, 135, /* 3704-3711 */
134, 142, 150, 158, 164, 172, 178, 184, /* 3712-3719 */
189, 194, 189, 181, 174, 167, 160, 154, /* 3720-3727 */
148, 143, 137, 130, 124, 117, 111, 106, /* 3728-3735 */
110, 116, 122, 129, 132, 128, 123, 119, /* 3736-3743 */
115, 110, 106, 102,  99,  96, 102, 110, /* 3744-3751 */
118, 125, 133, 140, 147, 153, 159, 164, /* 3752-3759 */
169, 173, 176, 178, 171, 162, 154, 145, /* 3760-3767 */
139, 141, 143, 145, 147, 149, 151, 153, /* 3768-3775 */
154, 156, 157, 157, 158, 158, 156, 144, /* 3776-3783 */
133, 122, 111, 101,  91,  81,  73,  65, /* 3784-3791 */
 58,  51,  45,  40,  39,  46,  54,  62, /* 3792-3799 */
 70,  73,  69,  67,  65,  63,  61,  60, /* 3800-3807 */
 59,  57,  57,  56,  56,  57,  57,  58, /* 3808-3815 */
 59,  60,  63,  67,  71,  74,  78,  80, /* 3816-3823 */
 85,  97, 110, 122, 134, 139, 139, 139, /* 3824-3831 */
139, 138, 138, 137, 136, 135, 137, 147, /* 3832-3839 */
156, 165, 175, 178, 175, 172, 169, 166, /* 3840-3847 */
163, 160, 157, 153, 153, 161, 168, 175, /* 3848-3855 */
183, 185, 180, 177, 173, 170, 174, 180, /* 3856-3863 */
186, 191, 197, 201, 206, 210, 213, 211, /* 3864-3871 */
202, 193, 184, 176, 167, 158, 150, 142, /* 3872-3879 */
137, 141, 145, 148, 153, 152, 144, 138, /* 3880-3887 */
131, 125, 128, 133, 137, 142, 147, 151, /* 3888-3895 */
155, 158, 163, 160, 151, 143, 135, 126, /* 3896-3903 */
119, 111, 103,  96,  90,  84,  79,  76, /* 3904-3911 */
 74,  71,  69,  66,  63,  61,  59,  58, /* 3912-3919 */
 57,  56,  57,  57,  58,  59,  61,  63, /* 3920-3927 */
 65,  67,  70,  72,  75,  78,  81,  84, /* 3928-3935 */
 90, 103, 117, 130, 142, 154, 166, 176, /* 3936-3943 */
186, 195, 194, 190, 186, 182, 178, 174, /* 3944-3951 */
169, 164, 159, 155, 150, 146, 142, 139, /* 3952-3959 */
136, 133, 130, 128, 126, 124, 122, 121, /* 3960-3967 */
120, 120, 119, 119, 119, 119, 119, 120, /* 3968-3975 */
120, 121, 123, 135, 146, 156, 167, 176, /* 3976-3983 */
185, 194, 201, 208, 214, 219, 223, 227, /* 3984-3991 */
229, 229, 226, 223, 220, 218, 215, 212, /* 3992-3999 */
210, 207, 205, 199, 186, 173, 161, 158, /* 4000-4007 */
154, 150, 147, 139, 125, 113, 100,  89, /* 4008-4015 */
 78,  68,  58,  49,  44,  47,  52,  56, /* 4016-4023 */
 62,  62,  56,  52,  47,  43,  39,  36, /* 4024-4031 */
 33,  30,  30,  39,  48,  58,  67,  76, /* 4032-4039 */
 85,  94, 103, 112, 111, 107, 103,  99, /* 4040-4047 */
 96,  91,  87,  84,  80,  82,  91,  99, /* 4048-4055 */
107, 115, 115, 111, 108, 105, 104, 111, /* 4056-4063 */
119, 127, 134, 136, 132, 128, 124, 120, /* 4064-4071 */
116, 113, 109, 105, 103, 101,  98,  96, /* 4072-4079 */
 94,  99, 109, 118, 128, 138, 139, 137, /* 4080-4087 */
135, 133, 132, 141, 149, 156, 165, 169, /* 4088-4095 */
166, 163, 160, 155, 158, 164, 168, 173, /* 4096-4103 */
178, 181, 184, 186, 188, 190, 191, 192, /* 4104-4111 */
193, 193, 193, 192, 191, 190, 188, 187, /* 4112-4119 */
185, 183, 181, 175, 162, 150, 138, 127, /* 4120-4127 */
116, 106,  97,  88,  80,  73,  67,  62, /* 4128-4135 */
 57,  57,  64,  71,  78,  85,  85,  82, /* 4136-4143 */
 81,  79,  78,  86,  94, 102, 110, 113, /* 4144-4151 */
110, 108, 106, 104, 102, 100,  98,  96, /* 4152-4159 */
 95,  94,  93,  93,  92,  92,  93,  93, /* 4160-4167 */
 94,  96,  97,  98, 100, 102, 106, 117, /* 4168-4175 */
128, 140, 150, 161, 170, 179, 188, 195, /* 4176-4183 */
195, 191, 189, 186, 185, 191, 196, 199, /* 4184-4191 */
202, 204, 206, 208, 209, 210, 211, 211, /* 4192-4199 */
211, 210, 209, 208, 207, 205, 203, 197, /* 4200-4207 */
184, 172, 160, 149, 144, 144, 143, 142, /* 4208-4215 */
141, 141, 141, 140, 141, 136, 126, 116, /* 4216-4223 */
107,  99,  98, 101, 102, 104, 105,  99, /* 4224-4231 */
 91,  85,  78,  76,  81,  85,  89,  94, /* 4232-4239 */
 92,  87,  82,  77,  73,  69,  66,  63, /* 4240-4247 */
 59,  61,  70,  77,  85,  93,  94,  92, /* 4248-4255 */
 90,  88,  87,  85,  84,  82,  82,  85, /* 4256-4263 */
 94, 103, 112, 121, 122, 120, 119, 118, /* 4264-4271 */
117, 125, 132, 139, 146, 150, 147, 146, /* 4272-4279 */
144, 141, 139, 134, 135, 144, 150, 162, /* 4280-4287 */
173, 183, 192, 195, 192, 189, 185, 180, /* 4288-4295 */
182, 187, 190, 193, 195, 189, 181, 174, /* 4296-4303 */
166, 158, 151, 144, 137, 130, 124, 118, /* 4304-4311 */
113, 107, 104, 109, 115, 120, 127, 129, /* 4312-4319 */
125, 121, 118, 114, 117, 123, 129, 134, /* 4320-4327 */
138, 134, 129, 125, 120, 116, 111, 107, /* 4328-4335 */
103,  99,  95,  92,  89,  87,  86,  93, /* 4336-4343 */
101, 108, 117, 120, 118, 108,  90,  77, /* 4344-4351 */
 66,  58,  52,  46,  43,  41,  40,  40, /* 4352-4359 */
 40,  45,  58,  69,  81,  93,  98, 100, /* 4360-4367 */
102, 104, 107, 110, 113, 115, 116, 120, /* 4368-4375 */
131, 140, 149, 158, 160, 157, 156, 154, /* 4376-4383 */
153, 151, 149, 147, 145, 143, 142, 140, /* 4384-4391 */
139, 138, 143, 152, 161, 169, 176, 175, /* 4392-4399 */
172, 170, 168, 178, 196, 210, 222, 232, /* 4400-4407 */
239, 243, 242, 240, 238, 236, 232, 229, /* 4408-4415 */
226, 223, 220, 217, 215, 212, 210, 202, /* 4416-4423 */
190, 180, 169, 158, 148, 138, 129, 120, /* 4424-4431 */
112, 104,  98,  91,  85,  81,  76,  72, /* 4432-4439 */
 68,  66,  64,  61,  60,  59,  58,  58, /* 4440-4447 */
 58,  58,  65,  75,  85,  95, 104, 113, /* 4448-4455 */
122, 127, 120, 111,  98,  88,  80,  74, /* 4456-4463 */
 69,  64,  60,  56,  53,  51,  48,  47, /* 4464-4471 */
 46,  50,  60,  70,  81,  91,  95,  95, /* 4472-4479 */
 96,  96,  97,  97,  98,  98,  98,  99, /* 4480-4487 */
100, 101, 102, 103, 110, 121, 132, 142, /* 4488-4495 */
151, 161, 169, 177, 185, 192, 199, 205, /* 4496-4503 */
209, 214, 211, 204, 197, 190, 183, 189, /* 4504-4511 */
204, 214, 223, 226, 221, 216, 209, 203, /* 4512-4519 */
195, 188, 180, 172, 165, 157, 150, 143, /* 4520-4527 */
136, 133, 136, 140, 143, 147, 145, 138, /* 4528-4535 */
132, 126, 121, 124, 128, 131, 135, 136, /* 4536-4543 */
129, 123, 117, 111, 105,  99,  94,  88, /* 4544-4551 */
 84,  89,  96, 103, 110, 113, 108, 103, /* 4552-4559 */
 98,  93,  94,  99, 103, 108, 100,  82, /* 4560-4567 */
 67,  55,  44,  38,  41,  45,  49,  55, /* 4568-4575 */
 55,  51,  50,  48,  47,  46,  46,  46, /* 4576-4583 */
 46,  47,  48,  50,  52,  54,  62,  75, /* 4584-4591 */
 87, 100, 113, 124, 135, 145, 156, 162, /* 4592-4599 */
160, 159, 157, 154, 158, 165, 171, 177, /* 4600-4607 */
183, 180, 175, 171, 166, 164, 169, 174, /* 4608-4615 */
178, 183, 187, 192, 208, 221, 231, 238, /* 4616-4623 */
242, 244, 243, 241, 239, 233, 222, 211, /* 4624-4631 */
206, 206, 203, 202, 200, 198, 195, 193, /* 4632-4639 */
191, 185, 172, 160, 147, 136, 126, 116, /* 4640-4647 */
107,  99,  90,  81,  73,  65,  58,  52, /* 4648-4655 */
 46,  42,  38,  35,  38,  46,  54,  62, /* 4656-4663 */
 70,  78,  86,  93, 101, 108, 114, 120, /* 4664-4671 */
125, 131, 123, 101,  85,  71,  59,  57, /* 4672-4679 */
 59,  61,  64,  68,  72,  78,  84,  90, /* 4680-4687 */
 96, 101, 107, 113, 118, 123, 128, 132, /* 4688-4695 */
137, 140, 144, 147, 150, 153, 149, 141, /* 4696-4703 */
133, 125, 119, 120, 123, 125, 128, 131, /* 4704-4711 */
135, 138, 141, 144, 146, 149, 151, 153, /* 4712-4719 */
155, 148, 140, 132, 124, 117, 110, 103, /* 4720-4727 */
106, 112, 115, 117, 118, 118, 118, 126, /* 4728-4735 */
135, 143, 153, 160, 158, 155, 152, 147, /* 4736-4743 */
148, 153, 157, 161, 165, 169, 172, 175, /* 4744-4751 */
177, 180, 181, 183, 184, 185, 186, 185, /* 4752-4759 */
185, 184, 183, 173, 162, 152, 141, 133, /* 4760-4767 */
133, 133, 133, 133, 134, 134, 135, 136, /* 4768-4775 */
136, 138, 139, 140, 141, 139, 127, 104, /* 4776-4783 */
 83,  65,  49,  36,  26,  17,  11,   7, /* 4784-4791 */
  5,   5,   4,   4,  11,  20,  31,  43, /* 4792-4799 */
 55,  67,  79,  90, 101, 103, 104, 104, /* 4800-4807 */
104, 104, 105, 104, 105, 105, 105, 106, /* 4808-4815 */
107, 108, 109, 111, 112, 114, 116, 120, /* 4816-4823 */
131, 141, 151, 161, 166, 167, 169, 171, /* 4824-4831 */
172, 179, 188, 194, 203, 221, 235, 244, /* 4832-4839 */
248, 252, 253, 250, 248, 245, 242, 242, /* 4840-4847 */
241, 239, 237, 234, 231, 228, 225, 222, /* 4848-4855 */
219, 216, 213, 211, 208, 206, 203, 192, /* 4856-4863 */
179, 167, 156, 145, 135, 125, 117, 108, /* 4864-4871 */
100,  94,  88,  89,  93,  96, 100, 103, /* 4872-4879 */
107, 111, 115, 119, 118, 112, 107, 102, /* 4880-4887 */
 97,  91,  87,  76,  56,  42,  31,  22, /* 4888-4895 */
 15,  10,  11,  17,  24,  32,  41,  50, /* 4896-4903 */
 59,  69,  78,  85,  86,  86,  86,  86, /* 4904-4911 */
 86,  86,  86,  87,  87,  94, 103, 111, /* 4912-4919 */
120, 127, 128, 129, 130, 129, 128, 126, /* 4920-4927 */
124, 122, 120, 118, 117, 116, 115, 116, /* 4928-4935 */
124, 132, 139, 147, 155, 162, 168, 174, /* 4936-4943 */
180, 187, 194, 199, 201, 201, 200, 198, /* 4944-4951 */
195, 192, 192, 197, 200, 204, 206, 202, /* 4952-4959 */
195, 189, 183, 178, 180, 181, 182, 183, /* 4960-4967 */
180, 172, 164, 157, 150, 142, 135, 128, /* 4968-4975 */
122, 116, 110, 105, 101,  96,  96, 101, /* 4976-4983 */
106, 111, 116, 121, 125, 130, 134, 136, /* 4984-4991 */
131, 125, 120, 115, 110, 104, 100,  93, /* 4992-4999 */
 74,  57,  45,  35,  26,  21,  16,  14, /* 5000-5007 */
 13,  13,  16,  26,  36,  48,  60,  66, /* 5008-5015 */
 69,  72,  74,  77,  87,  96, 105, 114, /* 5016-5023 */
123, 131, 138, 145, 152, 158, 163, 168, /* 5024-5031 */
172, 176, 179, 182, 184, 186, 187, 188, /* 5032-5039 */
188, 188, 188, 180, 171, 162, 153, 144, /* 5040-5047 */
136, 128, 120, 113, 107, 102,  97,  93, /* 5048-5055 */
 89,  92,  98, 104, 110, 114, 112, 109, /* 5056-5063 */
107, 105, 107, 113, 120, 126, 132, 137, /* 5064-5071 */
143, 148, 153, 156, 151, 147, 142, 137, /* 5072-5079 */
132, 128, 123, 119, 115, 118, 124, 128, /* 5080-5087 */
134, 137, 134, 130, 127, 123, 124, 130, /* 5088-5095 */
135, 139, 144, 142, 138, 134, 130, 127, /* 5096-5103 */
132, 137, 144, 150, 155, 158, 161, 163, /* 5104-5111 */
165, 160, 153, 146, 139, 133, 135, 137, /* 5112-5119 */
139, 141, 143, 145, 147, 148, 149, 145, /* 5120-5127 */
137, 130, 123, 117, 111, 105,  99,  94, /* 5128-5135 */
 89,  85,  82,  79,  76,  74,  72,  71, /* 5136-5143 */
 71,  73,  82,  91,  99, 108, 116, 124, /* 5144-5151 */
132, 139, 146, 153, 159, 163, 168, 173, /* 5152-5159 */
176, 179, 181, 183, 181, 173, 166, 158, /* 5160-5167 */
151, 144, 137, 130, 124, 118, 112, 107, /* 5168-5175 */
103,  99,  96,  93,  90,  88,  87,  86, /* 5176-5183 */
 85,  85,  85,  86,  95, 104, 113, 121, /* 5184-5191 */
129, 137, 145, 151, 158, 165, 172, 178, /* 5192-5199 */
183, 187, 189, 191, 192, 192, 192, 191, /* 5200-5207 */
190, 189, 187, 186, 184, 182, 179, 176, /* 5208-5215 */
165, 154, 143, 133, 123, 114, 105,  97, /* 5216-5223 */
 89,  82,  76,  71,  66,  63,  67,  73, /* 5224-5231 */
 78,  84,  87,  84,  82,  81,  79,  78, /* 5232-5239 */
 77,  76,  75,  75,  74,  75,  75,  76, /* 5240-5247 */
 77,  78,  79,  81,  82,  84,  87,  89, /* 5248-5255 */
 91,  95, 105, 116, 126, 137, 143, 143, /* 5256-5263 */
144, 145, 145, 150, 159, 166, 173, 180, /* 5264-5271 */
186, 191, 196, 200, 201, 195, 190, 184, /* 5272-5279 */
178, 178, 181, 183, 185, 186, 188, 189, /* 5280-5287 */
190, 192, 191, 184, 177, 168, 159, 151, /* 5288-5295 */
142, 133, 125, 118, 111, 105, 100,  95, /* 5296-5303 */
 90,  86,  83,  80,  78,  82,  90,  96, /* 5304-5311 */
104, 110, 117, 124, 130, 136, 138, 134, /* 5312-5319 */
131, 127, 124, 126, 130, 134, 139, 142, /* 5320-5327 */
138, 134, 130, 126, 124, 129, 133, 137, /* 5328-5335 */
141, 139, 134, 129, 125, 121, 116, 112, /* 5336-5343 */
108, 104, 105, 111, 116, 121, 127, 126, /* 5344-5351 */
122, 120, 117, 115, 120, 125, 131, 136, /* 5352-5359 */
138, 134, 130, 126, 123, 125, 130, 134, /* 5360-5367 */
139, 143, 147, 151, 154, 158, 160, 162, /* 5368-5375 */
164, 166, 167, 168, 168, 170, 171, 172, /* 5376-5383 */
172, 171, 169, 167, 161, 149, 138, 128, /* 5384-5391 */
117, 113, 112, 111, 111, 111, 111, 111, /* 5392-5399 */
112, 112, 110, 101,  94,  87,  80,  79, /* 5400-5407 */
 82,  84,  87,  88,  83,  78,  74,  69, /* 5408-5415 */
 67,  72,  77,  82,  87,  93,  98, 103, /* 5416-5423 */
108, 111, 108, 104,  99,  96,  92,  88, /* 5424-5431 */
 85,  82,  79,  77,  75,  74,  73,  72, /* 5432-5439 */
 72,  72,  73,  74,  75,  77,  79,  81, /* 5440-5447 */
 83,  86,  89,  92,  95,  98, 101, 104, /* 5448-5455 */
108, 111, 117, 129, 140, 151, 162, 171, /* 5456-5463 */
181, 190, 198, 204, 202, 199, 197, 193, /* 5464-5471 */
193, 199, 206, 210, 214, 212, 205, 198, /* 5472-5479 */
191, 185, 186, 187, 189, 190, 191, 193, /* 5480-5487 */
194, 195, 195, 196, 196, 195, 195, 194, /* 5488-5495 */
193, 192, 190, 189, 184, 173, 163, 153, /* 5496-5503 */
142, 138, 138, 137, 136, 135, 128, 119, /* 5504-5511 */
112, 105, 101, 104, 105, 108, 111, 108, /* 5512-5519 */
102,  97,  91,  87,  82,  78,  75,  71, /* 5520-5527 */
 71,  77,  83,  89,  96,  97,  94,  92, /* 5528-5535 */
 90,  89,  95, 101, 107, 113, 116, 113, /* 5536-5543 */
110, 108, 105, 108, 114, 119, 124, 128, /* 5544-5551 */
126, 123, 120, 117, 114, 111, 109, 106, /* 5552-5559 */
104, 107, 113, 118, 125, 131, 131, 130, /* 5560-5567 */
129, 126, 126, 131, 135, 139, 143, 147, /* 5568-5575 */
150, 154, 157, 159, 155, 150, 145, 140, /* 5576-5583 */
135, 130, 125, 121, 117, 113, 110, 107, /* 5584-5591 */
104, 102, 107, 113, 119, 125, 128, 126, /* 5592-5599 */
124, 122, 120, 123, 130, 136, 141, 146, /* 5600-5607 */
144, 142, 139, 136, 136, 141, 145, 150, /* 5608-5615 */
154, 153, 149, 146, 142, 139, 142, 146, /* 5616-5623 */
149, 153, 154, 150, 145, 141, 137, 137, /* 5624-5631 */
141, 144, 147, 150, 153, 156, 159, 161, /* 5632-5639 */
161, 155, 149, 143, 137, 131, 125, 120, /* 5640-5647 */
115, 111, 113, 117, 120, 124, 125, 120, /* 5648-5655 */
117, 115, 113, 111, 108, 105, 101,  97, /* 5656-5663 */
 94,  91,  88,  86,  86,  93,  99, 105, /* 5664-5671 */
111, 113, 111, 110, 108, 107, 105, 104, /* 5672-5679 */
103, 102, 101, 100, 100, 100, 100, 100, /* 5680-5687 */
100, 101, 101, 102, 109, 118, 126, 134, /* 5688-5695 */
142, 150, 157, 163, 170, 175, 180, 184, /* 5696-5703 */
188, 190, 186, 181, 175, 169, 163, 157, /* 5704-5711 */
152, 146, 141, 136, 131, 127, 123, 119, /* 5712-5719 */
116, 113, 111, 108, 108, 115, 120, 126, /* 5720-5727 */
132, 133, 131, 129, 127, 125, 123, 121, /* 5728-5735 */
119, 117, 117, 124, 129, 135, 140, 146, /* 5736-5743 */
150, 155, 159, 162, 160, 157, 154, 150, /* 5744-5751 */
148, 150, 152, 153, 154, 151, 144, 138, /* 5752-5759 */
131, 125, 120, 114, 109, 104, 102, 106, /* 5760-5767 */
109, 113, 117, 121, 125, 129, 132, 135, /* 5768-5775 */
131, 126, 122, 117, 114, 117, 120, 123, /* 5776-5783 */
125, 128, 131, 134, 137, 139, 141, 143, /* 5784-5791 */
144, 146, 145, 138, 131, 124, 117, 111, /* 5792-5799 */
104,  99,  93,  89,  90,  94,  97, 101, /* 5800-5807 */
105, 109, 112, 116, 119, 123, 126, 128, /* 5808-5815 */
131, 133, 135, 137, 138, 140, 141, 141, /* 5816-5823 */
142, 142, 142, 142, 142, 141, 140, 139, /* 5824-5831 */
132, 124, 115, 106, 101, 101, 101, 102, /* 5832-5839 */
104, 107, 109, 112, 114, 114, 115, 115, /* 5840-5847 */
115, 115, 114, 106,  98,  91,  85,  78, /* 5848-5855 */
 73,  67,  63,  59,  62,  67,  72,  77, /* 5856-5863 */
 81,  78,  76,  74,  73,  76,  83,  89, /* 5864-5871 */
 96, 102, 108, 114, 120, 126, 130, 127, /* 5872-5879 */
126, 123, 121, 118, 116, 114, 112, 110, /* 5880-5887 */
115, 122, 127, 134, 138, 136, 135, 133, /* 5888-5895 */
132, 134, 141, 146, 152, 157, 156, 154, /* 5896-5903 */
151, 148, 148, 153, 158, 163, 167, 172, /* 5904-5911 */
176, 180, 183, 186, 189, 192, 194, 195, /* 5912-5919 */
196, 197, 198, 198, 198, 197, 197, 196, /* 5920-5927 */
194, 193, 191, 189, 188, 188, 185, 176, /* 5928-5935 */
166, 155, 145, 135, 125, 116, 108, 100, /* 5936-5943 */
100, 101, 103, 105, 105, 100,  95,  91, /* 5944-5951 */
 87,  87,  92,  97, 101, 105, 103, 100, /* 5952-5959 */
 97,  94,  94,  99, 104, 109, 115, 116, /* 5960-5967 */
113, 110, 108, 106, 105, 103, 101, 100, /* 5968-5975 */
100, 107, 113, 120, 126, 133, 139, 144, /* 5976-5983 */
150, 155, 153, 150, 147, 143, 141, 145, /* 5984-5991 */
149, 153, 157, 156, 151, 147, 143, 139, /* 5992-5999 */
141, 145, 148, 152, 153, 149, 144, 140, /* 6000-6007 */
135, 135, 139, 142, 146, 149, 146, 142, /* 6008-6015 */
138, 133, 129, 125, 121, 117, 114, 111, /* 6016-6023 */
109, 109, 108, 108, 112, 118, 123, 128, /* 6024-6031 */
131, 129, 126, 124, 121, 119, 116, 114, /* 6032-6039 */
113, 111, 115, 122, 127, 133, 139, 144, /* 6040-6047 */
150, 154, 159, 159, 155, 151, 146, 143, /* 6048-6055 */
144, 148, 151, 154, 155, 150, 145, 140, /* 6056-6063 */
137, 132, 128, 124, 120, 116, 119, 124, /* 6064-6071 */
128, 133, 136, 133, 129, 126, 123, 124, /* 6072-6079 */
128, 133, 137, 141, 145, 149, 152, 155, /* 6080-6087 */
156, 151, 146, 140, 135, 130, 125, 120, /* 6088-6095 */
115, 111, 107, 103, 100,  96,  95, 101, /* 6096-6103 */
106, 111, 117, 122, 127, 132, 137, 141, /* 6104-6111 */
139, 134, 130, 127, 124, 122, 119, 116, /* 6112-6119 */
112, 108, 104, 100,  97,  94,  97, 103, /* 6120-6127 */
107, 113, 118, 123, 128, 133, 137, 141, /* 6128-6135 */
145, 148, 151, 154, 156, 158, 159, 160, /* 6136-6143 */
160, 153, 145, 138, 130, 127, 128, 128, /* 6144-6151 */
129, 130, 131, 133, 134, 135, 137, 137, /* 6152-6159 */
138, 139, 139, 136, 128, 121, 113, 106, /* 6160-6167 */
106, 107, 108, 110, 110, 104,  98,  93, /* 6168-6175 */
 88,  83,  79,  75,  71,  68,  65,  63, /* 6176-6183 */
 61,  60,  61,  68,  75,  82,  90,  97, /* 6184-6191 */
104, 111, 118, 124, 130, 135, 140, 145, /* 6192-6199 */
147, 144, 140, 135, 130, 126, 121, 117, /* 6200-6207 */
115, 113, 111, 109, 106, 103, 100,  97, /* 6208-6215 */
 95,  93,  91,  94, 102, 108, 115, 122, /* 6216-6223 */
123, 122, 121, 120, 121, 127, 133, 139, /* 6224-6231 */
146, 148, 146, 144, 142, 139, 137, 135, /* 6232-6239 */
133, 131, 130, 136, 141, 147, 153, 156, /* 6240-6247 */
154, 152, 149, 147, 150, 156, 161, 166, /* 6248-6255 */
170, 173, 176, 178, 180, 182, 183, 184, /* 6256-6263 */
185, 185, 186, 185, 185, 184, 182, 175, /* 6264-6271 */
167, 160, 152, 145, 138, 131, 125, 120, /* 6272-6279 */
114, 110, 105, 101,  99, 102, 106, 110, /* 6280-6287 */
114, 118, 122, 126, 129, 133, 131, 128, /* 6288-6295 */
124, 121, 118, 122, 127, 131, 136, 136, /* 6296-6303 */
132, 128, 123, 119, 114, 110, 107, 103, /* 6304-6311 */
100,  97,  95,  93,  91,  93,  99, 104, /* 6312-6319 */
109, 115, 116, 114, 113, 113, 112, 111, /* 6320-6327 */
110, 109, 108, 108, 108, 108, 107, 107, /* 6328-6335 */
108, 108, 109, 110, 112, 113, 114, 115, /* 6336-6343 */
117, 118, 120, 121, 123, 124, 126, 127, /* 6344-6351 */
129, 130, 133, 140, 148, 155, 162, 166, /* 6352-6359 */
165, 165, 165, 163, 167, 172, 176, 181, /* 6360-6367 */
184, 188, 191, 194, 196, 195, 190, 185, /* 6368-6375 */
179, 174, 169, 163, 158, 153, 148, 143, /* 6376-6383 */
139, 134, 130, 129, 132, 135, 137, 141, /* 6384-6391 */
146, 150, 154, 157, 158, 152, 146, 141, /* 6392-6399 */
135, 131, 132, 133, 134, 134, 131, 125, /* 6400-6407 */
120, 114, 109, 105, 101,  96,  92,  89, /* 6408-6415 */
 86,  83,  81,  79,  82,  87,  92,  97, /* 6416-6423 */
101, 101,  99,  98,  96,  97, 103, 109, /* 6424-6431 */
114, 119, 119, 117, 115, 113, 111, 110, /* 6432-6439 */
108, 106, 104, 105, 111, 116, 120, 125, /* 6440-6447 */
125, 123, 121, 120, 118, 116, 114, 113, /* 6448-6455 */
111, 110, 108, 107, 107, 106, 110, 116, /* 6456-6463 */
121, 127, 133, 138, 143, 147, 152, 153, /* 6464-6471 */
150, 147, 144, 141, 138, 134, 131, 128, /* 6472-6479 */
124, 122, 119, 118, 117, 117, 116, 115, /* 6480-6487 */
113, 111, 109, 108, 107, 105, 105, 104, /* 6488-6495 */
104, 104, 103, 104, 104, 105, 106, 106, /* 6496-6503 */
112, 119, 126, 133, 140, 146, 152, 157, /* 6504-6511 */
162, 164, 162, 159, 157, 154, 155, 158, /* 6512-6519 */
160, 163, 166, 169, 171, 173, 174, 176, /* 6520-6527 */
176, 177, 177, 177, 177, 177, 176, 175, /* 6528-6535 */
173, 165, 157, 149, 142, 136, 136, 135, /* 6536-6543 */
134, 134, 130, 122, 117, 110, 105,  99, /* 6544-6551 */
 94,  90,  86,  84,  87,  91,  94,  98, /* 6552-6559 */
101, 105, 108, 112, 115, 118, 121, 124, /* 6560-6567 */
126, 126, 121, 116, 112, 107, 107, 110, /* 6568-6575 */
113, 117, 120, 117, 112, 107, 102,  98, /* 6576-6583 */
 93,  88,  85,  82,  83,  87,  91,  95, /* 6584-6591 */
 99, 103, 108, 112, 116, 118, 115, 112, /* 6592-6599 */
110, 107, 108, 112, 116, 120, 123, 127, /* 6600-6607 */
130, 134, 136, 139, 142, 144, 147, 149, /* 6608-6615 */
151, 153, 154, 155, 156, 150, 144, 139, /* 6616-6623 */
133, 128, 122, 117, 113, 109, 105, 102, /* 6624-6631 */
 99,  96,  95,  99, 104, 109, 114, 117, /* 6632-6639 */
115, 114, 113, 112, 111, 111, 110, 109, /* 6640-6647 */
109, 109, 109, 109, 109, 112, 119, 125, /* 6648-6655 */
132, 139, 145, 151, 157, 162, 167, 171, /* 6656-6663 */
175, 178, 182, 183, 181, 178, 174, 169, /* 6664-6671 */
164, 158, 152, 147, 143, 143, 145, 147, /* 6672-6679 */
149, 149, 145, 141, 137, 133, 134, 137, /* 6680-6687 */
140, 143, 145, 142, 138, 135, 132, 128, /* 6688-6695 */
125, 122, 119, 117, 115, 113, 111, 110, /* 6696-6703 */
108, 108, 107, 108, 107, 110, 117, 123, /* 6704-6711 */
130, 136, 138, 138, 137, 137, 136, 141, /* 6712-6719 */
146, 151, 156, 161, 165, 169, 172, 175, /* 6720-6727 */
174, 170, 165, 161, 156, 152, 148, 143, /* 6728-6735 */
139, 136, 132, 128, 126, 122, 124, 128, /* 6736-6743 */
132, 136, 140, 138, 135, 132, 130, 128, /* 6744-6751 */
126, 123, 121, 118, 116, 114, 113, 113, /* 6752-6759 */
113, 119, 126, 131, 136, 138, 135, 132, /* 6760-6767 */
129, 126, 128, 131, 135, 138, 141, 138, /* 6768-6775 */
135, 132, 128, 127, 130, 133, 136, 139, /* 6776-6783 */
138, 134, 131, 127, 123, 120, 117, 114, /* 6784-6791 */
111, 108, 106, 103, 102, 100,  99,  99, /* 6792-6799 */
 98,  98,  98,  98,  98,  98,  99, 101, /* 6800-6807 */
109, 116, 123, 129, 135, 141, 147, 152, /* 6808-6815 */
156, 155, 152, 150, 147, 144, 141, 138, /* 6816-6823 */
135, 132, 133, 137, 140, 144, 146, 144, /* 6824-6831 */
141, 138, 134, 131, 128, 125, 122, 120, /* 6832-6839 */
117, 115, 113, 111, 110, 108, 107, 106, /* 6840-6847 */
105, 104, 104, 106, 107, 108, 113, 120, /* 6848-6855 */
125, 130, 134, 134, 132, 130, 128, 126, /* 6856-6863 */
124, 122, 121, 119, 121, 126, 131, 136, /* 6864-6871 */
140, 144, 148, 152, 155, 157, 153, 149, /* 6872-6879 */
145, 141, 137, 133, 129, 125, 122, 124, /* 6880-6887 */
127, 130, 133, 137, 140, 143, 146, 148, /* 6888-6895 */
147, 142, 138, 134, 130, 131, 133, 135, /* 6896-6903 */
136, 138, 140, 141, 143, 145, 142, 136, /* 6904-6911 */
131, 125, 120, 115, 110, 105, 101,  98, /* 6912-6919 */
101, 104, 107, 110, 110, 106, 104, 101, /* 6920-6927 */
 98,  95,  93,  91,  89,  89,  94,  99, /* 6928-6935 */
104, 109, 113, 118, 122, 126, 130, 135, /* 6936-6943 */
139, 144, 148, 150, 151, 152, 152, 151, /* 6944-6951 */
151, 150, 150, 149, 148, 141, 134, 126, /* 6952-6959 */
120, 113, 106, 100,  95,  89,  88,  91, /* 6960-6967 */
 94,  96,  99, 101, 103, 105, 107, 108, /* 6968-6975 */
105, 101,  98,  95,  95,  98, 102, 105, /* 6976-6983 */
108, 111, 115, 117, 120, 123, 126, 128, /* 6984-6991 */
130, 133, 135, 136, 138, 139, 140, 137, /* 6992-6999 */
133, 129, 125, 122, 124, 125, 127, 129, /* 7000-7007 */
128, 124, 121, 118, 115, 117, 120, 122, /* 7008-7015 */
125, 127, 124, 122, 120, 118, 116, 114, /* 7016-7023 */
113, 111, 110, 110, 109, 108, 108, 109, /* 7024-7031 */
114, 119, 126, 133, 137, 137, 138, 137, /* 7032-7039 */
136, 138, 142, 146, 149, 151, 149, 147, /* 7040-7047 */
145, 143, 144, 147, 150, 153, 156, 159, /* 7048-7055 */
162, 164, 166, 168, 170, 172, 173, 174, /* 7056-7063 */
172, 167, 162, 157, 153, 152, 153, 154, /* 7064-7071 */
155, 154, 150, 146, 142, 138, 137, 139, /* 7072-7079 */
141, 142, 144, 142, 138, 134, 131, 129, /* 7080-7087 */
132, 133, 135, 138, 140, 142, 144, 146, /* 7088-7095 */
147, 144, 140, 137, 133, 129, 126, 122, /* 7096-7103 */
119, 116, 116, 119, 121, 124, 127, 126, /* 7104-7111 */
123, 121, 119, 117, 115, 113, 112, 110, /* 7112-7119 */
108, 107, 106, 105, 105, 104, 104, 106, /* 7120-7127 */
107, 108, 110, 111, 110, 110, 110, 110, /* 7128-7135 */
109, 110, 110, 115, 120, 126, 131, 135, /* 7136-7143 */
135, 135, 134, 134, 136, 141, 145, 149, /* 7144-7151 */
152, 152, 150, 148, 146, 144, 141, 139, /* 7152-7159 */
137, 135, 133, 131, 130, 129, 128, 131, /* 7160-7167 */
136, 140, 144, 147, 146, 144, 143, 141, /* 7168-7175 */
139, 138, 136, 135, 133, 136, 139, 143, /* 7176-7183 */
146, 149, 152, 155, 158, 160, 162, 164, /* 7184-7191 */
165, 166, 167, 167, 167, 167, 166, 166, /* 7192-7199 */
165, 164, 163, 161, 159, 158, 156, 154, /* 7200-7207 */
152, 150, 147, 145, 143, 141, 138, 135, /* 7208-7215 */
133, 131, 127, 121, 115, 109, 103,  96, /* 7216-7223 */
 89,  82,  76,  71,  71,  72,  73,  75, /* 7224-7231 */
 74,  70,  67,  65,  63,  61,  59,  58, /* 7232-7239 */
 57,  56,  55,  55,  56,  56,  59,  66, /* 7240-7247 */
 72,  78,  84,  91,  96, 102, 107, 113, /* 7248-7255 */
117, 122, 127, 131, 135, 138, 141, 144, /* 7256-7263 */
146, 145, 141, 138, 134, 131, 128, 124, /* 7264-7271 */
121, 118, 118, 121, 123, 126, 130, 132, /* 7272-7279 */
135, 138, 140, 142, 139, 137, 133, 130, /* 7280-7287 */
130, 133, 135, 137, 139, 142, 143, 145, /* 7288-7295 */
147, 148, 144, 140, 137, 133, 131, 134, /* 7296-7303 */
135, 137, 138, 136, 132, 128, 125, 125, /* 7304-7311 */
128, 131, 134, 136, 135, 131, 127, 123, /* 7312-7319 */
119, 120, 122, 124, 126, 127, 124, 121, /* 7320-7327 */
118, 116, 115, 119, 121, 124, 127, 126, /* 7328-7335 */
123, 121, 119, 117, 120, 123, 127, 130, /* 7336-7343 */
133, 136, 138, 141, 143, 146, 149, 151, /* 7344-7351 */
153, 154, 156, 157, 158, 159, 157, 152, /* 7352-7359 */
147, 142, 137, 133, 129, 124, 121, 118, /* 7360-7367 */
119, 122, 124, 126, 129, 131, 133, 136, /* 7368-7375 */
138, 140, 142, 144, 145, 146, 142, 138, /* 7376-7383 */
134, 130, 126, 122, 118, 115, 112, 113, /* 7384-7391 */
116, 119, 122, 124, 122, 119, 117, 115, /* 7392-7399 */
113, 111, 111, 111, 111, 111, 111, 109, /* 7400-7407 */
108, 106, 105, 104, 103, 103, 103, 103, /* 7408-7415 */
104, 104, 105, 106, 107, 108, 109, 111, /* 7416-7423 */
112, 114, 115, 117, 118, 120, 122, 124, /* 7424-7431 */
125, 127, 129, 130, 132, 134, 135, 136, /* 7432-7439 */
138, 140, 142, 143, 145, 146, 148, 152, /* 7440-7447 */
159, 165, 170, 175, 180, 185, 189, 192, /* 7448-7455 */
195, 197, 200, 201, 202, 203, 203, 203, /* 7456-7463 */
203, 201, 194, 188, 182, 175, 168, 162, /* 7464-7471 */
156, 150, 144, 139, 134, 129, 125, 121, /* 7472-7479 */
117, 114, 111, 109, 106, 104, 102, 101, /* 7480-7487 */
 99,  98,  97,  96,  96,  96,  96,  98, /* 7488-7495 */
 99, 100, 103, 109, 114, 118, 122, 122, /* 7496-7503 */
121, 119, 118, 116, 115, 114, 112, 111, /* 7504-7511 */
112, 116, 120, 124, 127, 131, 134, 137, /* 7512-7519 */
140, 142, 140, 137, 134, 130, 129, 131, /* 7520-7527 */
133, 135, 136, 134, 131, 127, 125, 123, /* 7528-7535 */
124, 126, 128, 130, 130, 127, 124, 120, /* 7536-7543 */
117, 114, 111, 109, 106, 105, 107, 111, /* 7544-7551 */
114, 117, 118, 116, 114, 112, 110, 109, /* 7552-7559 */
107, 105, 104, 102, 101, 101, 100,  99, /* 7560-7567 */
 99,  99,  98,  98,  99,  99, 100, 100, /* 7568-7575 */
101, 102, 108, 114, 120, 125, 129, 129, /* 7576-7583 */
128, 128, 129, 131, 132, 132, 131, 130, /* 7584-7591 */
133, 136, 139, 143, 144, 141, 139, 137, /* 7592-7599 */
134, 136, 139, 142, 144, 146, 144, 141, /* 7600-7607 */
138, 136, 133, 130, 128, 125, 123, 121, /* 7608-7615 */
119, 118, 116, 114, 113, 112, 111, 111, /* 7616-7623 */
111, 111, 112, 112, 112, 116, 122, 127, /* 7624-7631 */
133, 138, 143, 147, 152, 156, 159, 163, /* 7632-7639 */
165, 167, 169, 168, 164, 159, 155, 151, /* 7640-7647 */
147, 143, 139, 135, 132, 128, 125, 122, /* 7648-7655 */
120, 117, 115, 113, 111, 110, 114, 118, /* 7656-7663 */
122, 126, 129, 127, 126, 124, 123, 125, /* 7664-7671 */
129, 132, 135, 137, 136, 133, 132, 131, /* 7672-7679 */
132, 136, 139, 141, 143, 144, 145, 146, /* 7680-7687 */
146, 145, 141, 136, 131, 127, 122, 118, /* 7688-7695 */
114, 111, 107, 107, 108, 109, 111, 113, /* 7696-7703 */
114, 116, 118, 120, 120, 117, 115, 113, /* 7704-7711 */
110, 111, 113, 115, 117, 119, 118, 116, /* 7712-7719 */
115, 113, 113, 115, 118, 120, 123, 125, /* 7720-7727 */
128, 130, 132, 134, 136, 138, 139, 141, /* 7728-7735 */
140, 137, 134, 131, 128, 126, 123, 120, /* 7736-7743 */
118, 116, 117, 120, 122, 124, 125, 123, /* 7744-7751 */
122, 120, 119, 117, 116, 115, 114, 113, /* 7752-7759 */
112, 112, 112, 111, 111, 111, 111, 111, /* 7760-7767 */
112, 115, 122, 128, 133, 138, 138, 137, /* 7768-7775 */
136, 134, 134, 137, 139, 142, 145, 144, /* 7776-7783 */
143, 141, 139, 138, 136, 134, 133, 131, /* 7784-7791 */
131, 134, 137, 140, 142, 143, 141, 140, /* 7792-7799 */
138, 137, 135, 134, 132, 131, 130, 129, /* 7800-7807 */
128, 128, 128, 127, 128, 127, 127, 127, /* 7808-7815 */
127, 128, 128, 128, 129, 134, 138, 142, /* 7816-7823 */
146, 150, 153, 157, 159, 162, 164, 167, /* 7824-7831 */
168, 169, 170, 171, 172, 171, 172, 171, /* 7832-7839 */
171, 170, 169, 168, 163, 158, 152, 147, /* 7840-7847 */
142, 137, 132, 128, 124, 122, 123, 123, /* 7848-7855 */
124, 124, 121, 118, 115, 112, 111, 114, /* 7856-7863 */
117, 119, 121, 123, 123, 124, 124, 124, /* 7864-7871 */
120, 116, 113, 109, 107, 108, 109, 110, /* 7872-7879 */
111, 112, 113, 114, 115, 116, 117, 118, /* 7880-7887 */
119, 120, 120, 116, 113, 110, 107, 106, /* 7888-7895 */
107, 108, 110, 110, 109, 107, 105, 103, /* 7896-7903 */
101, 100,  98,  97,  96,  97, 101, 104, /* 7904-7911 */
108, 111, 111, 110, 110, 109, 109, 113, /* 7912-7919 */
117, 120, 123, 124, 123, 122, 121, 120, /* 7920-7927 */
120, 119, 118, 117, 117, 116, 116, 116, /* 7928-7935 */
116, 118, 122, 126, 130, 134, 138, 141, /* 7936-7943 */
145, 148, 150, 148, 146, 145, 142, 143, /* 7944-7951 */
145, 148, 151, 155, 157, 159, 160, 160, /* 7952-7959 */
159, 159, 158, 158, 157, 154, 149, 145, /* 7960-7967 */
140, 136, 135, 135, 135, 135, 134, 130, /* 7968-7975 */
127, 123, 120, 117, 114, 111, 109, 107, /* 7976-7983 */
109, 111, 113, 116, 119, 121, 123, 126, /* 7984-7991 */
128, 131, 133, 135, 137, 139, 140, 141, /* 7992-7999 */
142, 143, 144, 144, 145, 145, 146, 143, /* 8000-8007 */
139, 135, 131, 127, 123, 120, 117, 113, /* 8008-8015 */
110, 108, 106, 104, 102, 103, 106, 109, /* 8016-8023 */
112, 115, 115, 114, 113, 112, 112, 116, /* 8024-8031 */
119, 122, 125, 128, 131, 134, 136, 139, /* 8032-8039 */
141, 142, 144, 145, 146, 147, 149, 151, /* 8040-8047 */
153, 154, 154, 154, 153, 151, 150, 148, /* 8048-8055 */
146, 145, 142, 136, 131, 126, 121, 116, /* 8056-8063 */
112, 108, 104, 100,  97,  95,  93,  91, /* 8064-8071 */
 90,  93,  96,  99, 102, 105, 109, 112, /* 8072-8079 */
115, 118, 117, 116, 116, 115, 114, 114, /* 8080-8087 */
113, 112, 112, 111, 111, 111, 111, 111, /* 8088-8095 */
111, 112, 112, 113, 114, 119, 124, 128, /* 8096-8103 */
133, 135, 135, 135, 135, 135, 135, 135, /* 8104-8111 */
135, 135, 136, 139, 143, 147, 150, 151, /* 8112-8119 */
150, 150, 148, 147, 146, 145, 144, 143, /* 8120-8127 */
142, 145, 148, 151, 153, 156, 158, 160, /* 8128-8135 */
162, 164, 168, 170, 172, 173, 172, 171, /* 8136-8143 */
170, 169, 167, 164, 158, 152, 147, 142, /* 8144-8151 */
137, 132, 127, 123, 120, 120, 121, 122, /* 8152-8159 */
122, 122, 118, 116, 113, 110, 108, 106, /* 8160-8167 */
104, 102, 102, 105, 107, 110, 113, 114, /* 8168-8175 */
113, 113, 112, 111, 113, 117, 120, 123, /* 8176-8183 */
125, 124, 123, 121, 120, 121, 124, 126, /* 8184-8191 */
129, 132, 134, 136, 138, 140, 141, 143, /* 8192-8199 */
144, 145, 146, 145, 141, 138, 134, 131, /* 8200-8207 */
130, 131, 132, 132, 133, 134, 134, 135, /* 8208-8215 */
135, 136, 136, 137, 137, 137, 137, 137, /* 8216-8223 */
136, 136, 135, 134, 133, 133, 134, 135, /* 8224-8231 */
135, 135, 134, 132, 130, 128, 126, 124, /* 8232-8239 */
122, 116, 110, 105, 100,  95,  91,  87, /* 8240-8247 */
 84,  81,  81,  83,  85,  87,  89,  92, /* 8248-8255 */
 94,  96,  99, 102, 104, 106, 109, 111, /* 8256-8263 */
113, 115, 116, 118, 120, 122, 124, 126, /* 8264-8271 */
127, 128, 129, 130, 131, 132, 129, 126, /* 8272-8279 */
123, 119, 117, 118, 119, 121, 122, 123, /* 8280-8287 */
125, 126, 128, 129, 127, 124, 122, 119, /* 8288-8295 */
117, 115, 113, 111, 109, 108, 106, 106, /* 8296-8303 */
105, 105, 104, 104, 105, 105, 106, 106, /* 8304-8311 */
107, 108, 109, 113, 118, 123, 128, 133, /* 8312-8319 */
135, 136, 139, 141, 143, 147, 150, 152, /* 8320-8327 */
155, 155, 153, 151, 150, 148, 146, 144, /* 8328-8335 */
143, 141, 140, 139, 138, 137, 136, 137, /* 8336-8343 */
140, 143, 147, 150, 150, 149, 148, 146, /* 8344-8351 */
145, 144, 143, 142, 141, 140, 138, 138, /* 8352-8359 */
138, 138, 140, 144, 148, 151, 154, 157, /* 8360-8367 */
161, 163, 165, 165, 163, 161, 158, 156, /* 8368-8375 */
157, 158, 159, 160, 161, 162, 163, 163, /* 8376-8383 */
163, 162, 158, 154, 150, 146, 142, 138, /* 8384-8391 */
135, 131, 128, 125, 122, 120, 117, 117, /* 8392-8399 */
119, 121, 124, 126, 128, 130, 131, 132, /* 8400-8407 */
133, 130, 128, 125, 123, 121, 120, 119, /* 8408-8415 */
118, 117, 117, 118, 119, 119, 119, 117, /* 8416-8423 */
114, 112, 109, 109, 110, 112, 113, 115, /* 8424-8431 */
116, 118, 119, 121, 122, 119, 117, 115, /* 8432-8439 */
113, 111, 109, 107, 106, 104, 105, 108, /* 8440-8447 */
110, 112, 114, 117, 119, 122, 125, 126, /* 8448-8455 */
124, 123, 121, 120, 118, 117, 115, 114, /* 8456-8463 */
114, 116, 118, 121, 124, 125, 123, 122, /* 8464-8471 */
121, 120, 122, 124, 127, 129, 131, 133, /* 8472-8479 */
135, 137, 139, 140, 142, 143, 144, 145, /* 8480-8487 */
143, 140, 137, 134, 131, 128, 126, 123, /* 8488-8495 */
121, 119, 117, 115, 113, 111, 113, 115, /* 8496-8503 */
118, 122, 126, 130, 133, 134, 136, 135, /* 8504-8511 */
132, 129, 126, 124, 121, 119, 117, 115, /* 8512-8519 */
113, 111, 110, 109, 108, 108, 111, 114, /* 8520-8527 */
117, 120, 120, 119, 119, 118, 118, 117, /* 8528-8535 */
117, 116, 116, 116, 116, 115, 115, 116, /* 8536-8543 */
116, 117, 118, 119, 119, 120, 121, 122, /* 8544-8551 */
123, 123, 124, 125, 126, 127, 131, 135, /* 8552-8559 */
139, 143, 146, 147, 146, 147, 146, 147, /* 8560-8567 */
150, 153, 155, 157, 160, 162, 163, 165, /* 8568-8575 */
166, 163, 160, 158, 155, 154, 154, 155, /* 8576-8583 */
155, 155, 153, 150, 147, 144, 141, 138, /* 8584-8591 */
134, 132, 129, 127, 129, 131, 134, 136, /* 8592-8599 */
136, 134, 132, 129, 125, 122, 119, 117, /* 8600-8607 */
114, 112, 110, 108, 106, 105, 106, 109, /* 8608-8615 */
111, 114, 116, 119, 121, 124, 126, 127, /* 8616-8623 */
125, 123, 122, 120, 121, 123, 125, 126, /* 8624-8631 */
128, 126, 124, 122, 121, 121, 123, 125, /* 8632-8639 */
127, 129, 131, 133, 134, 136, 137, 135, /* 8640-8647 */
132, 130, 128, 127, 128, 129, 130, 131, /* 8648-8655 */
130, 127, 125, 123, 121, 119, 117, 115, /* 8656-8663 */
113, 113, 116, 118, 120, 122, 125, 127, /* 8664-8671 */
129, 131, 133, 134, 136, 137, 138, 138, /* 8672-8679 */
135, 133, 130, 127, 127, 128, 128, 129, /* 8680-8687 */
131, 133, 136, 137, 139, 138, 133, 129, /* 8688-8695 */
125, 122, 120, 120, 120, 121, 121, 121, /* 8696-8703 */
122, 123, 123, 122, 120, 117, 114, 111, /* 8704-8711 */
111, 113, 114, 115, 117, 118, 119, 121, /* 8712-8719 */
122, 122, 120, 117, 115, 113, 113, 116, /* 8720-8727 */
117, 119, 121, 120, 118, 117, 115, 115, /* 8728-8735 */
117, 120, 122, 124, 124, 123, 121, 120, /* 8736-8743 */
119, 118, 117, 117, 116, 116, 119, 122, /* 8744-8751 */
125, 128, 131, 134, 136, 139, 141, 140, /* 8752-8759 */
138, 137, 135, 134, 132, 131, 130, 128, /* 8760-8767 */
129, 132, 134, 137, 139, 141, 143, 145, /* 8768-8775 */
146, 148, 149, 150, 152, 154, 156, 158, /* 8776-8783 */
159, 159, 158, 154, 149, 144, 140, 136, /* 8784-8791 */
136, 135, 134, 134, 134, 134, 133, 133, /* 8792-8799 */
133, 130, 126, 123, 120, 118, 119, 119, /* 8800-8807 */
120, 121, 120, 117, 115, 113, 111, 109, /* 8808-8815 */
108, 106, 105, 105, 109, 112, 115, 118, /* 8816-8823 */
119, 118, 118, 117, 117, 120, 123, 126, /* 8824-8831 */
129, 132, 134, 137, 139, 141, 141, 139, /* 8832-8839 */
138, 136, 135, 136, 138, 139, 141, 141, /* 8840-8847 */
139, 137, 135, 133, 131, 130, 128, 126, /* 8848-8855 */
125, 124, 122, 121, 121, 120, 119, 119, /* 8856-8863 */
119, 119, 121, 124, 127, 130, 133, 137, /* 8864-8871 */
141, 145, 150, 152, 151, 148, 146, 143, /* 8872-8879 */
140, 137, 134, 132, 130, 131, 132, 134, /* 8880-8887 */
135, 137, 138, 140, 141, 142, 144, 144, /* 8888-8895 */
145, 146, 147, 147, 147, 147, 147, 146, /* 8896-8903 */
142, 138, 135, 131, 127, 124, 121, 119, /* 8904-8911 */
116, 117, 119, 120, 122, 123, 121, 119, /* 8912-8919 */
117, 116, 116, 118, 121, 122, 124, 123, /* 8920-8927 */
121, 120, 118, 117, 116, 115, 114, 112, /* 8928-8935 */
114, 116, 119, 122, 124, 127, 129, 132, /* 8936-8943 */
134, 136, 138, 139, 140, 142, 143, 144, /* 8944-8951 */
144, 145, 145, 145, 145, 145, 145, 144, /* 8952-8959 */
144, 143, 142, 141, 141, 142, 142, 142, /* 8960-8967 */
142, 140, 138, 136, 134, 132, 130, 128, /* 8968-8975 */
126, 124, 120, 115, 110, 106, 101,  97, /* 8976-8983 */
 94,  91,  87,  86,  87,  89,  91,  93, /* 8984-8991 */
 93,  91,  90,  89,  89,  91,  94,  97, /* 8992-8999 */
100, 102, 102, 102, 102, 102, 102, 102, /* 9000-9007 */
102, 103, 103, 104, 104, 105, 106, 107, /* 9008-9015 */
112, 116, 121, 125, 127, 127, 128, 128, /* 9016-9023 */
129, 132, 136, 139, 142, 146, 148, 151, /* 9024-9031 */
154, 156, 156, 154, 152, 151, 149, 150, /* 9032-9039 */
151, 153, 154, 155, 152, 150, 147, 145, /* 9040-9047 */
143, 141, 139, 137, 135, 136, 137, 139, /* 9048-9055 */
142, 146, 149, 152, 153, 153, 152, 148, /* 9056-9063 */
144, 141, 137, 137, 138, 138, 138, 138, /* 9064-9071 */
135, 132, 130, 126, 126, 128, 129, 130, /* 9072-9079 */
131, 132, 133, 134, 135, 135, 133, 130, /* 9080-9087 */
127, 125, 125, 126, 127, 128, 128, 128, /* 9088-9095 */
126, 125, 123, 122, 124, 125, 126, 128, /* 9096-9103 */
128, 126, 125, 124, 122, 121, 120, 119, /* 9104-9111 */
117, 117, 117, 116, 115, 115, 116, 119, /* 9112-9119 */
121, 124, 125, 126, 125, 125, 125, 125, /* 9120-9127 */
124, 124, 124, 123, 123, 123, 123, 122, /* 9128-9135 */
123, 125, 126, 128, 129, 131, 132, 134, /* 9136-9143 */
135, 136, 137, 139, 140, 143, 144, 144, /* 9144-9151 */
143, 141, 139, 137, 137, 136, 135, 135, /* 9152-9159 */
135, 135, 135, 135, 134, 134, 134, 134, /* 9160-9167 */
133, 132, 131, 128, 128, 126, 124, 122, /* 9168-9175 */
121, 120, 118, 119, 120, 121, 121, 122, /* 9176-9183 */
123, 124, 125, 126, 128, 128, 129, 130, /* 9184-9191 */
131, 130, 128, 128, 127, 126, 125, 124, /* 9192-9199 */
123, 122, 122, 124, 125, 126, 127, 127, /* 9200-9207 */
126, 125, 113, 117, 122, 126, 128, 128, /* 9208-9215 */
128, 128, 128, 130, 131, 131, 130, 129, /* 9216-9223 */
131, 134, 136, 139, 140, 137, 135, 134, /* 9224-9231 */
131, 133, 135, 138, 139, 141, 139, 137, /* 9232-9239 */
135, 133, 131, 128, 128, 127, 125, 124, /* 9240-9247 */
122, 121, 120, 118, 117, 117, 116, 116, /* 9248-9255 */
116, 116, 117, 117, 117, 120, 125, 128, /* 9256-9263 */
131, 135, 139, 142, 146, 149, 151, 154, /* 9264-9271 */
155, 157, 159, 158, 155, 151, 148, 145, /* 9272-9279 */
142, 139, 135, 132, 130, 128, 127, 125, /* 9280-9287 */
123, 121, 119, 117, 116, 115, 118, 121, /* 9288-9295 */
125, 128, 128, 128, 128, 126, 125, 127, /* 9296-9303 */
128, 130, 132, 134, 133, 131, 130, 129, /* 9304-9311 */
130, 133, 135, 137, 139, 139, 140, 141, /* 9312-9319 */
140, 139, 137, 133, 129, 128, 125, 121, /* 9320-9327 */
118, 117, 113, 113, 114, 115, 117, 117, /* 9328-9335 */
118, 120, 121, 123, 123, 121, 119, 118, /* 9336-9343 */
116, 117, 118, 119, 121, 122, 121, 120, /* 9344-9351 */
119, 118, 118, 119, 121, 123, 125, 127, /* 9352-9359 */
128, 128, 130, 131, 133, 135, 135, 136, /* 9360-9367 */
136, 134, 131, 129, 128, 128, 125, 123, /* 9368-9375 */
121, 121, 121, 123, 125, 126, 127, 125, /* 9376-9383 */
125, 123, 122, 121, 121, 120, 119, 118, /* 9384-9391 */
117, 117, 117, 117, 117, 117, 117, 117, /* 9392-9399 */
117, 120, 125, 128, 131, 135, 135, 134, /* 9400-9407 */
133, 131, 131, 134, 135, 137, 139, 139, /* 9408-9415 */
138, 136, 135, 134, 133, 131, 131, 129, /* 9416-9423 */
129, 131, 134, 135, 137, 138, 136, 135, /* 9424-9431 */
134, 133, 132, 131, 130, 129, 128, 128, /* 9432-9439 */
128, 128, 128, 128, 128, 128, 128, 128, /* 9440-9447 */
128, 128, 128, 128, 128, 131, 134, 137, /* 9448-9455 */
139, 143, 144, 147, 148, 151, 152, 154, /* 9456-9463 */
155, 155, 156, 156, 157, 156, 157, 156, /* 9464-9471 */
156, 156, 155, 155, 151, 147, 143, 140, /* 9472-9479 */
137, 133, 130, 128, 126, 125, 125, 125, /* 9480-9487 */
126, 126, 125, 122, 120, 118, 117, 120, /* 9488-9495 */
121, 123, 125, 125, 125, 126, 126, 126, /* 9496-9503 */
124, 121, 119, 117, 115, 116, 117, 117, /* 9504-9511 */
117, 118, 119, 120, 121, 121, 121, 122, /* 9512-9519 */
123, 124, 124, 121, 119, 117, 115, 114, /* 9520-9527 */
115, 116, 117, 117, 117, 115, 113, 113, /* 9528-9535 */
111, 110, 109, 109, 108, 109, 111, 113, /* 9536-9543 */
116, 118, 118, 117, 117, 117, 117, 119, /* 9544-9551 */
121, 124, 125, 126, 125, 125, 125, 124, /* 9552-9559 */
124, 123, 122, 122, 122, 121, 121, 121, /* 9560-9567 */
121, 122, 125, 128, 128, 131, 134, 135, /* 9568-9575 */
138, 140, 141, 140, 139, 138, 136, 137, /* 9576-9583 */
138, 140, 142, 144, 146, 147, 147, 147, /* 9584-9591 */
147, 147, 146, 146, 145, 143, 140, 138, /* 9592-9599 */
135, 132, 131, 131, 131, 131, 131, 128, /* 9600-9607 */
128, 126, 124, 122, 121, 118, 117, 116, /* 9608-9615 */
117, 118, 120, 121, 123, 125, 126, 128, /* 9616-9623 */
128, 129, 130, 131, 133, 134, 135, 135, /* 9624-9631 */
135, 136, 137, 137, 138, 138, 138, 136, /* 9632-9639 */
134, 131, 129, 128, 126, 124, 122, 120, /* 9640-9647 */
118, 117, 116, 114, 113, 113, 116, 117, /* 9648-9655 */
119, 121, 121, 121, 120, 119, 119, 121, /* 9656-9663 */
124, 125, 127, 128, 129, 131, 132, 134, /* 9664-9671 */
135, 135, 137, 137, 138, 139, 139, 141, /* 9672-9679 */
142, 143, 143, 143, 142, 141, 140, 139, /* 9680-9687 */
138, 137, 135, 131, 129, 128, 125, 122, /* 9688-9695 */
120, 117, 115, 113, 111, 109, 109, 107, /* 9696-9703 */
107, 109, 110, 112, 114, 116, 118, 120, /* 9704-9711 */
121, 123, 122, 122, 122, 121, 121, 121, /* 9712-9719 */
121, 120, 120, 119, 119, 119, 119, 119, /* 9720-9727 */
119, 120, 120, 121, 121, 124, 127, 128, /* 9728-9735 */
130, 131, 131, 131, 131, 131, 131, 131, /* 9736-9743 */
131, 131, 131, 133, 135, 138, 139, 140, /* 9744-9751 */
139, 139, 139, 138, 137, 136, 136, 135, /* 9752-9759 */
135, 136, 139, 140, 141, 143, 144, 145, /* 9760-9767 */
146, 147, 150, 151, 151, 152, 151, 151, /* 9768-9775 */
150, 150, 148, 147, 143, 140, 138, 135, /* 9776-9783 */
132, 129, 128, 126, 125, 125, 125, 125, /* 9784-9791 */
125, 125, 124, 122, 121, 119, 118, 117, /* 9792-9799 */
116, 115, 115, 117, 117, 119, 121, 121, /* 9800-9807 */
121, 121, 121, 120, 121, 123, 125, 126, /* 9808-9815 */
127, 127, 126, 125, 125, 125, 127, 128, /* 9816-9823 */
128, 129, 131, 131, 132, 133, 134, 135, /* 9824-9831 */
135, 136, 136, 136, 134, 132, 130, 128, /* 9832-9839 */
128, 128, 129, 129, 130, 130, 130, 131, /* 9840-9847 */
131, 131, 131, 131, 131, 131, 131, 131, /* 9848-9855 */
131, 131, 131, 130, 130, 130, 130, 131, /* 9856-9863 */
131, 131, 130, 129, 128, 128, 128, 127, /* 9864-9871 */
126, 123, 120, 117, 115, 112, 110, 108, /* 9872-9879 */
106, 105, 105, 106, 107, 109, 109, 111, /* 9880-9887 */
112, 113, 114, 116, 117, 118, 120, 121, /* 9888-9895 */
121, 122, 123, 124, 125, 126, 127, 128, /* 9896-9903 */
128, 128, 128, 128, 128, 129, 128, 128, /* 9904-9911 */
126, 125, 124, 124, 125, 125, 126, 126, /* 9912-9919 */
128, 128, 128, 128, 128, 127, 126, 125, /* 9920-9927 */
124, 123, 121, 121, 120, 119, 118, 118, /* 9928-9935 */
117, 117, 117, 117, 118, 118, 118, 118, /* 9936-9943 */
119, 119, 120, 121, 124, 126, 128, 130, /* 9944-9951 */
131, 131, 132, 133, 134, 136, 137, 139, /* 9952-9959 */
139, 139, 139, 138, 137, 136, 135, 135, /* 9960-9967 */
134, 133, 133, 132, 131, 131, 131, 131, /* 9968-9975 */
132, 134, 136, 137, 137, 137, 136, 135, /* 9976-9983 */
135, 135, 134, 134, 133, 132, 131, 131, /* 9984-9991 */
131, 131, 132, 135, 136, 138, 139, 140, /* 9992-9999 */
142, 143, 144, 144, 143, 142, 141, 139, /* 10000-10007 */
140, 141, 141, 141, 142, 143, 143, 143, /* 10008-10015 */
143, 143, 140, 139, 137, 135, 133, 131, /* 10016-10023 */
130, 129, 128, 127, 125, 124, 122, 122, /* 10024-10031 */
124, 125, 126, 127, 128, 129, 129, 130, /* 10032-10039 */
130, 129, 128, 127, 126, 125, 124, 124, /* 10040-10047 */
123, 123, 123, 123, 124, 124, 124, 123, /* 10048-10055 */
121, 120, 118, 118, 119, 120, 120, 121, /* 10056-10063 */
122, 123, 124, 125, 125, 124, 123, 122, /* 10064-10071 */
121, 119, 118, 117, 117, 116, 116, 118, /* 10072-10079 */
119, 120, 121, 123, 124, 125, 127, 127, /* 10080-10087 */
126, 126, 125, 124, 123, 123, 122, 121, /* 10088-10095 */
121, 122, 123, 125, 126, 127, 126, 125, /* 10096-10103 */
125, 124, 125, 126, 128, 128, 129, 130, /* 10104-10111 */
131, 132, 133, 134, 135, 135, 136, 136, /* 10112-10119 */
135, 134, 132, 131, 129, 128, 127, 126, /* 10120-10127 */
125, 124, 123, 122, 121, 120, 121, 122, /* 10128-10135 */
123, 125, 128, 128, 130, 130, 131, 131, /* 10136-10143 */
129, 128, 128, 127, 125, 124, 123, 122, /* 10144-10151 */
121, 120, 120, 119, 119, 119, 120, 122, /* 10152-10159 */
123, 125, 125, 124, 124, 124, 124, 123, /* 10160-10167 */
123, 123, 123, 123, 123, 122, 122, 123, /* 10168-10175 */
123, 123, 124, 124, 124, 125, 125, 126, /* 10176-10183 */
126, 126, 127, 127, 128, 128, 129, 131, /* 10184-10191 */
133, 134, 136, 136, 136, 136, 136, 136, /* 10192-10199 */
138, 139, 140, 141, 142, 143, 144, 145, /* 10200-10207 */
145, 144, 142, 141, 140, 139, 139, 140, /* 10208-10215 */
140, 140, 139, 137, 136, 135, 133, 132, /* 10216-10223 */
130, 129, 128, 128, 128, 129, 130, 131, /* 10224-10231 */
131, 130, 129, 128, 127, 126, 125, 124, /* 10232-10239 */
122, 121, 121, 120, 119, 118, 119, 120, /* 10240-10247 */
121, 122, 123, 125, 125, 127, 128, 128, /* 10248-10255 */
127, 126, 126, 125, 125, 126, 127, 128, /* 10256-10263 */
128, 128, 127, 126, 126, 126, 126, 127, /* 10264-10271 */
128, 128, 129, 130, 130, 131, 131, 130, /* 10272-10279 */
129, 128, 128, 128, 128, 128, 128, 129, /* 10280-10287 */
128, 128, 127, 126, 126, 125, 124, 123, /* 10288-10295 */
122, 122, 124, 124, 125, 126, 127, 128, /* 10296-10303 */
128, 129, 130, 130, 131, 131, 132, 132, /* 10304-10311 */
130, 130, 128, 128, 128, 128, 128, 128, /* 10312-10319 */
129, 129, 131, 131, 132, 131, 129, 128, /* 10320-10327 */
127, 126, 125, 125, 125, 126, 126, 126, /* 10328-10335 */
126, 127, 127, 126, 125, 124, 123, 122, /* 10336-10343 */
122, 123, 123, 124, 124, 125, 125, 126, /* 10344-10351 */
126, 126, 125, 124, 124, 123, 123, 124, /* 10352-10359 */
124, 125, 126, 126, 125, 124, 124, 124, /* 10360-10367 */
124, 126, 126, 127, 127, 127, 126, 126, /* 10368-10375 */
125, 125, 125, 125, 124, 124, 125, 126, /* 10376-10383 */
127, 128, 129, 130, 130, 131, 132, 132, /* 10384-10391 */
131, 131, 130, 130, 129, 129, 128, 128, /* 10392-10399 */
128, 129, 130, 131, 131, 132, 133, 133, /* 10400-10407 */
134, 135, 135, 135, 136, 136, 137, 138, /* 10408-10415 */
138, 138, 138, 136, 135, 133, 132, 130, /* 10416-10423 */
130, 130, 130, 130, 129, 129, 129, 129, /* 10424-10431 */
129, 128, 128, 127, 126, 125, 126, 126, /* 10432-10439 */
126, 126, 126, 125, 124, 124, 123, 122, /* 10440-10447 */
122, 121, 121, 121, 122, 123, 124, 125, /* 10448-10455 */
126, 125, 125, 125, 125, 126, 127, 128, /* 10456-10463 */
128, 129, 129, 130, 131, 132, 132, 131, /* 10464-10471 */
131, 130, 130, 130, 131, 131, 132, 132, /* 10472-10479 */
131, 130, 130, 129, 128, 128, 128, 128, /* 10480-10487 */
128, 127, 127, 126, 126, 126, 126, 126, /* 10488-10495 */
126, 126, 126, 127, 128, 128, 129, 130, /* 10496-10503 */
131, 132, 134, 134, 134, 133, 133, 132, /* 10504-10511 */
131, 130, 129, 129, 128, 128, 129, 129, /* 10512-10519 */
129, 130, 130, 131, 131, 131, 132, 132, /* 10520-10527 */
132, 133, 133, 133, 133, 133, 133, 133, /* 10528-10535 */
131, 130, 129, 128, 128, 127, 127, 126, /* 10536-10543 */
125, 126, 126, 126, 127, 127, 127, 126, /* 10544-10551 */
126, 125, 125, 126, 127, 127, 127, 127, /* 10552-10559 */
127, 126, 126, 126, 125, 125, 125, 124, /* 10560-10567 */
125, 125, 126, 127, 127, 128, 128, 129, /* 10568-10575 */
129, 130, 130, 130, 131, 131, 131, 132, /* 10576-10583 */
132, 132, 132, 132, 132, 132, 132, 132, /* 10584-10591 */
131, 131, 131, 131, 131, 131, 131, 131, /* 10592-10599 */
131, 130, 130, 129, 129, 128, 128, 128, /* 10600-10607 */
128, 128, 127, 126, 124, 123, 122, 121, /* 10608-10615 */
121, 120, 119, 119, 119, 120, 120, 120, /* 10616-10623 */
120, 120, 120, 120, 120, 120, 121, 122, /* 10624-10631 */
122, 123, 123, 123, 123, 123, 123, 123, /* 10632-10639 */
123, 123, 123, 123, 123, 123, 124, 124, /* 10640-10647 */
125, 126, 127, 128, 128, 128, 128, 128, /* 10648-10655 */
128, 128, 129, 130, 130, 131, 132, 132, /* 10656-10663 */
133, 133, 133, 133, 132, 132, 132, 132, /* 10664-10671 */
132, 133, 133, 133, 132, 132, 131, 131, /* 10672-10679 */
131, 130, 130, 129, 129, 129, 129, 130, /* 10680-10687 */
130, 131, 131, 132, 132, 132, 132, 131, /* 10688-10695 */
131, 130, 129, 129, 129, 129, 129, 129, /* 10696-10703 */
129, 128, 128, 128, 128, 128, 128, 128, /* 10704-10711 */
128, 128, 128, 129, 129, 129, 128, 128, /* 10712-10719 */
128, 128, 128, 128, 128, 128, 128, 128, /* 10720-10727 */
128, 128, 127, 127, 127, 128, 128, 128, /* 10728-10735 */
128, 128, 128, 128, 127, 127, 127, 127, /* 10736-10743 */
126, 126, 126, 126, 126, 126, 126, 127, /* 10744-10751 */
127, 128, 128, 128, 128, 128, 128, 128, /* 10752-10759 */
128, 128, 128, 127, 127, 127, 127, 127, /* 10760-10767 */
127, 128, 128, 128, 128, 128, 128, 129, /* 10768-10775 */
129, 129, 129, 129, 130, 130, 130, 130, /* 10776-10783 */
130, 130, 130, 129, 129, 129, 129, 129, /* 10784-10791 */
129, 129, 129, 129, 129, 129, 129, 129, /* 10792-10799 */
128, 128, 128, 128, 128, 128, 128, 127, /* 10800-10807 */
127, 127, 127, 127, 127, 127, 127, 128, /* 10808-10815 */
128, 128, 128, 128, 128, 128, 128, 128, /* 10816-10823 */
128, 128, 128, 128, 128, 128, 128, 128, /* 10824-10831 */
128, 128, 128, 128, 128, 128, 128, 128, /* 10832-10839 */
128, 128, 128, 128, 128, 127, 122, 122, /* 10840-10847 */
122, 121}; /* 10848-10849 */

