#pragma once

#define NUM_POINTS 12 // reduce if you need to

// Objects are created centered around the origin

class Sprite
{
public:
    enum SPRITE_TYPES {SHIP, FIRE, SMALL_AST, MEDIUM_AST, LARGE_AST};
    Sprite();
    virtual ~Sprite(){};
    
    virtual void move();
    virtual void draw(bool bErase);
    virtual void addPoint(int x, int y);
    virtual bool checkCollision(const Sprite &InSprite) = 0;
    void setColor(int color){m_color = color;}
    void setNumPoints(int num){m_numPoints = num;} 
    
    virtual bool isValid() { return m_bIsValid;}
    
    
protected:

    double m_xCenter, m_yCenter;  // center of mass
    double m_DirX, m_DirY; // unit vector
    float m_Velocity;
    
    int m_color;
    
    double m_RotationAmount;
    double m_RotationVelocity; // degrees/sec
    int m_RotationDirection; // -1 is left, 0 is not rotating , 1 is rotating right   
    
    int m_numPoints;
    
    bool m_bIsValid; 
   
    double m_xPoints[NUM_POINTS];
    double m_yPoints[NUM_POINTS];    
    

};


