#include <iterator>
#include <list>

#include "./Sounds/Speaker.h"
#include "CommandShip.h"
#include "graphic.h"
#include "uLCD_4DGL.h"
#include "Projectile.h"

const double DEFAULT_ROTATION_SPEED = 2.0;

extern Speaker gSpeakerOut;
extern uLCD_4DGL guLCD;

extern double gOriginX;
extern double gOriginY;

CommandShip::CommandShip()
{
    m_xCenter = gOriginX;
    m_yCenter = gOriginY;
    // Top of CommandShip
    m_xPoints[0] = gOriginX;
    m_yPoints[0] = (8 + gOriginY);
    //Bottom left of CommandShip
    m_xPoints[1] = (4 + gOriginX);
    m_yPoints[1] = (-8 + gOriginY);
    //Bottom left of CommandShip
    m_xPoints[2] = (-4 + gOriginX);
    m_yPoints[2] = (-8 + gOriginY);    
    
    // Set color to red
    m_color = _RED_;
    
    m_numPoints = 3;
    
    m_Velocity = 0.0f;  // Command ship has no linear velocity
    m_RotationVelocity = 0.0f; // degrees/sec
    m_RotationDirection = NONE;  
}

void CommandShip::fire()
{
    // Enable a projectile
    for (int ii = 0 ; ii < NUM_LASERS ; ++ii)
    {
        if (!m_lasers[ii].isValid())
        {
            m_lasers[ii].reset();
            break;
        }
    }
 
     gSpeakerOut.SwitchSound(Speaker::FIRE);
    
}

void CommandShip::move()
{
    
    Sprite::move();
         
    for (int ii = 0 ; ii < NUM_LASERS ; ii++)
    {
        if (m_lasers[ii].isValid())
        {
            m_lasers[ii].move();
        }
    }
}
// Rotate left and right maybe swapped. Make sure you check it out
void CommandShip::rotateLeft()
{
    
     // if rotating right just stop in place
    if (m_RotationDirection == RIGHT)
    {
        m_RotationDirection = NONE;
        m_RotationVelocity = 0.0;
    }
    else
    {
        m_RotationDirection = LEFT;
        m_RotationVelocity = DEFAULT_ROTATION_SPEED;
    }    
        

}
void CommandShip::rotateRight()
{
     // if rotating right just stop in place
    if (m_RotationDirection ==  LEFT)
    {
        m_RotationDirection = NONE;
        m_RotationVelocity = 0.0;
    }
    else
    {
        m_RotationDirection = RIGHT;
        m_RotationVelocity = -DEFAULT_ROTATION_SPEED;
    }    
}