#include "mbed.h"
#include "TCPSocketConnection.h"
#include "ESP8266Interface.h"
#include "uLCD_4DGL.h"
#include "Motor.h"

ESP8266Interface wifi(p28, p27, p26);
TCPSocketConnection socket;
//Serial pc(USBTX, USBRX); //Used for testing functionality without wifi
Motor m1(p23, p5, p6); //pwm, fwd, rev //this one is for raising/lowering blinds
Motor m2(p24, p7, p8); //this one is for changing the tilt of them.
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

int heightpos=0;
int tiltpos=0;
float mspeed=1; //can be changed based on rate here;
char inData[5];
char previnData[5];
char inChar;
int index=0;

//CHANGE THESE
const char* wifissid = "SSID";
const char* password = "Pass";
const char* ipaddress="IP";
const int port = PORT;

void closetiltup(){//sets front of blinds to be tilted up
    while(tiltpos>-10){
        m2.speed(-mspeed);
        wait(mspeed*.02);
        tiltpos=tiltpos-(mspeed);
    }
    m2.speed(0);
}
    
void closetiltdown(){
        while(tiltpos<10){
            m2.speed(mspeed);
            wait(mspeed*.02);
            tiltpos=tiltpos+(mspeed);
        }
        m2.speed(0);
}

void tiltto(float pos){
        if(pos>tiltpos){
            m2.speed(mspeed);
            while(tiltpos<pos){
                wait(mspeed*.02);
                tiltpos=tiltpos+(mspeed);
            }
            m2.speed(0);
        }
        else if(pos<tiltpos){
            m2.speed(-mspeed);
            while(tiltpos>pos){
                wait(mspeed*.02);
                tiltpos=tiltpos-(mspeed);
            }
            m2.speed(0);
        }
        else{
        }
}

void fullup(){
    while(heightpos<10){
        m1.speed(mspeed);
        wait(mspeed*2);
        heightpos=heightpos+(mspeed);
    }
    m1.speed(0);
}

void fulldown(){
    while(heightpos>0){
        m1.speed(-mspeed);
        wait(mspeed);
        heightpos=heightpos-(mspeed);
    }
    m1.speed(0);
}

void moveto(float pos){
     if(pos>heightpos){
            m1.speed(mspeed);
            while(heightpos<pos){
                wait(mspeed*1.3);
                heightpos=heightpos+(mspeed);
            }
            m1.speed(0);
        }
        else if(pos<heightpos){
            m1.speed(-mspeed);
            while(heightpos>pos){
                wait(mspeed*.08);
                heightpos=heightpos-(mspeed);
            }
            m1.speed(0);
        }
        else{
        }
}

void resettozero(){
    moveto(0);
    tiltto(0);
}

int main()
{
    uLCD_4DGL ulcd(p9, p10, p11); // this is for an mbed-side print of current status
    float num;
    float prevnum;
    int n;
    wifi.init();
    bool result;    
    result = wifi.connect(wifissid, password);
    if(!result){
        ulcd.printf("error");
        while(!result){
            result=wifi.connect(wifissid, password);
        }
    }
    ulcd.printf("wifi c");
    if(socket.connect(ipaddress, port)<0){
        ulcd.printf("\ndevice nc");//hosted via laptop
        while(socket.connect(ipaddress,port)<0){
        }
    }
    ulcd.printf("\ndevice c");
    //socket.send("1", 1);
    while(1){
    /*    if(!wifi.is_connected()){
                result = wifi.connect(wifissid, password);
            if(!result){
                ulcd.printf("error");
                while(!result){
                    result=wifi.connect(wifissid, password);
                }
            }
        }
    while(wifi.is_connected()){*/
        led1=!led1;
      /*  if(!socket.is_connected()){
               while(socket.connect(ipaddress,port)<0){
                   led2=!led2;
               }
        }*/
        n=0;
        socket.send("1",1);
       // socket.close();
        //while(socket.connect(ipaddress,port)<0){
            led2=!led2;
       // }
        n=socket.receive(inData, sizeof(inData));
        led3=!led3;
        ulcd.cls();
      //  ulcd.printf("\n%c%c%c%c%c", inData[0], inData[1], inData[2], inData[3], inData[4]);
        prevnum=num;
        num = ((inData[3]-48)*10)+(inData[4]-48);
      //  ulcd.printf("\n%f", num);
        if(inData[2]=='-')
            num=-num;
        if((num>10)or(num<-10))
            num=prevnum; //do nothing if invalid input
        index=0;
        if(inData[0]=='0')
            resettozero();
        else if(inData[0]=='1')
            closetiltup();
        else if(inData[0]=='2')
            closetiltdown();
        else if(inData[0]=='3')
            tiltto(num);
        else if(inData[0]=='4')
            fullup();
        else if(inData[0]=='5')
            fulldown();
        else if(inData[0]=='6'){
            if(num>=0)
                moveto(num);
        }
        ulcd.locate(0,0);
        ulcd.printf("Height is %i\n Tilt is %i\n", heightpos, tiltpos);
        //if(n>-1){
            socket.close();
          //  if(!socket.is_connected()){
            //    ulcd.printf("\ndevice nc");//hosted via laptop
                while(socket.connect(ipaddress,port)<0){
                    led4=!led4;
                }
                ulcd.printf("\ndevice rc");
            //}
        //}
    }//}
    socket.close();
    wifi.disconnect();
}
        