#include "mbed.h"
#include "scolor_TCS3200.h"


scolor_TCS3200::scolor_TCS3200(PinName s0, PinName s1, PinName s2, PinName s3, PinName s_in) : 
_s0(s0), _s1(s1), _s2(s2), _s3(s3), _s_in(s_in) 
{
    SetMode(SCALE_100);

};
 

long scolor_TCS3200::ReadRed()   { _s2=0;  _s3=0; return pulsewidth();}
long scolor_TCS3200::ReadBlue()  { _s2=0;  _s3=1; return pulsewidth();}
long scolor_TCS3200::ReadClear() { _s2=1;  _s3=0; return pulsewidth();}
long scolor_TCS3200::ReadGreen() { _s2=1;  _s3=1; return pulsewidth();}

void scolor_TCS3200::SetMode(uint8_t mode) {
    switch (mode){
        case SCALE_100:  _s0= 1; _s1=1; break;
        case SCALE_20:   _s0=1 ; _s1=0; break;
        case SCALE_2:    _s0=0 ; _s1=1; break;
        case POWER_DOWN: _s0=0 ; _s1=0; break;
    } 
};
 
long  scolor_TCS3200::pulsewidth() {
    while(!_s_in);
    while(_s_in);
    timer.start();
    while(!_s_in);
    timer.stop();
    float pulsewidth_v = timer.read_us();
    timer.reset();
    return pulsewidth_v;
};
            

