//Test of cheap 13.56 Mhz RFID-RC522 module from eBay
//This code is based on Martin Olejar's MFRC522 library. Minimal changes
//Adapted for Nucleo STM32 F401RE. Should work on other Nucleos too

//Connect as follows:
//RFID pins        ->  Nucleo header CN5 (Arduino-compatible header)
//----------------------------------------
//RFID IRQ=pin5    ->   Not used. Leave open
//RFID MISO=pin4   ->   Nucleo SPI_MISO=PA_6=D12
//RFID MOSI=pin3   ->   Nucleo SPI_MOSI=PA_7=D11
//RFID SCK=pin2    ->   Nucleo SPI_SCK =PA_5=D13
//RFID SDA=pin1    ->   Nucleo SPI_CS  =PB_6=D10
//RFID RST=pin7    ->   Nucleo         =PA_9=D8
//3.3V and Gnd to the respective pins                              
                              
#include "mbed.h"
#include "MFRC522.h"

// Nucleo Pin for MFRC522 reset (pick another D pin if you need D8)
#define MF_RESET    D8

DigitalOut LedGreen(LED1);

//Serial connection to PC for output
Serial pc(SERIAL_TX, SERIAL_RX);

MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);

#define SIZE_UID 10
uint8_t tag1[SIZE_UID];
uint8_t tag2[SIZE_UID];
uint8_t tmp_tag[SIZE_UID];

    char tag_tag = 0;
    // si taga_tag =0 no hay almacenado tags , si tag >1 esta llena la memoria  
    // Init. RC522 Chip



void print_tag(uint8_t *tagt){
    
    for (uint8_t i = 0; i <SIZE_UID; i++)
      pc.printf(" %x",*(tagt+i));
    pc.printf("\n");
    
    
}
    
void clear_tag(uint8_t *tagt){
    
    for (uint8_t i = 0; i < SIZE_UID; i++)
      *(tagt+i) = 0;
    
}

void set_uid1(uint8_t *tagt){
    
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
      *(tagt+i) = RfChip.uid.uidByte[i];
    
}
int comparar_tags(uint8_t *tag1, uint8_t *tag2){

    for (uint8_t i = 0; i < SIZE_UID; i++){
      if (*(tag1+i) != *(tag2+i))
         return 0;  
    }
    return 1;
    
}

int read_tag(){
    if ( RfChip.PICC_IsNewCardPresent()){
        printf (" tag \n");
        if ( RfChip.PICC_ReadCardSerial()){
            set_uid1(tmp_tag);
            return 1;
        }
    }
    return 0;
}    
void save_tag(){
    printf("los actuales tag. \n");
    printf("\ntagtmp: "); print_tag(tmp_tag);
    printf("\ntag1: ");print_tag(tag1);
    printf("\ntag2: ");print_tag(tag2);
    
    if (read_tag()){
        if (tag_tag==0){
            set_uid1(tag1);
            printf("tag1 guardado \n");
            tag_tag++;
        }else{
            if (comparar_tags(tag1,tmp_tag)){
                printf ("es el tag 1");
            }else{
                set_uid1(tag2);
                printf("tag2 guardado \n");
                tag_tag++;
  
            }
            
        }
    }
    else
        printf ("debe ingresar tag \n");
    
       
}
int main(void) {
    pc.baud(115200);
    pc.printf("Configuracion Tarjetas   \n");
    pc.printf("Ingrese Tarjeta   del Tecnico \n");

    RfChip.PCD_Init();
    
    while(1){
        wait(1);
        if (tag_tag<2){
            save_tag();
           
            }
        else{
            if (read_tag()){
                if (comparar_tags(tag1,tmp_tag))
                    printf ("es el tag 1");
                else if (comparar_tags(tag2,tmp_tag))
                    printf ("es el tag 2");
            }           
          }
    }
    
        
    
}   
    
/*    
    int  i =0;
    int ia=0;
    while (i<1 || ia<1) {
    
 // printf("%i \n",i);
 //  printf("%i \n",ia);
    // Look for new cards
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      wait_ms(500);
      continue;
    }

    // Select one of the cards
    if ( ! RfChip.PICC_ReadCardSerial())
    {
      wait_ms(500);
      continue;
    }
    
    

       
    if (tag_tag){
        if (comp_tag(tag1)){
            printf("Tarjeta Tecnico ya registrada \n ");
              printf("Ingrese Tarjeta Operario \n ");
             i++;
        }
        else{
            if (comp_tag(tag2)){
                printf("Tarjeta Operario ya registrada  \n ");
                 ia++;
            }
            else{
            
                 printf("Nueva Tarjeta No: \n");
                print_tag_uid();
                set_uid1(tag2);         
                printf("Nueva Tarjeta de Operario  Coonfigurada\n");
                print_tag_uid();
            }
        }
    }else{
        set_uid1(tag1);
        tag_tag=true;
        printf("Tarjeta de Tecnigo Ingresada  ; \n");         
        print_tag_uid();
        
    }


    // Print Card type
    uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
    pc.printf("PICC Type: %s \n", RfChip.PICC_GetTypeName(piccType));
    wait_ms(1000);
    
    
  }
  
  
  printf("Configuracion  de Tarjetas finalizado \n");
        // wait(2);
         int o=0;
         int t=0;
       while(1){  
  if (  RfChip.PICC_IsNewCardPresent())    {
     
     
     if (comp_tag(tag1)){
           t=1;
           o=0;
             
            
        }
        
            if (comp_tag(tag2)){
              o=1;
              t=0;
                 
            
            }
            
         if(t==1){
          
          
            printf("tecni\n");
          }   
          
          if(o==1){
                 printf("ope \n");
              }
          
              
     
    }
    
     }  
       


}

*/