/*
  Copyright 2014 Johan Wikman

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include <sqmbed/timer.h>

namespace SqMbed
{

Timer::Timer()
{
}

Timer::~Timer()
{
}

void Timer::start()
{
    m_timer.start();
}

void Timer::stop()
{
    m_timer.stop();
}

void Timer::reset()
{
    m_timer.reset();
}

float Timer::read() const
{
    return m_timer.read();
}

int Timer::read_ms() const
{
    return m_timer.read_ms();
}

int Timer::read_us() const
{
    return m_timer.read_us();
}

// static
void Timer::bind(HSQUIRRELVM vm)
{
    SqBind<Timer>::init(vm, _SC("Timer"));
    sqbind_method(vm, "start", &Timer::start);
    sqbind_method(vm, "stop", &Timer::stop);
    sqbind_method(vm, "reset", &Timer::reset);
    sqbind_method(vm, "read", &Timer::read);
    sqbind_method(vm, "read_ms", &Timer::read_ms);
    sqbind_method(vm, "read_us", &Timer::read_us);
}

}
