/*
  Copyright 2014 Johan Wikman

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include <sqmbed/timeout.h>

template<>
struct SqBindAllocator<SqMbed::Timeout> {
    static SQBIND_INLINE SqMbed::Timeout *construct(HSQUIRRELVM vm) {
        SqMbed::Timeout* pThis = 0;

        if (SqMbed::Trigger::reserve()) {
            pThis = new SqMbed::Timeout(vm);
        } else {
            printf("Out of memory\n");
        }

        return pThis;
    }

    static SQBIND_INLINE SqMbed::Timeout *copy_construct(const SqMbed::Timeout* p_from) {
        return NULL; // make it not able to copy-construct
    }

    static SQBIND_INLINE bool assign(SqMbed::Timeout* p_val, const SqMbed::Timeout* p_from) {
        return false; // make it not able to assign
    }

    static SQBIND_INLINE void destruct(SqMbed::Timeout* p_instance) {
        delete p_instance;
    }

    static SQBIND_INLINE SqMbed::Timeout& get_empty() {
        // if someone tries to assign, this will crash.
        // however, this will likely never be called anyway.
        static SqMbed::Timeout *crashplease=NULL;
        return *crashplease;
    }
};

namespace SqMbed
{

Timeout::Timeout(HSQUIRRELVM vm)
    : Trigger(vm)
{
}

Timeout::~Timeout()
{
}

void Timeout::attach(HSQOBJECT o, float t)
{
    Trigger::attach(o);

    void (Timeout::*pTrigger)() = &Timeout::triggered;

    m_timeout.attach(this, pTrigger, t);
}

void Timeout::detach()
{
    m_timeout.detach();
}

// static
void Timeout::bind(HSQUIRRELVM vm)
{
    SqBind<Timeout>::init(vm, _SC("Timeout"));

    sqbind_method(vm, "attach", &Timeout::attach);
    sqbind_method(vm, "detach", &Timeout::detach);
}

}
