/*
  Copyright 2014 Johan Wikman

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include <sqmbed/pwmout.h>

namespace SqMbed
{

PwmOut::PwmOut(PinName pin)
    : m_pwmOut(pin)
{
}

PwmOut::~PwmOut()
{
}

void PwmOut::write(float value)
{
    m_pwmOut.write(value);
}

float PwmOut::read() const
{
    return m_pwmOut.read();
}

void PwmOut::period(float seconds)
{
    m_pwmOut.period(seconds);
}

void PwmOut::period_ms(int ms)
{
    m_pwmOut.period_ms(ms);
}

void PwmOut::period_us(int us)
{
    m_pwmOut.period_us(us);
}

void PwmOut::pulsewidth(float seconds)
{
    m_pwmOut.pulsewidth(seconds);
}

void PwmOut::pulsewidth_ms(int ms)
{
    m_pwmOut.pulsewidth_ms(ms);
}

void PwmOut::pulsewidth_us(int us)
{
    m_pwmOut.pulsewidth_us(us);
}

// static
void PwmOut::bind(HSQUIRRELVM vm)
{
    SqBind<PwmOut>::init(vm, _SC("PwmOut"));
    SqBind<PwmOut>::set_custom_constructor(&PwmOut::constructor);
    sqbind_method(vm, "write", &PwmOut::write);
    sqbind_method(vm, "read", &PwmOut::read);
    sqbind_method(vm, "period", &PwmOut::period);
    sqbind_method(vm, "period_ms", &PwmOut::period_ms);
    sqbind_method(vm, "period_us", &PwmOut::period_us);
    sqbind_method(vm, "pulsewidth", &PwmOut::pulsewidth);
    sqbind_method(vm, "pulsewidth_ms", &PwmOut::pulsewidth_ms);
    sqbind_method(vm, "pulsewidth_us", &PwmOut::pulsewidth_us);
}

// static
PwmOut* PwmOut::constructor(HSQUIRRELVM vm)
{
    PwmOut* pThis = 0;

    int nParams = sq_gettop(vm);

    if (nParams == 2) { // Need 1 (sic) params.
        SQInteger i;

        if (!SQ_FAILED(sq_getinteger(vm, 2, &i))) {
            pThis = new PwmOut(static_cast<PinName>(i));
        } else {
            printf("error: Could not get PinName.");
        }
    } else {
        printf("error: nParams != 2\n");
    }

    return pThis;
}

}
