/*
  Copyright 2014 Johan Wikman

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include <sqmbed/digitalin.h>

SQBIND_INTEGER(PinMode);

template<>
struct SqBindAllocator<SqMbed::DigitalIn> {
    static SQBIND_INLINE SqMbed::DigitalIn *construct(HSQUIRRELVM) {
        return NULL; // make it not able to construct
    }

    static SQBIND_INLINE SqMbed::DigitalIn *copy_construct(const SqMbed::DigitalIn* p_from) {
        return NULL; // make it not able to copy-construct
    }

    static SQBIND_INLINE bool assign(SqMbed::DigitalIn* p_val, const SqMbed::DigitalIn* p_from) {
        return false; // make it not able to assign
    }

    static SQBIND_INLINE void destruct(SqMbed::DigitalIn* p_instance) {
        delete p_instance;
    }

    static SQBIND_INLINE SqMbed::DigitalIn& get_empty() {
        // if someone tries to assign, this will crash.
        // however, this will likely never be called anyway.
        static SqMbed::DigitalIn *crashplease=NULL;
        return *crashplease;
    }
};

namespace SqMbed
{

DigitalIn::DigitalIn(PinName pin)
    : m_digIn(pin)
{
}

DigitalIn::DigitalIn(PinName pin, PinMode mode)
    : m_digIn(pin, mode)
{
}

DigitalIn::~DigitalIn()
{
}

int DigitalIn::read() const
{
    return m_digIn.read();
}

void DigitalIn::mode(PinMode m)
{
    m_digIn.mode(m);
}

// static
void DigitalIn::bind(HSQUIRRELVM vm)
{
    SqBind<DigitalIn>::init(vm, _SC("DigitalIn"));
    SqBind<DigitalIn>::set_custom_constructor(&DigitalIn::constructor);
    sqbind_method(vm, "mode", &DigitalIn::mode);
    sqbind_method(vm, "read", &DigitalIn::read);
}

// static
DigitalIn* DigitalIn::constructor(HSQUIRRELVM vm)
{
    DigitalIn* pThis = 0;

    int nParams = sq_gettop(vm);

    if ((nParams == 2) || (nParams == 3)) { // Need 1 (sic) params.
        SQInteger pin;

        if (!SQ_FAILED(sq_getinteger(vm, 2, &pin))) {
            if (nParams == 3) {
                SQInteger mode;

                if (!SQ_FAILED(sq_getinteger(vm, 3, &mode))) {
                    pThis = new DigitalIn(static_cast<PinName>(pin),
                                          static_cast<PinMode>(mode));
                } else {
                    printf("error: Invalid PinMode.\n");
                }
            } else {
                pThis = new DigitalIn(static_cast<PinName>(pin));
            }
        } else {
            printf("error: Invalid PinName.\n");
        }
    } else {
        printf("error: 2 or 3 params.\n");
    }

    return pThis;
}

}
