#ifndef SQMBED_POINTERSTORAGE_H
#define SQMBED_POINTERSTORAGE_H
/*
  Copyright 2014 Johan Wikman

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include <sqmbed/common.h>

namespace SqMbed
{

template<typename T>
class PointerStorage
{
public:
    static bool reserve() {
        bool reserved = false;

        if (s_nUsed == s_nSpace) {
            uint32_t nSpace = (s_nSpace != 0 ? 2 * s_nSpace : 8);
            T** ppObjects = new T* [nSpace];

            if (ppObjects) {
                uint32_t i;

                for (i = 0; i < s_nSpace; ++i) {
                    ppObjects[i] = s_ppObjects[i];
                }

                for (; i < nSpace; ++i) {
                    ppObjects[i] = 0;
                }

                delete [] s_ppObjects;
                s_ppObjects = ppObjects;
                s_nSpace = nSpace;

                reserved = true;
            }
        } else {
            reserved = true;
        }

        return reserved;
    }

    static void add(T* pObject) {
        // Space assumed to exist!
        assert(s_nUsed < s_nSpace);

        T** ppObjects = s_ppObjects;

        while (*ppObjects) {
            ++ppObjects;
        }

        *ppObjects = pObject;

        ++s_nUsed;
    }

    static void remove(T* pObject) {
        T** ppObjects = s_ppObjects;

        while (*ppObjects != pObject) {
            ++ppObjects;
        }

        *ppObjects = 0;

        --s_nUsed;
    }

protected:
    static T** s_ppObjects;
    static uint32_t s_nSpace;
    static uint32_t s_nUsed;
};

template<class T>
T** PointerStorage<T>::s_ppObjects;
template<class T>
uint32_t PointerStorage<T>::s_nSpace;
template<class T>
uint32_t PointerStorage<T>::s_nUsed;

}

#endif
