#ifndef SQMBED_DIGITALINOUT_H
#define SQMBED_DIGITALINOUT_H
/*
  Copyright 2014 Johan Wikman

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include <sqmbed/common.h>

namespace SqMbed
{

class DigitalInOut
{
public:
    DigitalInOut(PinName pin);
    ~DigitalInOut();

    int read() const;
    void write(int value);

    void input();
    void output();

    void mode(PinMode mode);

public:
    static void bind(HSQUIRRELVM vm);
    static DigitalInOut* constructor(HSQUIRRELVM vm);

private:
    mutable mbed::DigitalInOut m_digInOut;
};

}

#endif
