#ifndef SQMBED_COMMON_H
#define SQMBED_COMMON_H
/*
  Copyright 2014 Johan Wikman

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include <mbed.h>
#include <squirrel.h>
#include <sqbind.h>

using namespace std;

template<>
class SqBind<HSQOBJECT> {
public:
    struct Getter {
        SQBIND_INLINE HSQOBJECT get(HSQUIRRELVM v, int p_idx) {
            return SqBind<HSQOBJECT>::get(v, p_idx);
        }
    };
    struct GetterPtr {
        HSQOBJECT temp;
        SQBIND_INLINE HSQOBJECT* get(HSQUIRRELVM v, int p_idx) {
            temp = SqBind<HSQOBJECT>::get(v, p_idx);
            return &temp;
        }
    };
    static SQBIND_INLINE HSQOBJECT get(HSQUIRRELVM v, int p_idx) {
        if (sq_gettype(v, p_idx) != OT_CLOSURE) {
            sqbind_throwerror(v, "Type is not a closure!");
            return HSQOBJECT();
        }
        HSQOBJECT o;
        sq_getstackobj(v, p_idx, &o);
        return o;
    }

    static SQBIND_INLINE void push(HSQUIRRELVM v, const HSQOBJECT& p_value) {
        sq_pushobject(v, p_value);
    }
};


namespace SqMbed
{

const char* toString(SQObjectType t);

// To be defined by platform specific code.
void bindPlatform(HSQUIRRELVM vm);

}

#endif
