/*
  Copyright 2014 Johan Wikman

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include <sqmbed/ticker.h>

template<>
struct SqBindAllocator<SqMbed::Ticker> {
    static SQBIND_INLINE SqMbed::Ticker *construct(HSQUIRRELVM vm) {
        SqMbed::Ticker* pThis = 0;

        if (SqMbed::Trigger::reserve()) {
            pThis = new SqMbed::Ticker(vm);
        } else {
            printf("Out of memory\n");
        }

        return pThis;
    }

    static SQBIND_INLINE SqMbed::Ticker *copy_construct(const SqMbed::Ticker* p_from) {
        return NULL; // make it not able to copy-construct
    }

    static SQBIND_INLINE bool assign(SqMbed::Ticker* p_val, const SqMbed::Ticker* p_from) {
        return false; // make it not able to assign
    }

    static SQBIND_INLINE void destruct(SqMbed::Ticker* p_instance) {
        delete p_instance;
    }

    static SQBIND_INLINE SqMbed::Ticker& get_empty() {
        // if someone tries to assign, this will crash.
        // however, this will likely never be called anyway.
        static SqMbed::Ticker *crashplease=NULL;
        return *crashplease;
    }
};

namespace SqMbed
{

Ticker::Ticker(HSQUIRRELVM vm)
    : Trigger(vm)
{
}

Ticker::~Ticker()
{
}

void Ticker::attach(HSQOBJECT o, float t)
{
    Trigger::attach(o);

    void (Ticker::*pTrigger)() = &Ticker::triggered;

    m_ticker.attach(this, pTrigger, t);
}

void Ticker::detach()
{
    m_ticker.detach();
}

// static
void Ticker::bind(HSQUIRRELVM vm)
{
    SqBind<Ticker>::init(vm, _SC("Ticker"));

    sqbind_method(vm, "attach", &Ticker::attach);
    sqbind_method(vm, "detach", &Ticker::detach);
}

}
