/*
  Copyright 2014 Johan Wikman

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include <mbed.h>
#include <sqmbed/digitalin.h>
#include <sqmbed/digitalinout.h>
#include <sqmbed/digitalout.h>
#include <sqmbed/interruptin.h>
#include <sqmbed/pwmout.h>
#include <sqmbed/ticker.h>
#include <sqmbed/timeout.h>
#include <sqmbed/timer.h>

using namespace std;

namespace
{

void bindGlobals(HSQUIRRELVM vm)
{
    sqbind_function(vm, "wait", wait);
    sqbind_function(vm, "wait_ms", wait_ms);
    sqbind_function(vm, "wait_us", wait_us);
}

void bindMbed(HSQUIRRELVM vm)
{
    SqMbed::DigitalIn::bind(vm);
    SqMbed::DigitalInOut::bind(vm);
    SqMbed::DigitalOut::bind(vm);
    SqMbed::InterruptIn::bind(vm);
    SqMbed::PwmOut::bind(vm);
    SqMbed::Ticker::bind(vm);
    SqMbed::Timeout::bind(vm);
    SqMbed::Timer::bind(vm);
}

}

extern "C" void sq_bind_mbed(HSQUIRRELVM vm)
{
    bindGlobals(vm);
    bindMbed(vm);

    // Platform specific bindings.
    SqMbed::bindPlatform(vm);
}

extern "C" void mbed_execute_idle(HSQUIRRELVM vm)
{
    SqMbed::InterruptIn::flushInterrupts();
    SqMbed::Trigger::flushTriggers();
}
