/*
  Copyright 2014 Johan Wikman

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include <sqmbed/digitalout.h>

template<>
struct SqBindAllocator<SqMbed::DigitalOut> {
    static SQBIND_INLINE SqMbed::DigitalOut *construct(HSQUIRRELVM) {
        return NULL; // make it not able to construct
    }

    static SQBIND_INLINE SqMbed::DigitalOut *copy_construct(const SqMbed::DigitalOut* p_from) {
        return NULL; // make it not able to copy-construct
    }

    static SQBIND_INLINE bool assign(SqMbed::DigitalOut* p_val, const SqMbed::DigitalOut* p_from) {
        return false; // make it not able to assign
    }

    static SQBIND_INLINE void destruct(SqMbed::DigitalOut* p_instance) {
        delete p_instance;
    }

    static SQBIND_INLINE SqMbed::DigitalOut& get_empty() {
        // if someone tries to assign, this will crash.
        // however, this will likely never be called anyway.
        static SqMbed::DigitalOut *crashplease=NULL;
        return *crashplease;
    }
};

namespace SqMbed
{

DigitalOut::DigitalOut(PinName pin)
    : m_digOut(pin)
{
}

DigitalOut::~DigitalOut()
{
}

void DigitalOut::write(int value)
{
    m_digOut.write(value);
}

int DigitalOut::read() const
{
    return m_digOut.read();
}

// static
void DigitalOut::bind(HSQUIRRELVM vm)
{
    SqBind<DigitalOut>::init(vm, _SC("DigitalOut"));
    SqBind<DigitalOut>::set_custom_constructor(&DigitalOut::constructor);
    sqbind_method(vm, "write", &DigitalOut::write);
    sqbind_method(vm, "read", &DigitalOut::read);
}

// static
DigitalOut* DigitalOut::constructor(HSQUIRRELVM vm)
{
    DigitalOut* pThis = 0;

    int nParams = sq_gettop(vm);

    if (nParams == 2) { // Need 1 (sic) params.
        SQInteger i;

        if (!SQ_FAILED(sq_getinteger(vm, 2, &i))) {
            pThis = new DigitalOut(static_cast<PinName>(i));
        } else {
            printf("Could not get integer.");
        }
    } else {
        printf("nParams != 2\n");
    }

    return pThis;
}

}
