/*
  Copyright 2014 Johan Wikman

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include <sqmbed/digitalinout.h>

template<>
struct SqBindAllocator<SqMbed::DigitalInOut> {
    static SQBIND_INLINE SqMbed::DigitalInOut *construct(HSQUIRRELVM) {
        return NULL; // make it not able to construct
    }

    static SQBIND_INLINE SqMbed::DigitalInOut *copy_construct(const SqMbed::DigitalInOut* p_from) {
        return NULL; // make it not able to copy-construct
    }

    static SQBIND_INLINE bool assign(SqMbed::DigitalInOut* p_val, const SqMbed::DigitalInOut* p_from) {
        return false; // make it not able to assign
    }

    static SQBIND_INLINE void destruct(SqMbed::DigitalInOut* p_instance) {
        delete p_instance;
    }

    static SQBIND_INLINE SqMbed::DigitalInOut& get_empty() {
        // if someone tries to assign, this will crash.
        // however, this will likely never be called anyway.
        static SqMbed::DigitalInOut *crashplease=NULL;
        return *crashplease;
    }
};

namespace SqMbed
{

DigitalInOut::DigitalInOut(PinName pin)
    : m_digInOut(pin)
{
}

DigitalInOut::~DigitalInOut()
{
}

void DigitalInOut::write(int value)
{
    m_digInOut.write(value);
}

int DigitalInOut::read() const
{
    return m_digInOut.read();
}

void DigitalInOut::input()
{
    m_digInOut.input();
}

void DigitalInOut::output()
{
    m_digInOut.output();
}

void DigitalInOut::mode(PinMode m)
{
    m_digInOut.mode(m);
}

// static
void DigitalInOut::bind(HSQUIRRELVM vm)
{
    SqBind<DigitalInOut>::init(vm, _SC("DigitalInOut"));
    SqBind<DigitalInOut>::set_custom_constructor(&DigitalInOut::constructor);
    sqbind_method(vm, "read", &DigitalInOut::read);
    sqbind_method(vm, "write", &DigitalInOut::write);
    sqbind_method(vm, "input", &DigitalInOut::input);
    sqbind_method(vm, "output", &DigitalInOut::output);
}

// static
DigitalInOut* DigitalInOut::constructor(HSQUIRRELVM vm)
{
    DigitalInOut* pThis = 0;

    int nParams = sq_gettop(vm);

    if (nParams == 2) { // Need 1 (sic) params.
        SQInteger i;

        if (!SQ_FAILED(sq_getinteger(vm, 2, &i))) {
            pThis = new DigitalInOut(static_cast<PinName>(i));
        } else {
            printf("Could not get integer.");
        }
    } else {
        printf("nParams != 2\n");
    }

    return pThis;
}

}
