/*
  Copyright 2014 Johan Wikman

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include <sqmbed/common.h>

namespace SqMbed
{

const char* toString(SQObjectType t)
{
    switch (t) {
    case OT_NULL:
        return "OT_NULL";

    case OT_INTEGER:
        return "OT_INTEGER";

    case OT_FLOAT:
        return "OT_FLOAT";

    case OT_BOOL:
        return "OT_BOOL";

    case OT_STRING:
        return "OT_STRING";

    case OT_TABLE:
        return "OT_TABLE";

    case OT_ARRAY:
        return "OT_ARRAY";

    case OT_USERDATA:
        return "OT_USERDATA";

    case OT_CLOSURE:
        return "OT_CLOSURE";

    case OT_NATIVECLOSURE:
        return "OT_NATIVECLOSURE";

    case OT_GENERATOR:
        return "OT_GENERATOR";

    case OT_USERPOINTER:
        return "OT_USERPOINTER";

    case OT_THREAD:
        return "OT_THREAD";

    case OT_FUNCPROTO:
        return "OT_FUNCPROTO";

    case OT_CLASS:
        return "OT_CLASS";

    case OT_INSTANCE:
        return "OT_INSTANCE";

    case OT_WEAKREF:
        return "OT_WEAKREF";

    case OT_OUTER:
        return "OT_OUTER";

    default:
        return "OT_UNKNOWN";
    }
}

}
