#ifndef SQMBED_TRIGGERED_H
#define SQMBED_TRIGGERED_H
/*
  Copyright 2014 Johan Wikman

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include <sqmbed/common.h>

namespace SqMbed
{

class Trigger
{
public:
    Trigger(HSQUIRRELVM vm);
    virtual ~Trigger();

    static bool reserve();

    static void flushTriggers();
    void call();

public:
    static void bind(HSQUIRRELVM vm);

protected:
    void attach(HSQOBJECT o);

    void triggered();

private:
    HSQUIRRELVM m_vm;
    HSQOBJECT m_object;
    bool m_triggered;
};

}

#endif
