#ifndef SQMBED_TIMER_H
#define SQMBED_TIMER_H
/*
  Copyright 2014 Johan Wikman

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include <sqmbed/common.h>

namespace SqMbed
{

class Timer
{
public:
    Timer();
    ~Timer();

    void start();
    void stop();
    void reset();
    float read() const;
    int read_ms() const;
    int read_us() const;

public:
    static void bind(HSQUIRRELVM vm);

private:
    mutable mbed::Timer m_timer;
};

}

#endif
