#ifndef SQMBED_PWMOUT_H
#define SQMBED_PWMOUT_H
/*
  Copyright 2014 Johan Wikman

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include <sqmbed/common.h>

namespace SqMbed
{

class PwmOut
{
public:
    PwmOut(PinName pin);
    ~PwmOut();

    void write(float value);
    float read() const;

    void period(float seconds);
    void period_ms(int ms);
    void period_us(int us);
    void pulsewidth(float seconds);
    void pulsewidth_ms(int ms);
    void pulsewidth_us(int us);

public:
    static void bind(HSQUIRRELVM vm);
    static PwmOut* constructor(HSQUIRRELVM vm);

private:
    mutable mbed::PwmOut m_pwmOut;
};

}

template<>
struct SqBindAllocator<SqMbed::PwmOut> {
    static SQBIND_INLINE SqMbed::PwmOut *construct(HSQUIRRELVM) {
        return NULL; // make it not able to construct
    }

    static SQBIND_INLINE SqMbed::PwmOut *copy_construct(const SqMbed::PwmOut* p_from) {
        return NULL; // make it not able to copy-construct
    }

    static SQBIND_INLINE bool assign(SqMbed::PwmOut* p_val, const SqMbed::PwmOut* p_from) {
        return false; // make it not able to assign
    }

    static SQBIND_INLINE void destruct(SqMbed::PwmOut* p_instance) {
        delete p_instance;
    }

    static SQBIND_INLINE SqMbed::PwmOut& get_empty() {
        // if someone tries to assign, this will crash.
        // however, this will likely never be called anyway.
        static SqMbed::PwmOut *crashplease=NULL;
        return *crashplease;
    }
};

#endif
