#ifndef SQMBED_INTERRUPTIN_H
#define SQMBED_INTERRUPTIN_H
/*
  Copyright 2014 Johan Wikman

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include <sqmbed/common.h>

namespace SqMbed
{

class InterruptIn
{
public:
    InterruptIn(HSQUIRRELVM vm, PinName pin);
    ~InterruptIn();

    PinName pin() const { return m_pin; }

    void rise(HSQOBJECT o);

public:
    static void deliver(PinName pin);
    void call();

public:
    // To be provided by device dependent code.
    static void postponeInterrupt(PinName pin);
    static void flushInterrupts();

public:
    static void bind(HSQUIRRELVM vm);
    static InterruptIn* constructor(HSQUIRRELVM vm);

private:
    // The only one that can be called in interrupt context.
    void raised();

private:
    HSQUIRRELVM m_vm;
    const PinName m_pin;
    mbed::InterruptIn m_intIn;
    HSQOBJECT m_object;
};

}

#endif
