#ifndef SQMBED_DIGITALIN_H
#define SQMBED_DIGITALIN_H
/*
  Copyright 2014 Johan Wikman

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

#include <sqmbed/common.h>

namespace SqMbed
{

class DigitalIn
{
public:
    DigitalIn(PinName pin);
    DigitalIn(PinName pin, PinMode mode);
    ~DigitalIn();

    int read() const;
    void mode(PinMode mode);

public:
    static void bind(HSQUIRRELVM vm);
    static DigitalIn* constructor(HSQUIRRELVM vm);

private:
    mutable mbed::DigitalIn m_digIn;
};

}

#endif
