#ifndef LOGGER_H
#define LOGGER_H

#include "mbed.h"
#include "rtos.h"
#include "MMA8451Q.h"
#include "buffer.h"

const int BAUD_115200           = 115200;
const int BUF_SIZE              = 128;
const int MMA8451Q_I2C_ADDRESS  = (0x1D << 1);

const int SEND_DATA_SIGNAL      = 0x01;
const int GET_DATA_SIGNAL       = 0x02;
const int LED_SIGNAL            = 0x03;

const int SAMPLE_RATE           = 1000; //Milisegundos.
const int TRANSMIT_RATE         = 60000; //Milisegundos.

class Logger
{
private:
    Serial port;    
    DigitalOut redLed;
    DigitalOut blueLed;
    DigitalOut greenLed;
    MMA8451Q acc;
    //Thread tx_th;
    Thread data_th;
    Thread led_th;
    int msg;
    bool newMsg;
    Buffer<float> acc_x;
    
    static void led_thread(void const* args);
    static void data_thread(void const* args);
    void rcv_isr();
    

public:
    Logger(PinName tx, PinName rx);
    float* getData();
    //static void tx_thread(void const* args);
    
    
    ~Logger();
};



#endif //LOGGER_H