#include "logger.h"

Logger::Logger(PinName tx, PinName rx) :
    port(tx, rx),
    redLed(LED_RED),
    blueLed(LED_BLUE),
    greenLed(LED_GREEN),
    acc(PTE25, PTE24, MMA8451Q_I2C_ADDRESS),
//tx_th(tx_thread, (void*)this),
    data_th(this->data_thread, (void*)this),
    led_th(this->led_thread, (void*)&blueLed),
    acc_x(BUF_SIZE)  
      
{
    redLed = 1; blueLed = 1; greenLed = 1;
    msg = 0;
    newMsg = false;
    port.baud(BAUD_115200);
    port.attach(this, &Logger::rcv_isr, Serial::RxIrq);
}

/* Rutina de interrupción para recibir datos del servidor */
/* Funciona! */
void Logger::rcv_isr()
{
    msg = UART0->D; // Leer UART0 para desactivar bandera de interrupción.
    while(UART0->S1 & UART_S1_RDRF_MASK); // Esperar a UART0 listo.
    newMsg = true;
    //redLed = !redLed;
}

/* Thread para adquisicion de datos de los sensores */
/* Funciona */
void Logger::data_thread(const void* args)
{
    Logger* log = (Logger*)args;
    float temp[3];
    //Buffer<float> buf_x(BUF_SIZE); Buffer<float> buf_y(BUF_SIZE); Buffer<float> buf_z(BUF_SIZE);
    while(true)
    {
        log->led_th.signal_set(LED_SIGNAL);
        log->acc.getAccAllAxis(temp);
        log->acc_x.put(temp[0]);
        //buf_x.put(temp[0]); buf_y.put(temp[1]); buf_z.put(temp[2]);
        //log->port.printf("a[x]: %f, a[y]: %f, a[z]: %f\n\r", temp[0], temp[1], temp[2]);
        log->port.printf("a[x}: %f\n\r", log->acc_x.get());
        Thread::wait(SAMPLE_RATE);
    }
    
}

void Logger::led_thread(const void* args) 
{
    DigitalOut* led = (DigitalOut*)args;
    while(true)
    {
        Thread::signal_wait(LED_SIGNAL);
        *led = !(*led);
    }
}

/* Thread para el envio de datos al servidor */
//void Logger::tx_thread(const void* args) {}



/* Destructor */
Logger::~Logger() 
{

}