#include "RingBuffer.h"

Buffer::Buffer(int size) : bufSize(size), full(false), empty(true), windex(0), rindex(0)
{
    data = std::vector<float>(bufSize);
    itBeg = data.begin();
    itEnd = data.end();
    head = itBeg;
    tail = itBeg;
}

void Buffer::put(float val)
{
    if(!full)
    {
        //std::cout << "Escribiendo " << val << " en " << windex << std::endl;
        data[windex] = val;
        windex++;
        empty = false;
        if(windex >= bufSize)
        {
            windex = 0;
        }
        if(windex == rindex)
        {
            full = true;
            //std::cout << "Buffer lleno..." << std::endl;
        }
    }
}

const float Buffer::get()
{  
    float temp;
    if(!empty)
    {
        temp = data[rindex];
        //std::cout << "Leyendo " << temp << " de " << rindex << std::endl;
        data[rindex] = 0;
        full = false;
        rindex++;
        if(rindex >= bufSize)
        {
            rindex = 0;
        }
        if(rindex == windex)
        {
            empty = true;
            //std::cout << "Buffer vacío. R-Index: " << rindex <<  std::endl;
        }
    }
    return temp;
}

const bool Buffer::isFull()
{
    return full;
}

const bool Buffer::isEmpty()
{
    return empty;
}

const int Buffer::getSize()
{
    return bufSize;
}

const int Buffer::getWritingIndex()
{
    return windex;
}

/*
void Buffer::printBuffer()
{
    std::cout << "Imprimiendo buffer..." << std::endl;
    int k = 0;
    for(std::vector<float>::iterator it = data.begin(); it != data.end(); ++it)
    {
        std::cout << "Elemento " << k++ << " es: " << *it << std::endl;
    }
}
*/
