#include "FXOS8700.h"

FXOS8700::FXOS8700 (PinName sda, PinName scl, int chip_address) : i2c(sda, scl)
{
   this->i2c_address=chip_address;
   char write_data[2];
   bool err=false;
   write_data[0]=FXOS8700CQ_CTRL_REG1;
   write_data[1]=0x00;
   err=err || i2c.write( i2c_address <<1,write_data,2);
   write_data[0]=FXOS8700CQ_M_CTRL_REG1;
   write_data[1]=0x1F;
   err=err ||  i2c.write( i2c_address <<1,write_data,2);
   write_data[0]=FXOS8700CQ_M_CTRL_REG2;
   write_data[1]=0x20;
   err=err ||  i2c.write( i2c_address <<1,write_data,2);
   write_data[0]=FXOS8700CQ_XYZ_DATA_CFG;
   write_data[1]=0x01;
   err=err ||  i2c.write( i2c_address <<1,write_data,2);
   write_data[0]=FXOS8700CQ_CTRL_REG1;
   write_data[1]=0x0D;
   err=err ||  i2c.write( i2c_address <<1,write_data,2);
   this->i2c_error=err;
}



FXOS8700::~FXOS8700()
{

}

FXOS8700_data FXOS8700::read()
{
       char read_data[14]={0};
       char write_data[8]={0};
       write_data[0]=FXOS8700CQ_STATUS;
       i2c.write( i2c_address <<1,write_data,1,1);
       i2c.read( i2c_address <<1,read_data,13);
       readdata.x = (int16_t)(((read_data[1] << 8) | read_data[2]))>> 2;
       readdata.y = (int16_t)(((read_data[3] << 8) | read_data[4]))>> 2;
       readdata.z = (int16_t)(((read_data[5] << 8) | read_data[6]))>> 2;
       readdata.mx = (read_data[7] << 8) | read_data[8];
       readdata.my = (read_data[9] << 8) | read_data[10];
       readdata.mz = (read_data[11] << 8) | read_data[12];
       return (readdata);

}
