/* Copyright (c) 2017 JHD
 */

#ifndef FXOS8700_H
#define FXOS8700_H

#include "mbed.h"
#include "stdint.h"

struct FXOS8700_data
{
	int16_t x;
	int16_t y;
	int16_t z;
	int16_t mx;
	int16_t my;
	int16_t mz;

};

//  FXOS8700 registers
#define FXOS8700CQ_STATUS 0x00
#define FXOS8700CQ_WHOAMI 0x0D
#define FXOS8700CQ_XYZ_DATA_CFG 0x0E
#define FXOS8700CQ_CTRL_REG1 0x2A
#define FXOS8700CQ_M_CTRL_REG1 0x5B
#define FXOS8700CQ_M_CTRL_REG2 0x5C
#define FXOS8700CQ_WHOAMI_VAL 0xC7

//!Library for the FXOS8700 magnetometer.

class FXOS8700
{
public:
  //!Creates an instance of the class.
  /*!
  Connect module at I2C address addr using I2C port pins sda and scl.
  */
  FXOS8700(PinName sda, PinName scl, int chip_address);
  
  /*!
  Destroys instance.
  */ 
  ~FXOS8700();
  
  //!Reads the current registers.
  int i2c_address;
  FXOS8700_data read();  
  bool i2c_error;
  
private:
  
  I2C i2c;
  FXOS8700_data readdata;

};

#endif
