#include <mbed.h>
#include <mpr121.h>
#include "uLCD_4DGL.h"
#include "Speaker.h"
#include "SDFileSystem.h"
#include "wave_player.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

SDFileSystem sd(p5, p6, p7, p8,"sd"); //SD card

uLCD_4DGL uLCD(p13,p14,p11);

AnalogOut DACout(p18);
wave_player waver(&DACout);


// Create the interrupt receiver object on pin 26
InterruptIn interrupt(p26);
InterruptIn pardon(p25);
// Setup the i2c bus on pins 9 and 10
I2C i2c(p9, p10);
I2C i2c2(p28, p27);
// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);
Mpr121 pad(&i2c2, Mpr121::ADD_VSS);

//Speaker mySpeaker(p21);

int key_code;
int Past_code;
int Past_code2;
bool PlayPtr;
 
// Key hit/release interrupt routine for 1st touchpad
void fallInterrupt() {
  key_code=77;
  Past_code=77;
  int value=mpr121.read(0x00);
  value +=mpr121.read(0x01)<<8;
  
  
  // puts key number out to LEDs for demo
  for(int i=0; i<12; i++) 
  {
    
    if(((value>>i)&0x01) == 1)
    {
        key_code = i;
    }
    
  }
  
 uLCD.locate(1,2);
 uLCD.printf("%2D",key_code);
    uLCD.cls();
  uLCD.printf("\n%2D\n", key_code);
  uLCD.printf("\n%2D\n", Past_code);
  if(key_code != Past_code)
  {
      PlayPtr = false;
  }
  else
  {
      PlayPtr = true;
  }
  Past_code = key_code;
  
  
}

//sets up interrupts for 2nd toucpad
void fallInterrupt2() {
  key_code=77;
  Past_code2=77;
  int value2=pad.read(0x00);
  value2 +=pad.read(0x01)<<8;
  
  // puts key number out to LEDs for demo
  for(int j=0; j<12; j++) 
  {
    
    if(((value2>>j)&0x01) == 1)
    {
        key_code= j +12;
        
    }
  }
  
    if(key_code != Past_code2)
    {
      PlayPtr = false;
    }
    else
    {
      PlayPtr = true;
    }
    Past_code2 = key_code;

  
  uLCD.locate(1,3);
  uLCD.printf("%2D",key_code);
  
  
}
 
int main() {
  pardon.fall(&fallInterrupt2);
  pardon.mode(PullUp);
  interrupt.fall(&fallInterrupt);
  interrupt.mode(PullUp);
  
  FILE *wave_file;
  
  while(1)
  {
      switch(key_code) //uses a case for each individual touch sensor
      {
        case 0:
            //mySpeaker.PlayNote(969.0, 0.5, 0.5);
            wave_file = fopen("/sd/piano_G.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 1:
            //mySpeaker.PlayNote(200.0, 0.1, 0.1);
            wave_file = fopen("/sd/piano_F_sharp.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            led1 = 1;
            break;
        case 2:
            //mySpeaker.PlayNote(300.0, 0.1, 0.1);
            wave_file = fopen("/sd/piano_B.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 3:
            //mySpeaker.PlayNote(500.0, 0.15, 0.1);
            wave_file = fopen("/sd/piano_A_sharp.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 4:
            //mySpeaker.PlayNote(700.0, 0.15, 0.1);
            wave_file = fopen("/sd/Gb3.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 5:
            //mySpeaker.PlayNote(600.0, 0.15, 0.1);
            wave_file = fopen("/sd/G3.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 6:
            //mySpeaker.PlayNote(969.0, 0.5, 0.5);
            wave_file = fopen("/sd/F3.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 7:
            //mySpeaker.PlayNote(161.0, 0.25, 0.01);
            wave_file = fopen("/sd/Eb4.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 8:
            //mySpeaker.PlayNote(869.0, 0.5, 0.5);
            wave_file = fopen("/sd/Eb3.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 9:
            //mySpeaker.PlayNote(769.0, 0.5, 0.5);
            wave_file = fopen("/sd/E3.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 10:
            //mySpeaker.PlayNote(669.0, 0.5, 0.5);
            wave_file = fopen("/sd/Db4.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 11:
            //mySpeaker.PlayNote(469.0, 0.5, 0.5);
            wave_file = fopen("/sd/Db3.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 12:
            //mySpeaker.PlayNote(969.0, 0.5, 0.5);
            wave_file = fopen("/sd/D4.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 13:
            //mySpeaker.PlayNote(200.0, 0.1, 0.1);
            wave_file = fopen("/sd/Db3.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            led1 = 1;
            uLCD.printf("Hey");
            break;
        case 14:
            //mySpeaker.PlayNote(300.0, 0.1, 0.1);
            wave_file = fopen("/sd/C4.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 15:
            //mySpeaker.PlayNote(500.0, 0.15, 0.1);
            wave_file = fopen("/sd/C3.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 16:
            //mySpeaker.PlayNote(700.0, 0.15, 0.1);
            wave_file = fopen("/sd/Bb3.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 17:
            //mySpeaker.PlayNote(600.0, 0.15, 0.1);
            wave_file = fopen("/sd/Bb2.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 18:
            //mySpeaker.PlayNote(969.0, 0.5, 0.5);
            wave_file = fopen("/sd/B3.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 19:
            //mySpeaker.PlayNote(161.0, 0.25, 0.01);
            wave_file = fopen("/sd/B2.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 20:
            //mySpeaker.PlayNote(869.0, 0.5, 0.5);
            wave_file = fopen("/sd/Ab3.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 21:
            //mySpeaker.PlayNote(769.0, 0.5, 0.5);
            wave_file = fopen("/sd/A3.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 22:
            //mySpeaker.PlayNote(669.0, 0.5, 0.5);
            wave_file = fopen("/sd/C3.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
        case 23:
            //mySpeaker.PlayNote(469.0, 0.5, 0.5);
            wave_file = fopen("/sd/C4.wav","r");
            waver.play(wave_file, &PlayPtr);
            fclose(wave_file);
            break;
      }
  }
}

