#include "mbed.h"
#include "PinDetect.h"
#include "SDFileSystem.h"
#include <vector>
#include <string>
#include "wave_player.h"

DigitalOut myled(LED1);
PwmOut alarm(p22);
AnalogOut DACout(p18);
PinDetect snooze(p23);
PinDetect stop(p24);
SDFileSystem sd(p5, p6, p7, p8, p12, "sd"); //SD card


volatile bool t = true;
volatile bool play = true;
 volatile float vol = .52;
 volatile bool insert;
 volatile int index;
wave_player waver(&DACout);
int num = 0;
vector<string> filenames; //filenames are stored in a vector string

void read_file_names(char *dir)
{
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
    //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
        num++;
    }
    num= num;
}

void snooze_hit_callback(void) {
    alarm = 0.0;
    wait(20);
    if (insert == true) {
        play =! play;
        wait(20);
        play =! play;
    }
}

void stop_hit_callback(void){
    //alarm = 0.0;
    //state = off;
    myled = 1;
   vol = 0.0;
   //wait(1000);
   t = false;
   if (insert == true){
       play =! play;
       }
}
int main() {
snooze.mode(PullUp);
stop.mode(PullUp);
//pb3.mode(PullUp);

//Delay for initial pullup to take effect
wait(.01);

//Setup Interrupt callback functions for a pb hit
snooze.attach_deasserted(&snooze_hit_callback);
stop.attach_deasserted(&stop_hit_callback);
//pb3.attach_deasserted(&pb3_hit_callback);

//Start sampling pb inputs using interrupts
snooze.setSampleFrequency(); //default is 20KHz sampling
stop.setSampleFrequency(); 
//pb3.setSampleFrequency();
//pushbuttons now setup and running
    

while(t == true) {
     insert = sd.SD_inserted();
    if ((insert == true) && (play ==true)) {
            read_file_names("/sd/myMusic");
            //string str2 = filenames[index].substr(0,filenames[index].length()-4);
            FILE *wave_file;
            string filepath = "/sd/mymusic/";
            wave_file = fopen( (filepath+filenames[index]).c_str(), "r");
            waver.play(wave_file, &play);
           if (feof(wave_file)) // when playback ends file will close and play will equal false
            {
            fclose(wave_file);
            //play=!play;
            } 
             
             myled != myled;
        }
    if ((insert == false)&&(play == true)) {
        // generate a 500Hz tone using PWM hardware output
    
        for (int j=0; j<26; j=j+2) {
            alarm.period(1.0/500.0); // 500hz period
            alarm =vol; //50% duty cycle - max volume
            wait(.5);
            //alarm=0.0; // turn off audio
            alarm.period(0.0/500.0);
            wait(.5);
            } // end of for
    
        // two tone police siren effect -  two periods or two frequencies
        // increase volume - by changing the PWM duty cycle
        for (int i=0; i<26; i=i+2) {
            alarm = vol;
            alarm.period(1.0/969.0);
            wait(.5);
            alarm.period(1.0/800.0);
            wait(.5);
          } //end of for
    
        //alarm = 0.0;
    } //end of if

}// end of while
    while (t == false) {
        alarm = 0.0;
        //fclose(wave_file);
        }
}// end of main
