#ifndef SN_SnPowerFrame
#define SN_SnPowerFrame

#include <stdint.h>

#include "SnCommWin.h"

class SnPowerFrame {
 public:
    static const uint8_t    kIOvers; // MUST BE INCREASED if any member var changes (==> also if kNchans, etc. change!)
    static const uint32_t   kMaxSizeOf = sizeof(uint8_t) + (4u*sizeof(float)) + sizeof(uint32_t);
    
 private:
    float       faveV1;
    float       faveV2;
    float       frmsV1;
    float       frmsV2;
    uint32_t    fTime;
    
 public:
    SnPowerFrame(const float av1=0, const float av2=0, 
                 const float rv1=0, const float rv2=0,
                 const uint32_t time=0)
        : faveV1(av1), faveV2(av2), frmsV1(rv1), frmsV2(rv2), fTime(time) {}
    virtual ~SnPowerFrame() {}
    
    float       GetAveV1() const { return faveV1; }
    float       GetAveV2() const { return faveV2; }
    float       GetRmsV1() const { return frmsV1; }
    float       GetRmsV2() const { return frmsV2; }
    uint32_t    GetTime() const { return fTime; }
    
    void        SetAveV1(const float av) { faveV1 = av; }
    void        SetAveV2(const float av) { faveV2 = av; }
    void        SetRmsV1(const float rm) { frmsV1 = rm; }
    void        SetRmsV2(const float rm) { frmsV2 = rm; }
    void        SetTime(const uint32_t t) { fTime = t; }
    void        Set(const float av1, const float av2,
                    const float rm1, const float rm2,
                    const uint32_t time) {
        faveV1 = av1; faveV2 = av2;
        frmsV1 = rm1; frmsV2 = rm2;
        fTime = time;
    }
    
    static
    uint32_t SizeOf(const uint8_t rv=SnPowerFrame::kIOvers) { 
        if (rv==1) {
            return sizeof(uint8_t) + (2u*sizeof(uint16_t));
        } else {
            return kMaxSizeOf;
        }
    }
    
    template<class T>
    SnCommWin::ECommWinResult WriteTo(T& x) const {
        x = SnBitUtils::WriteTo(x, kIOvers);
        x = SnBitUtils::WriteTo(x, faveV1);
        x = SnBitUtils::WriteTo(x, faveV2);
        x = SnBitUtils::WriteTo(x, frmsV1);
        x = SnBitUtils::WriteTo(x, frmsV2);
        x = SnBitUtils::WriteTo(x, fTime);
        return SnCommWin::kOkWithMsg;
    }
    
    template<class T>
    SnCommWin::ECommWinResult ReadFrom(T& b) {
        uint8_t Rv=0;
        b           = SnBitUtils::ReadFrom(b, Rv);
        if (Rv==1) {
            uint16_t v1, v2;
            b       = SnBitUtils::ReadFrom(b, v1);
            b       = SnBitUtils::ReadFrom(b, v2);
            faveV1 = v1;
            faveV2 = v2;
            frmsV1 = frmsV2 = 0;
            fTime  = 0;
        } else if (Rv>1) {
            b       = SnBitUtils::ReadFrom(b, faveV1);
            b       = SnBitUtils::ReadFrom(b, faveV2);
            b       = SnBitUtils::ReadFrom(b, frmsV1);
            b       = SnBitUtils::ReadFrom(b, frmsV2);
            b       = SnBitUtils::ReadFrom(b, fTime);
        }
        return SnCommWin::kOkWithMsg;
    }
    
};

#endif // SN_SnPowerFrame
