#ifndef SN_SnSigProcDataTable
#define SN_SnSigProcDataTable

#include "SnPreCompOptions.h"

#include <stdint.h>

// use template specialization to cause a compiler
// error if we change the number of samples in the future
// and no appropriate data table is supplied
template<int NSMP>
struct SnSigProcDataTable {
};

// save RAM by not implementing data tables that won't be used
// (altho I guess they will be optimized away in any case)
#if (CHIPBOARD==SST4CH) || (CHIPBOARD==SST4CH_1GHz) || (CHIPBOARD==SST8CH) || (CHIPBOARD==SST8CH_1GHz)
// hard code the number here because these tables are only valid for this value.
// use kNsamps when instantiating it, though, so a compiler error will happen
// if there's no data table for that number of samples.
template<>
struct SnSigProcDataTable<256> {

    // these are the pairs: (j, m) at each step of the loop over odd
    // values of i in DiscreteCpxFFT
    typedef      uint8_t                DfftDivideIndicies_t;    // get away with only 8 bits for 256 samples
    static const DfftDivideIndicies_t   kDfftDivideIndicies[256];
    
    // these are the twidle factors: wr, wi used in DiscreteCpxFFT
    typedef      float                  DfftTwidleFactor_t;
    static const DfftTwidleFactor_t     kDfftTwidleFactors[254];
    
    typedef      float                  RealDfftTwidleFactor_t;
    static const RealDfftTwidleFactor_t kRealDfftTwidleFactor[126];
    
};
#endif

#if CHIPBOARD==ATWD4CH
// hard code the number here because these tables are only valid for this value.
// use kNsamps when instantiating it, though, so a compiler error will happen
// if there's no data table for that number of samples.
template<>
struct SnSigProcDataTable<128> {
    // these are the pairs: (j, m) at each step of the loop over odd
    // values of i in DiscreteCpxFFT
    typedef      uint8_t                DfftDivideIndicies_t;    // get away with only 8 bits for 256 samples
    static const DfftDivideIndicies_t   kDfftDivideIndicies[128];
    
    // these are the twidle factors: wr, wi used in DiscreteCpxFFT
    typedef      float                  DfftTwidleFactor_t;
    static const DfftTwidleFactor_t     kDfftTwidleFactors[126];
    
    typedef      float                  RealDfftTwidleFactor_t;
    static const RealDfftTwidleFactor_t kRealDfftTwidleFactor[62];
};
#endif

#if (CHIPBOARD==SST4CH512) || (CHIPBOARD==SST4CH512_1GHz)
// hard code the number here because these tables are only valid for this value.
// use kNsamps when instantiating it, though, so a compiler error will happen
// if there's no data table for that number of samples.
template<>
struct SnSigProcDataTable<512> {

    // these are the pairs: (j, m) at each step of the loop over odd
    // values of i in DiscreteCpxFFT
    typedef      uint16_t                DfftDivideIndicies_t;    // need 9 bits for 512 samples (biggest value in array is 511)
    static const DfftDivideIndicies_t   kDfftDivideIndicies[512];
    
    // these are the twidle factors: wr, wi used in DiscreteCpxFFT
    typedef      float                  DfftTwidleFactor_t;
    static const DfftTwidleFactor_t     kDfftTwidleFactors[510];
    
    typedef      float                  RealDfftTwidleFactor_t;
    static const RealDfftTwidleFactor_t kRealDfftTwidleFactor[254];
    
};
#endif


#endif // SnSigProcDataTable