#ifndef SN_SnPreCompOptions
#define SN_SnPreCompOptions

/******************************************************************************
** NOTE NOTE NOTE NOTE NOTE
**
** These settings are essential! Double check ALL settings!
** 
** To change for new hardware, set BOTH appropriately:
** CHIPBOARD
** DAC_BITS
******************************************************************************/


// whether to send debugging output to the serial (usb) port
// note that this file may not be included in cpp files, so it
// may be necessary to add more DEBUG defines in those files.
// also, the comms and peripherals packages will have their own
// separate debug switches too.
//#define DEBUG

// sorry for the double negative, but.. normally this is NOT DEFINED
// uncommenting this will allow any values to be specified in a configuration
// leaving it commented out is safer
#define DISABLE_CONFIG_SAFETYNETS

// choose which communication peripherals will be used in the comms loop
// for now, twitter is completely not working.
// NOTE: remember to set kNcomms in SnConstants.h so it equals the number
// of comms enabled!!
#define ENABLE_AFAR_COMM
#define ENABLE_SBD_COMM
//#define ENABLE_USB_COMM
//#define ENABLE_AFAR_TWITTER // this is stupid and doesn't work anymore. do not enable.

// turn this on to record how long it takes to take and save events
//#define EVT_TIME_PROFILE

// print the start and stop running messages on the seial (USB) port
// even if other debugging messages are disabled.
//#define SSNOTIFY

// use MODSERIAL (a buffered serial interface) instead of the
// "standard" serial (unbuffered) provided by mbed
#define USE_MODSERIAL


// available CHIPBOARDs -- these values should NEVER change!
// this is just a definition of constants. CHIPBOARD is the
// variable that must be set equal to one of these constants.
#define ATWD4CH        0  // set CHIPBOARD to this to get firmware for the 2012-2013 stations (value is arbitrary but unique)
#define SST4CH         1  // set CHIPBOARD to this to get firmware for the 2014/2015 stations with a single SST chip (value is arbitrary but unique)
#define SST4CH_1GHz    2  // set CHIPBOARD to this to get firmware for the 2015 station with a single SST chip running at 1GHz sampling rather than 2GHz (value is arbitrary but unique)
#define SST4CH512      3  // set CHIPBOARD to this to get firmware for the 2014/2015 stations with a single SST chip (value is arbitrary but unique)
#define SST4CH512_1GHz 4  // set CHIPBOARD to this to get firmware for the 2015 station with a single SST chip running at 1GHz sampling rather than 2GHz (value is arbitrary but unique)
#define SST8CH         5  // set CHIPBOARD to this to get firmware for the 2014/2015 stations with 2 SST chips (value is arbitrary but unique)
#define SST8CH_1GHz    6  // set CHIPBOARD to this to get firmware for the 2015 station with 2 SST chips running at 1GHz sampling rather than 2GHz (value is arbitrary but unique)

// which chip/board combination to build this firmware for
//#define CHIPBOARD ATWD4CH
//#define CHIPBOARD SST4CH
#define CHIPBOARD SST4CH_1GHz
//#define CHIPBOARD SST4CH512                // warning: 4*512 samples may fill up the 32kB of RAM. it may be necessary to comment out ENABLE_AFAR_COMM in order to free up RAM
//#define CHIPBOARD SST4CH512_1GHz           // warning: 4*512 samples may fill up the 32kB of RAM. it may be necessary to comment out ENABLE_AFAR_COMM in order to free up RAM
//#define CHIPBOARD SST8CH                   // warning: 8*256 samples may fill up the 32kB of RAM. it may be necessary to comment out ENABLE_AFAR_COMM in order to free up RAM
//#define CHIPBOARD SST8CH_1GHz              // warning: 8*256 samples may fill up the 32kB of RAM. it may be necessary to comment out ENABLE_AFAR_COMM in order to free up RAM

// how many bits the DACs use
#define DAC_BITS 12   // use for 4ch atwd/sst boards
//#define DAC_BITS 16   // use for 8ch sst boards (2017-18)

// whether or not to use the flash memory on the mbed board, to call
// the mbed provided function that gets the MAC address, etc.
// these functions all use the mbed interface chip. it has been found
// that once in while, functions accessing the interface chip will block
// forever and never return, resulting in a "brain dead" station.
// therefore, this should almost certainly be disabled (commented out)
// for stations installed in the ice.
#define USE_INTERFACE_CHIP

// if defined, try to read the default config from the SD card
// instead of the interface chip
//#define LOAD_DEFAULT_CONFIG_FROM_SD

// if defined, will start with both AFAR and SBD powered up during the
// first comm win after boot up. otherwise, only SBD will be powered
#define AFAR_ON_FIRST_COMM_HARDCONF

// whether or not to try to load the default config (wherever it's
// located -- SD card or interface_chip) immediately -- that is, before
// even the first communication. Be careful! It's possible this can fail
// and prevent any communications, possibly resulting in a "brain dead"
// station? Safer to leave this commented out.
#define LOAD_DEFAULT_CONFIG_IMMEDIATELY

// whether or not to use the lookup tables to speed up the FFTs
#define USE_DFFT_LUTS

// use of the real time operating system has not been implemented
// for some time -- enabling this will not work any more.
// some development will be needed, including a RTOS aware networking package
//#define USE_RTOS // change USE_RTOS in CommConstants and EthernetPower also

// an outdated switch. currently only NetServicesMin is available.
//#define USE_ETH_INTERFACE


#endif // SN_SnPreCompOptions
