#ifndef MB_Watchdog
#define MB_Watchdog

#define WDFAILSAFE  (1200u)

//#define DEBUG

// Adapted from Simon's Watchdog code from
// http://mbed.org/forum/mbed/topic/508/
namespace Watchdog {
    
    // "kick" or "feed" the dog - reset the watchdog timer
    // by writing this required bit pattern
    inline
    void kick() {
#ifdef DEBUG
        printf("WDkick. wdtc=%u, wdtv=%u (at %u)\r\n",
            LPC_WDT->WDTC, LPC_WDT->WDTV, time(0));
#endif
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
    
    // Load timeout value in watchdog timer and enable
    inline
    void kick(const float s) {
#ifdef DEBUG
        printf("WDkick s=[%g]     \r\n",s);
        printf("SystemCoreClock=[%u]\r\n",(uint32_t)SystemCoreClock);
#endif
//        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        // WD has a fixed /4 prescaler, PCLK default is /4
//        static const float clk = static_cast<float>(SystemCoreClock / 16);
        LPC_WDT->WDCLKSEL = 0x00;                // Set CLK src to Internal RC
        static const float clk = static_cast<float>(1e6); // 4MHz / 4 for WD prescaler
#ifdef DEBUG
        printf("s=[%g], clk=%g, sc=%u\r\n", s, clk, uint32_t(s*clk));
#endif
        LPC_WDT->WDTC = static_cast<uint32_t>(s * clk);
//        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
        LPC_WDT->WDMOD |= 0x3;                   // Enabled and Reset
        kick();
    }
    
    inline
    bool didWatchdogReset() {
        return ( (LPC_WDT->WDMOD) & 0x4 );
    }
    
    inline
    void clearResetFlag() {
        LPC_WDT->WDMOD &= ~(0x4);
    }
    
    struct SnKickStarter {
        SnKickStarter(const float s) {
            Watchdog::kick(s);
        }
    };
 
};


#endif // MB_Watchdog
