#include "SnLPC1768UID.h"

#include "mbed.h"

/*
 * How to read LPC1768 part ID and device serial number
 * Dan Minear
 * 2012-11-08
 */

#define IAP_LOCATION 0x1FFF1FF1
 
typedef void (*IAP)(uint32_t [], uint32_t[] );
IAP iap_entry = (IAP) IAP_LOCATION;

bool SnLPC1768UID::GetUID(uint32_t uid[SnLPC1768UID::kUIDlen]) {
#ifdef DEBUG
    printf("SnLPC1768UID::GetUID ... \r\n");
#endif
    // 58 here asks for the UID of the chip
    static const uint8_t kLenCmd = kUIDlen + 1;
    uint32_t command[kLenCmd] = {58,0,0,0,0};
    uint32_t result[kLenCmd]  =  {0,0,0,0,0};
    iap_entry(command, result);
    if (result[0] == 0) {
        for(int i = 0; i < kUIDlen; ++i) {
            uid[i] = result[i+1];
#ifdef DEBUG
            printf( "0x%08X\r\n", uid[i] );
#endif
        }
        return true;
        
    } else {
#ifdef DEBUG
        printf("Status error!\r\n");
#endif

    }
    return false;
};
