#ifndef SN_SnCommWinTwitter
#define SN_SnCommWinTwitter

#include "SnCommWinAfar.h"

class SnCommWinTwitter : public SnCommWinAfar {
 public:
    static const char*          kTwitIP;
    static const char*          kTwitUrl;
    static const char*          kB64cred;

 private:
    SnCommWin::ECommWinResult SendTweet(const char* str,
                                        const uint32_t timeout);

    void    GetTimeTweet(char* genBuf, const SnConfigFrame& conf);
    void    GetRunTweet(char* genBuf, const SnConfigFrame& conf);
    void    GetRatesTweet(char* genBuf,
                          const SnConfigFrame& conf,
                          const float thmrate,
                          const float evtrate);
    void    GetBytesTweet(char* genBuf, const SnConfigFrame& conf);
    char*   GetGreeting(char* genBuf, const SnConfigFrame& conf);
    char*   AppendMacId(char* genBuf, const SnConfigFrame& conf);

 public:
    SnCommWinTwitter(const SnConfigFrame& conf);
    virtual ~SnCommWinTwitter() {}

    SnCommWin::ECommWinResult Tweet(const SnConfigFrame& conf,
                                    const float thmrate,
                                    const float evtrate,
                                    char* genBuf,
                                    const uint32_t timeout);

    void    GetTweet(char* genBuf,
                     const SnConfigFrame& conf,
                     const float thmrate,
                     const float evtrate);

};

#endif // SN_SnCommWinTwitter
