#ifndef SN_SnHeartbeatFrame
#define SN_SnHeartbeatFrame

#include <stdint.h>
#include "SnCommWin.h"

class SnHeartbeatFrame {
 public:
    // i/o version
    static const uint8_t    kIOVers;   // MUST BE INCREASED if any member var changes
    static const uint32_t   kMaxSizeOf = 2u*sizeof(uint32_t) + sizeof(uint8_t);

 private:
    uint32_t fTime;
    uint32_t fNum;

 public:
    SnHeartbeatFrame() {}
    virtual ~SnHeartbeatFrame() {}
    
    uint32_t GetTime() const { return fTime; }
    uint32_t GetNum() const { return fNum; }
    
    void SetTime(const uint32_t t) { fTime = t; }
    void SetNum(const uint32_t n) { fNum = n; }
    
    static
    uint32_t SizeOf(const uint8_t rv=SnHeartbeatFrame::kIOVers) { 
        if (rv>1) {
            return kMaxSizeOf;
        } else {
            return kMaxSizeOf - sizeof(uint8_t);
        }
    }

    template<class T>
    SnCommWin::ECommWinResult WriteTo(T& x) const {
        return WriteTo(x, fTime, fNum);
    }
    
    template<class T>
    static
    SnCommWin::ECommWinResult WriteTo(T& x,
                                      const uint32_t time,
                                      const uint32_t num) {
        // expect 'x' to be a MODSERIAL or a char const*
        x = SnBitUtils::WriteTo(x, kIOVers);
        x = SnBitUtils::WriteTo(x, time);
        x = SnBitUtils::WriteTo(x, num);
        return SnCommWin::kOkMsgSent;
    }
    
    template<class T>
    static
    SnCommWin::ECommWinResult ReadFrom(T& b,
                                       uint32_t& time,
                                       uint32_t& num) {
        // this can't read V1 of the heartbeat
        uint8_t Rv=0;
        b           = SnBitUtils::ReadFrom(b, Rv);
        b           = SnBitUtils::ReadFrom(b, time);
        b           = SnBitUtils::ReadFrom(b, num);
        return SnCommWin::kOkWithMsg;
    }

    template<class T>
    static
    SnCommWin::ECommWinResult ReadFromV1(T& b,
                                       uint32_t& time,
                                       uint32_t& num) {
        // need a special fcn to read V1 of this frame,
        // since the i/o version was not written out in V1
        b           = SnBitUtils::ReadFrom(b, time);
        b           = SnBitUtils::ReadFrom(b, num);
        return SnCommWin::kOkWithMsg;
    }
    

};

#endif // SN_SnHeartbeatFrame