#include "SnCommWinTwitter.h"

#include "SnSDUtils.h"
#include "SnConfigFrame.h"
#include "SnStatusFrame.h"
#include "SnCommAfarNetIf.h"

//#define DEBUG

#define MAX_TWEET_LEN 130
#define TWIT_PORT 80
const char* SnCommWinTwitter::kTwitIP     = "66.180.175.246"; // api.supertweet.net
const char* SnCommWinTwitter::kTwitUrl    = "/1.1/statuses/update.json";
// these are for ariannatwittest (the test account)
//const char* SnCommWinTwitter::kCred       = "ariannatwittest:st11amtice";
const char* SnCommWinTwitter::kB64cred    = "YXJpYW5uYXR3aXR0ZXN0OnN0MTFhbXRpY2U="; // base64 encoded credential
// these are for arianna.icicle (the "real" account)
//const char* SnCommWinTwitter::kCred       = "arianna.icicle:st11ibAmicetw";
//const char* SnCommWinTwitter::kB64cred    = "YXJpYW5uYWljaWNsZTpzdDExaWJBbWljZXR3"; // base64 encoded credential

SnCommWinTwitter::SnCommWinTwitter(const SnConfigFrame& conf) :
    SnCommWinAfar(new SnCommAfarNetIf(kTwitIP, TWIT_PORT,
                                      conf.GetMbedIP(),
                                      conf.GetMbedMask(),
                                      conf.GetMbedGate())) {
    // prevent this second NetIf from re-initializing the ethernet,
    // which would cause a crash
    static_cast<SnCommAfarNetIf*>(fComm)->SetEthSetup(true);
    // make the random number sequence unique for each station
    srand(conf.GetMacAddress() & 0xFFFFFFFF);
}

SnCommWin::ECommWinResult SnCommWinTwitter::SendTweet(const char* str,
                                                     const uint32_t timeout) {
    SnCommWin::ECommWinResult res = SnCommWin::kUndefFail;
    // first send headers
    const uint32_t slen = strlen(str);
    const uint32_t len  = (slen>MAX_TWEET_LEN) ? MAX_TWEET_LEN : slen;
    char lenstr[16];
    sprintf(lenstr, "%u", len);
    std::string post(
            "POST /1.1/statuses/update.json HTTP/1.0\r\n"\
            "HOST: api.supertweet.net\r\n"\
            "Authorization: Basic ");
    post +=                       kB64cred;
    post +=                               "\r\n"\
            "Content-length: ";
    post +=                  lenstr;
    post +=                      "\r\n"\
            "Content-Type: application/x-www-form-urlencoded\r\n"\
            "\r\n";
#ifdef DEBUG
    printf("sending tweet:\r\n");
    printf("%s",post.c_str());
#endif
    const uint32_t ps = post.size();
    int32_t mlen = fComm->SendAll(post.c_str(), ps, timeout);
    mlen += fComm->FinishSending(timeout);
    if (ps==mlen) {
        // send content
#ifdef DEBUG
        printf("%s\r\n",str);
#endif
        mlen  = fComm->SendAll(str, len, timeout);
        mlen += fComm->SendAll("\r\n\r\n\r\n", 6u, timeout);
        mlen += fComm->FinishSending(timeout);
        if ((6u+len)==mlen) {
            res = SnCommWin::kOkMsgSent;
        }
    }
    return res;
}

SnCommWin::ECommWinResult SnCommWinTwitter::Tweet(
                                                  const SnConfigFrame& conf,
                                                  const float thmrate,
                                                  const float evtrate,
                                                  char* genBuf,
                                                  const uint32_t timeout) {
#ifdef DEBUG
    printf("calling tweet with thmr=%g, evtr=%g, to=%u\r\n",
        thmrate, evtrate, timeout);
#endif
    GetTweet(genBuf, conf, thmrate, evtrate);
    return SendTweet(genBuf, timeout);
}

void SnCommWinTwitter::GetTweet(char* genBuf,
                                const SnConfigFrame& conf,
                                const float thmrate,
                                const float evtrate) {
    const bool rok = (thmrate>0) && (evtrate>0);
    const int r = rok ? (rand() % 4) : (rand() % 3);
    char* b = genBuf;
    b += sprintf(b, "status=");
    if        (r==0) {
        GetTimeTweet(b, conf);
    } else if (r==1) {
        GetRunTweet(b, conf);
    } else if (r==2) {
        GetBytesTweet(b, conf);
    } else if (r==3) {
        GetRatesTweet(b, conf, thmrate, evtrate);
    }
}

void SnCommWinTwitter::GetTimeTweet(char* genBuf,
                                    const SnConfigFrame& conf) {
    time_t s = time(0);
    char* b = AppendMacId(genBuf, conf);
    b += sprintf(b, ": It's ");
    b += strftime(b, 32, "%H:%M:%S on %Y-%m-%d", localtime(&s));
    b += sprintf(b, " in the ice.");
}

void SnCommWinTwitter::GetRunTweet(char* genBuf,
                                   const SnConfigFrame& conf) {
    char* b = GetGreeting(genBuf, conf);
    b += sprintf(b, " I'm making run %u, sequence %hu.",
                 conf.GetRun(), SnSDUtils::GetCurSeqNum());
}

void SnCommWinTwitter::GetRatesTweet(char* genBuf,
                                     const SnConfigFrame& conf,
                                     const float thmrate,
                                     const float evtrate) {
    char* b = GetGreeting(genBuf, conf);
    b += sprintf(b, " I'm getting %2.2f triggers and %2.2f "
                 "events per second!", thmrate, evtrate);
}

void SnCommWinTwitter::GetBytesTweet(char* genBuf,
                                     const SnConfigFrame& conf) {
    char* b = GetGreeting(genBuf, conf);
    b += sprintf(b, " I've got %2.2f MB of disk space left.",
                 SnStatusFrame::GetFreeMB());
}

char* SnCommWinTwitter::GetGreeting(char* genBuf,
                                    const SnConfigFrame& conf) {
    const int r = rand() % 4;
    char* b = genBuf;
    if        (r==0) {
        b  = AppendMacId(b, conf);
        b += sprintf(b, " here.");
    } else if (r==1) {
        b += sprintf(b, "It's ");
        b  = AppendMacId(b, conf);
        b += sprintf(b, ".");
    } else if (r==2) {
        b  = AppendMacId(b, conf);
        b += sprintf(b, " reporting in.");
    } else {
        b  = AppendMacId(b, conf);
        b += sprintf(b, " again.");
    }
    
    return b;
}

char* SnCommWinTwitter::AppendMacId(char* genBuf,
                                    const SnConfigFrame& conf) {
    char* b = genBuf;
    b += sprintf(b, "%04llX", ((conf.GetMacAddress() >> 16) & 0xFFFF));
    return b;
}
/*
bool SnCommWinTwitter::Connect(const uint32_t timeout) {
    
#ifdef DEBUG
    printf("SnCommAfarNetIf::Connect : bind\r\n");
#endif

    ip_addr_t rserv_n;
    inet_aton(fRserv.c_str(), &rserv_n);
    Host server( IpAddr(&rserv_n), fRport );
    //Host server( IpAddr(128,195,204,151), 6655 );
    
    SockConnect(server, timeout);
    
    // catch events
    fSock->setOnEvent(this, &SnCommWinTwitter::onTCPSocketEvent);
    
#ifdef DEBUG
    printf("SnCommAfarNetIf::Connect : tcp connect\r\n");
#endif
    //fEthConnected = false;
    while ( (fEthConnected==false) && (IsTimedOut(timeout)==false) ) {
        Net::poll();
        if (fConnAborted) {
            fConnAborted = false;
            //NewSocket();
            SockConnect(server, timeout);
        }
    }
    
    fEthWriteable = fEthConnected;
    return fEthConnected;

}

void SnCommWinTwitter::onTCPSocketEvent(TCPSocketEvent e)  {
    SnCommAfarNetIf::onTCPSocketEvent(e);
}
*/
