#if 0

#include "SnCommAfarTCP.h"

#include "EthernetInterface.h"
#include "TCPSocketConnection.h"

#include "Watchdog.h"

//#define DEBUG

#define CALL_MEMBER_FN(object,ptrToMember)  ((object).*(ptrToMember))

SnCommAfarTCP::SnCommAfarTCP(const SnConfigFrame& conf) :
    fUseB64(false), fRserv(conf.GetRemoteServer()),
    fRport(conf.GetRemotePort()),
    fMyIp(conf.GetMbedIP()), fMyMask(conf.GetMbedMask()), 
    fMyGate(conf.GetMbedGate()),
    fEth(new EthernetInterface), fSock(new TCPSocketConnection) {
    
#ifdef DEBUG
    printf("init. ip=%s, mas=%s, gate=%s\r\n",
        fMyIp.c_str(),fMyMask.c_str(), fMyGate.c_str());
#endif
    fEth->init(fMyIp.c_str(),fMyMask.c_str(), fMyGate.c_str());
}

SnCommAfarTCP::~SnCommAfarTCP() {
    delete fEth;
    delete fSock;
}

void SnCommAfarTCP::Set(const char* remote, const uint16_t rport,
                        const char* myip, const char* mask,
                        const char* gate, const bool useb64) {
    fUseB64 = useb64;
    fRserv  = remote;
    fRport  = rport;
    fMyIp   = myip;
    fMyMask = mask;
    fMyGate = gate;
#ifdef DEBUG
    printf("closing socket\r\n");
#endif
    fSock->close();
    //delete fSock;
    //fSock = new TCPSocketConnection;
#ifdef DEBUG
    printf("disconnect eth\r\n");
#endif
    fEth->disconnect();
    //delete fEth;
    //fEth = new EthernetInterface;
#ifdef DEBUG
    printf("init %s, %s, %s\r\n",fMyIp.c_str(), fMyMask.c_str(), fMyGate.c_str());
#endif
    fEth->init(fMyIp.c_str(), fMyMask.c_str(), fMyGate.c_str());

#ifdef DEBUG
    printf("Set done\r\n");
#endif
}

int SnCommAfarTCP::DoIO(char* const data,
                        const uint32_t length,
                        const uint32_t timeout_clock,
                        TCPSendRecv fcn) {
    // TODO: if B64, must return number of bytes of raw (non encoded) message
#ifdef DEBUG
    printf("SnCommAfarTCP::DoIO data:\r\n");
    dispStrBytes(data, length);
    printf("\r\n");
#endif
    int res=0;
    uint32_t b=0;
    while ( (length>b) ) {
        if (IsTimedOut(timeout_clock)) {
#ifdef DEBUG
            printf("SnCommAfarTCP::DoIO timing out\r\n");
#endif
            break;
        }
        res = CALL_MEMBER_FN(*fSock, fcn)(data+b, length-b);
        /*
        switch (res) {
            case -1:
                // TODO: how to check the error?
                continue;
            case 0:
                return b;
            default:
                b += res;
        };
        */
        if (res>0) {
            b += res;
        }
        //wait_ms(100);
        //Watchdog::kick(); // don't reset; wait until timeout
    }
    printf("return b=%d\r\n",b);
    return b; // timeout
}

int32_t SnCommAfarTCP::ReceiveAll(char* const buf, const uint32_t mlen,
                                  const uint32_t timeout_clock) {
    // TODO: if B64, must return number of bytes of raw (non encoded) message
    //return DoIO(buf, mlen, timeout_clock, &TCPSocketConnection::receive_all);
    // use regular receive; DoIO will do a receive_all but use our timeout
    return DoIO(buf, mlen, timeout_clock, &TCPSocketConnection::receive);
}

int32_t SnCommAfarTCP::SendAll(char* const data, const uint32_t length,
                               const uint32_t timeout_clock) {
    // TODO: if B64, must return number of bytes of raw (non encoded) message
    //return DoIO(data, length, timeout_clock, &TCPSocketConnection::send_all);
    // use regular send; DoIO will do a send_all but use our timeout
    return DoIO(data, length, timeout_clock, &TCPSocketConnection::send);
}


bool SnCommAfarTCP::Connect(const uint32_t timeout) {
#ifdef DEBUG
    printf("SnCommAfarTCP::Connect\r\n");
#endif
    bool isConn = false;

    while ( (isConn==false) && (IsTimedOut(timeout)==false) ) {
        wait_ms(250);
        isConn = (fEth->connect()==0);
    }
#ifdef DEBUG
    printf("eth isConn=%d\r\n",(int)isConn);
#endif
    
    isConn=false;
    while ( (isConn==false) && (IsTimedOut(timeout)==false) ) {
        wait_ms(250);
        isConn = (fSock->connect(fRserv.c_str(), fRport)==0);
    }
#ifdef DEBUG
    printf("sock isConn=%d\r\n",(int)isConn);
#endif
    return isConn;
}

SnCommWin::ECommWinResult SnCommAfarTCP::OpenWindow(const uint32_t timeout,
                                                    const bool sendStatus,
                                                    const SnConfigFrame& conf,
                                                    const SnEventFrame& evt,
                                                    const SnPowerFrame& pow,
                                                    const uint16_t seq,
                                                    const float thmrate,
                                                    const float evtrate,
                                                    char* const genBuf) {
#ifdef DEBUG
    printf("SnCommAfarTCP::OpenWindow\r\n");
#endif
    const bool canCon = Connect(timeout);
    
    SnCommWin::ECommWinResult ret = canCon ? SnCommWin::kConnected
                                           : SnCommWin::kCanNotConnect;
    
    if (canCon && sendStatus) {
#ifdef DEBUG
    printf("calling SendStatus\r\n");
#endif
        ret = SendStatus(conf, evt, pow, seq, thmrate, evtrate, genBuf, timeout);
    }
    
    return ret;
}

bool SnCommAfarTCP::CloseConn(const uint32_t) {
    return (fSock->close())==0;
}

#endif
