//Cave Runner Game
//Jay Haksar
//Anchit Nair

#include "mbed.h"
#include "NokiaLCD.h"
#include "ADXL345.h"
#include "beep.h"

Serial pc(USBTX, USBRX);
NokiaLCD lcd(p5, p7, p8, p9, NokiaLCD::LCD6610); //dio sck cs rst   
ADXL345 accelerometer(p11, p12, p13, p14); //sda sdo scl cs
Beep speaker(p21);
DigitalIn sw(p18);
AnalogIn xin(p19);
AnalogIn yin(p20);
Ticker scorecounter;

int score = 0;
float difficulty = 0.05;

void scoreincrease(){
    score+=10;
    difficulty-=0.0005;
}


void setScreen(int wall[], int width, int numwalls){
    //Sets the initial screen
    int current=0;
    
    lcd.fill(0,0, 130, 132, 0x00FF00);
    for(int j=0;j<131;j+=numwalls){
            lcd.fill(wall[current], j, width, numwalls, 0x000000);
            current++;
    }
}


int main() {
    
    long average[3] = {0, 0, 0};
    int measurement[3] = {0, 0, 0};
    int scaled[2] = {0,0};
    int gamestate = 0;
    int scoreboard[5] = {200, 150, 100, 50, 0};
    
    
    int ballx = 65, bally = 70, ballw = 4, ballh = 4;
    int width = 40;
    int wall[66] = {0};
    int change;
    int offset = 0;
    int numwalls = 2; 
    int check = 0;
    int prevWall;
        
    sw.mode(PullUp);
    
    accelerometer.setPowerControl(0x00);
    accelerometer.setDataFormatControl(0x0B);
    accelerometer.setDataRate(ADXL345_3200HZ);
    accelerometer.setPowerControl(0x08);
    
    for(int i=0;i<=65;i++){
        wall[i] = 46;
    }
    setScreen(wall, width, numwalls);
    
    while(1){
    
    while(gamestate == 0){
              
        lcd.fill(ballx, bally, ballw, ballh, 0x000000);
                  
        for(int i=65;i>=1;i--){
            if(i>=15){
                change = wall[i] - wall[i-1];
                if(change<0){
                    lcd.fill(wall[i],i*2,-change,numwalls,0x00FF00);
                    lcd.fill(wall[i]+width,i*2,-change,numwalls,0x000000);
                }
                else if(change>0){
                    lcd.fill(wall[i-1],i*2,change,numwalls,0x000000);
                    lcd.fill(wall[i-1]+width,i*2,change,numwalls,0x00FF00);
                }
            }
            wall[i] = wall[i-1];
        }
        
        
        prevWall = wall[0];
        
        if(wall[0] < 10){offset = -1;}
        else if(wall[0]+width > 120){offset = 1;}
        
        wall[0] =  wall[0] + ((rand() % 5) - 2 - offset);
        
        if(wall[0] <= 0){wall[0] = 1;}
        if(wall[0]+width >= 130){wall[0] = 130-width;}
        
        check = bally/numwalls;
        ballx = (wall[check] + (width/2)) - (ballw/2);        
        
        
        lcd.fill(ballx, bally, ballw, ballh, 0xFF0000);
        
        wait(0.02);
        
        lcd.fill(0,0,130,30,0x000000);
        
        lcd.locate(5,1);
        lcd.printf(" CAVE");
        lcd.locate(5,2);
        lcd.printf("RUNNER");
        
        
        if(sw == 0){
            lcd.cls();
            
            srand(time(NULL));
    
            for(int i=0;i<=65;i++){
                 wall[i] = 46;
            }
            setScreen(wall, width, numwalls);
            
            speaker.beep(100, 0.1);
            wait(0.1);
            speaker.beep(200, 0.1);
            wait(0.1);
            speaker.beep(300, 0.1);
            wait(0.1);
            speaker.beep(400, 0.2);
            wait(0.1);
            
            ballx = 65;
            bally = 65;
            scorecounter.attach(&scoreincrease, 1.0);
             
            gamestate = 1;
        }
    }
    
    while(gamestate == 1){       
         
       
        lcd.fill(ballx, bally, ballw, ballh, 0x000000);
        /*
        if(xin > 0.6 && ((ballx+ballw) < 127)){ballx+=2;}
        if(xin < 0.4 && ((ballx) > 3)){ballx-=2;}
        if(yin < 0.4 && ((bally) > 5)){bally-=2;}
        if(yin > 0.6 && ((bally+ballh) < 127)){bally+=2;}
        
        if(xin > 0.8 && ((ballx+ballw) < 126)){ballx+=3;}
        else if(xin > 0.6 && ((ballx+ballw) < 128)){ballx++;}
        else if(xin < 0.2 && ((ballx) > 4)){ballx-=3;}
        else if(xin < 0.4 && ((ballx) > 2)){ballx--;}
        
        if(yin > 0.8 && ((bally+ballh) < 128)){bally+=3;}
        else if(yin > 0.6 && ((bally+ballh) < 130)){bally++;}
        else if(yin < 0.2 && ((bally) > 6)){bally-=3;}
        else if(yin < 0.4 && ((bally) > 4)){bally--;}
         */
         
        accelerometer.getOutput(measurement);     
        
        average[0] = ((49*(long)measurement[0]) + average[0]) / 50;
        average[1] = ((49*(long)measurement[1]) + average[1]) / 50;
        average[2] = ((49*(long)measurement[2]) + average[2]) / 50;
               
        if((int16_t)average[0] > 50 && (int16_t)average[0] < 200){scaled[0] = 1;}
        else if((int16_t)average[0] < -10 && (int16_t)average[0] > -200){scaled[0] = -1;}
        else{scaled[0] = 0;}
        
        if((int16_t)average[1] > 10 && (int16_t)average[0] < 200){scaled[1] = 1;}
        else if((int16_t)average[1] < -50 && (int16_t)average[0] > -200){scaled[1] = -1;}
        else{scaled[1] = 0;}
        
        if(scaled[0] > 0 && ((ballx+ballw) < 127)){ballx+=2;}
        if(scaled[0] < 0 && ((ballx) > 3)){ballx-=2;}
        if(scaled[1] > 0 && ((bally) > 5)){bally-=2;}
        if(scaled[1] < 0 && ((bally+ballh) < 127)){bally+=2;}        
                
        
                  
        for(int i=65;i>=1;i--){
            change = wall[i] - wall[i-1];
            if(change<0){
                lcd.fill(wall[i],i*2,-change,numwalls,0x00FF00);
                lcd.fill(wall[i]+width,i*2,-change,numwalls,0x000000);
            }
            else if(change>0){
                lcd.fill(wall[i-1],i*2,change,numwalls,0x000000);
                lcd.fill(wall[i-1]+width,i*2,change,numwalls,0x00FF00);
            }
            wall[i] = wall[i-1];
        }
        
        
        prevWall = wall[0];
        
        if(wall[0] < 10){offset = -1;}
        else if(wall[0]+width > 120){offset = 1;}
        
        wall[0] =  wall[0] + ((rand() % 5) - 2 - offset);
        
        if(wall[0] <= 0){wall[0] = 1;}
        if(wall[0]+width >= 130){wall[0] = 130-width;}
            
      
        
        change = prevWall - wall[0];
        if(change<0){
            lcd.fill(prevWall,0,-change,numwalls,0x00FF00);
            lcd.fill(prevWall+width,0,-change,numwalls,0x000000);
        }
        else if(change>0){
            lcd.fill(wall[0],0,change,numwalls,0x000000);
            lcd.fill(wall[0]+width,0,change,numwalls,0x00FF00);
        }
        
        lcd.fill(ballx, bally, ballw, ballh, 0xFF0000);
        
        wait(difficulty);
      
                
        check = bally/numwalls;
        if(wall[check] >= ballx || (wall[check]+width) <= (ballx+ballh)){
           gamestate = 2;
           scorecounter.detach();
           speaker.beep(400, 0.1);
           wait(0.1);
           speaker.beep(300, 0.1);
           wait(0.1);
           speaker.beep(200, 0.1);
           wait(0.1);
           speaker.beep(100, 0.2);
           wait(0.1); 
        }

    }
    while(gamestate == 2){
        
        for(int i=4;i>=0;i--){
            if(score > scoreboard[i] && score < scoreboard[i-1]){
                scoreboard[i] = score;
            }
        }
        if(score > scoreboard[0]){scoreboard[0] = score;}
        
        lcd.locate(4,3);
        lcd.printf("%i", score);
        lcd.locate(4,4);
        lcd.printf("GAME OVER");
        for(int i=0;i<=4;i++){
            lcd.locate(4,i+5);
            lcd.printf("%i", scoreboard[i]);
        }
        
        if(sw == 0){
            ballx = 65;
            bally = 65;
            srand(time(NULL));
            for(int i=0;i<=65;i++){
                wall[i] = 46;
            }
            setScreen(wall, width, numwalls);
            gamestate = 0;
            difficulty = 0.05;
            score = 0;  
            offset = 0;          
            wait(0.5);
        }
    }
    
    }   
}





