#include "mbed.h"
#include "EthernetInterface.h"
#include "cJSON.h"

AnalogIn Gas(A2);
int socketPort = 8000;
int httpPort = 80;

Serial pc(PA_13,PA_14);

char path[]="/v1/datastreams/test/datapoint/";

int MallocSize = 800*sizeof(char);
bool socket_GET(TCPSocketConnection &conn);
bool http_GET(TCPSocketConnection &conn);
bool http_POST(TCPSocketConnection &conn);
bool socket_POST(TCPSocketConnection &conn,int vall);
bool closeConnect(TCPSocketConnection &conn);

float val;
//int mathtest;
bool out=false;

int main() { 
    int phy_link;
    pc.printf("Wait a second...\r\n");
    uint8_t mac_addr[6] = {0x78, 0x08, 0xDC, 0x1c, 0xa8, 0x95}; 
    
    EthernetInterface eth;
    eth.init(mac_addr); //Use DHCP
    eth.connect();
    pc.printf("start IP Address is %s\r\n", eth.getIPAddress());
    /*
    do{
        phy_link = eth.ethernet_link();
        pc.printf("...");
        wait(2);
    }while(!phy_link);
    printf("\r\n");
    */
    pc.printf("IP Address is %s\r\n", eth.getIPAddress());

    TCPSocketConnection conn;
    
    while(true)
    {   
        wait(1);
        val = Gas.read()*1023;
        int mathtest = ceil(val);//math.h
        pc.printf("Gas.read=%02f,n=%d\r\n",val,mathtest);
        pc.printf("start http_post\r\n");
        if(http_POST(conn))
        {
            if(!conn.close()){//短连接，断开一次连接一次
                pc.printf("conn.close OK\r\n");    
            }else{
                pc.printf("conn.close ERR\r\n"); 
                break;   
            }
        }else{
             if(out)break;   
             pc.printf("connect close err!!!to do something\r\n");

        }
        
        //val = 0.0;  
        //mathtest = 0; 
        
        if(out)break;
    }
                
    eth.disconnect();
    pc.printf("out the program!\r\n");
    return 0;                     
}

/*socket GET*/
bool socket_GET(TCPSocketConnection &conn)
{
    if(conn.is_connected()){
        pc.printf("connect is already ok!\r\n");    
    }else{
        if(!conn.connect("iot.espressif.cn", socketPort)) //80 for http,8000 for socket,处理超时，拔掉网线后，卡在conn.connect
            pc.printf("connect OK!\r\n");
        else{
            pc.printf("connct ERR!\r\n");
            out = true;
            return false;    
        }
    }
    
    cJSON * pJsonRoot = NULL;
    pJsonRoot = cJSON_CreateObject();
    if(NULL == pJsonRoot)
    {
        pc.printf("socket_GET OUT1\r\n");
        out = true;
        return false;
    }

    cJSON * pSubJson = NULL;
    pSubJson = cJSON_CreateObject();
    if(NULL == pSubJson)
    {
         cJSON_Delete(pJsonRoot);
         pc.printf("socket_GET OUT2\r\n");
         out = true;
         return false;
    }

    cJSON_AddStringToObject(pJsonRoot, "path", "/v1/datastreams/test/datapoint/");  
    cJSON_AddStringToObject(pSubJson, "Authorization", "token 48661aa81484f501362ed5ef4cc85e67eb2a3e3d");
    cJSON_AddItemToObject(pJsonRoot, "meta", pSubJson);
    cJSON_AddStringToObject(pJsonRoot, "method", "GET");  
      
    char* pJSON = cJSON_PrintUnformatted(pJsonRoot);
    strcat(pJSON,"\n");//socket at the end should have '\n',use wireshark
 
    if(NULL == pJSON)
    {
        cJSON_Delete(pJsonRoot);
        pc.printf("socket_GET OUT3\r\n");
        out = true;
        return false;
    }
    
    conn.send_all(pJSON, strlen(pJSON));//http_cmd for http,pJSON for socket,should be three changes
    pc.printf("%s\r\n",pJSON);
    
    char *buffer = NULL;
    buffer = (char *)malloc(MallocSize);
    if(!buffer)pc.printf("malloc buffer err\r\n");
    int ret;

    while (true) {
        wait(1);
        ret = conn.receive(buffer, MallocSize-1);
        pc.printf("ret = %d\r\n",ret);
        if (ret <= 0) {
            break;
        }
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server: %s\n", ret, buffer);     
    }
    pc.printf("socket_GET OUT\r\n");
    
    free(pJSON);//for socket
    cJSON_Delete(pJsonRoot);//for socket
    free(buffer);
    return true;
}

/*http_GET*/
bool http_GET(TCPSocketConnection &conn)
{
    if(conn.is_connected()){
        pc.printf("connect is already ok!\r\n");    
    }else{
        if(!conn.connect("iot.espressif.cn", httpPort)) //80 for http,8000 for socket
            pc.printf("connect OK!\r\n");
        else{
            pc.printf("connct ERR!\r\n");
            out = true;
            return false;    
        }
    }
    
    char http_cmd[] = "GET /v1/datastreams/Gas/datapoint/ HTTP/1.1\r\nUser-Agent: curl/7.22.0 (i686-pc-linux-gnu) libcurl/7.22.0 OpenSSL/1.0.1 zlib/1.2.3.4 libidn/1.23 librtmp/2.3\r\n"\
                      "Host:iot.espressif.cn\r\nAccept: */*\r\nAuthorization: token ebe1671e9d9f42a5231d017ec550552b9bae2cdf\r\n\r\n";
    
    conn.send_all(http_cmd, strlen(http_cmd));//http_cmd for http,pJSON for socket,should be three changes
    pc.printf("%s\r\n",http_cmd);
    
    //char *buffer = NULL;
    //buffer = (char *)malloc(MallocSize);
    //if(!buffer)pc.printf("malloc buffer err\r\n");
    char buffer[500];
    int ret;

    while (true) {
        wait(1);
        ret = conn.receive(buffer, 500-1);
        pc.printf("ret = %d\r\n",ret);
        if (ret <= 0) {
            break;
        }
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server: %s\n", ret, buffer);     
    }
    pc.printf("http_GET OUT\r\n");
    /* ///conn.close已经放到main中,55 行
    if(conn.close()){
        pc.printf("conn.close OK\r\n");    
    }else{
        pc.printf("conn.close ERR\r\n");    
    }
    */
    //free(buffer);
    return true;
}

/*http POST*/
bool http_POST(TCPSocketConnection &conn)
{
    pc.printf("1111\r\n");
    wait(0.5);
    if(conn.is_connected()){
        pc.printf("connect is already ok!\r\n");    
    }else{
        if(!conn.connect("iot.espressif.cn", httpPort)) //80 for http,8000 for socket
            pc.printf("connect OK!\r\n");
        else{
            pc.printf("connct ERR!\r\n");
            out = true;
            return false;    
        }
    }
    pc.printf("2222\r\n");
    cJSON* http_post=NULL;  
    http_post = cJSON_CreateObject();    
    if(NULL == http_post)
    {
         pc.printf("OUT4\r\n");
         out = true;
         return false;
    }
    pc.printf("3333\r\n");
    cJSON* http_post_json=NULL;  
    http_post_json = cJSON_CreateObject();    
    if(NULL == http_post_json)
    {
         cJSON_Delete(http_post);
         pc.printf("OUT5\r\n");
         out = true;
         return false;
    }
    cJSON_AddNumberToObject(http_post_json, "x", 2);
    //cJSON_AddNumberToObject(http_post_json, "y", 2);
    //cJSON_AddNumberToObject(http_post_json, "z", 2);
    cJSON_AddItemToObject(http_post, "datapoint", http_post_json);
    char* pJSON_http_post = cJSON_PrintUnformatted(http_post);
    pc.printf("4444\r\n");
    if(NULL == pJSON_http_post)
    {
        cJSON_Delete(http_post);
        pc.printf("OUT6\r\n");
        out = true;
        return false;
    }
    
    //Pay attention to out of memory
    //char http_POST_cmd[500] = "POST /v1/datastreams/jhtest/datapoint/ HTTP/1.1\r\nUser-Agent: curl/7.22.0 (i686-pc-linux-gnu) libcurl/7.22.0 OpenSSL/1.0.1 zlib/1.2.3.4 libidn/1.23 librtmp/2.3\r\n"\
                     // "Host:iot.espressif.cn\r\nAccept: */*\r\nAuthorization: token ebe1671e9d9f42a5231d017ec550552b9bae2cdf\r\n"\
                     // "Content-Length: 33\r\nContent-Type: application/x-www-form-urlencoded\r\n\r\n";
    char http_POST_cmd[500] = "POST /v1/datastreams/test/datapoint/ HTTP/1.1\r\nUser-Agent: curl/7.22.0 (i686-pc-linux-gnu) libcurl/7.22.0 OpenSSL/1.0.1 zlib/1.2.3.4 libidn/1.23 librtmp/2.3\r\n"\
                      "Host:iot.espressif.cn\r\nAccept: */*\r\nAuthorization: token 48661aa81484f501362ed5ef4cc85e67eb2a3e3d\r\n"\
                      "Content-Length: ";
    char len[2]; 
    len[0]=strlen(pJSON_http_post)/10%10+48;
    len[1]=strlen(pJSON_http_post)%10+48;
    strcat(http_POST_cmd,len);
    strcat(http_POST_cmd,"\r\nContent-Type: application/x-www-form-urlencoded\r\n\r\n");
     
    strcat(http_POST_cmd,pJSON_http_post);
    conn.send_all(http_POST_cmd, strlen(http_POST_cmd));//http_cmd for http,pJSON for socket,should be three changes
    pc.printf("%s\r\n",http_POST_cmd); 
    pc.printf("5555\r\n");
    char *buffer = NULL;
    buffer = (char *)malloc(MallocSize);
    if(!buffer)pc.printf("malloc buffer err\r\n");

    int ret;
    pc.printf("6666\r\n");
    while (true) {
        wait(1);
        ret = conn.receive(buffer, MallocSize-1);
        pc.printf("ret = %d\r\n",ret);
        if (ret <= 0) {
            break;
        }
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server: %s\n", ret, buffer);     
    }
    pc.printf("http_POST OUT\r\n");

    free(pJSON_http_post);
    free(buffer);
    cJSON_Delete(http_post);
    pc.printf("7777\r\n");
    return true;
}

/*socket POST*/
bool socket_POST(TCPSocketConnection &conn,int vall)
{   
    if(conn.is_connected()){
        pc.printf("connect is already ok!\r\n");    
    }else{
        if(!conn.connect("iot.espressif.cn", socketPort)) //80 for http,8000 for socket
            pc.printf("connect OK!\r\n");
        else{
            pc.printf("connct ERR!\r\n");
            out = true;
            return false;    
        }
    }
    cJSON* socket_post=NULL;  
    socket_post = cJSON_CreateObject();    
    if(NULL == socket_post)
    {
         pc.printf("OUT4\r\n");
         out = true;
         return false;
    }
    
    
    cJSON_AddStringToObject(socket_post, "path", path); 
    cJSON_AddStringToObject(socket_post, "method", "POST"); 
    
    cJSON* sock_post_token=NULL;  
    sock_post_token = cJSON_CreateObject();    
    if(NULL == sock_post_token)
    {
         cJSON_Delete(socket_post);
         pc.printf("OUT5\r\n");
         out = true;
         return false;
    }
    cJSON_AddStringToObject(sock_post_token, "Authorization", "token 514cc9c3aa07a4a56246cb9259c8264fd2ae56f6");
    cJSON_AddItemToObject(socket_post, "meta", sock_post_token);
    
    cJSON* sock_post_xyz=NULL;  
    sock_post_xyz = cJSON_CreateObject();    
    if(NULL == sock_post_xyz)
    {
         cJSON_Delete(socket_post);
         pc.printf("OUT6\r\n");
         out = true;
         return false;
    }
    cJSON_AddNumberToObject(sock_post_xyz, "x", vall);
    //cJSON_AddNumberToObject(sock_post_xyz, "y", 8);
    //cJSON_AddNumberToObject(sock_post_xyz, "z", 8);
    cJSON* sock_post_datapoint=NULL;  
    sock_post_datapoint = cJSON_CreateObject();    
    if(NULL == sock_post_datapoint)
    {
         cJSON_Delete(socket_post);
         pc.printf("OUT6\r\n");
         out = true;
         return false;
    }
    cJSON_AddItemToObject(sock_post_datapoint, "datapoint", sock_post_xyz);
    cJSON_AddItemToObject(socket_post, "body", sock_post_datapoint);
    
    char* pJSON_sock_post = cJSON_PrintUnformatted(socket_post);

    if(NULL == pJSON_sock_post)
    {
        cJSON_Delete(socket_post);
        pc.printf("OUT7\r\n");
        out = true;
        return false;
    } 
    strcat(pJSON_sock_post,"\n");
    
    conn.send_all(pJSON_sock_post, strlen(pJSON_sock_post));//http_cmd for http,pJSON for socket,should be three changes
    pc.printf("%s\r\n",pJSON_sock_post); 
    
    char *buffer = NULL;
    buffer = (char *)malloc(MallocSize);
    if(!buffer)pc.printf("malloc buffer err\r\n");

    int ret;

    while (true) {
        ret = conn.receive(buffer, MallocSize-1);
        pc.printf("ret = %d\r\n",ret);
        if (ret <= 0) {
            break;
        }
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server: %s\n", ret, buffer);     
    }
    pc.printf("socket_POST OUT\r\n");
    
    free(pJSON_sock_post);
    free(buffer);
    cJSON_Delete(socket_post);

    return true;  
}

bool closeConnect(TCPSocketConnection &conn)
{
    if(conn.is_connected()){
        pc.printf("connect is already ok!\r\n");    
    }else{
        if(!conn.connect("iot.espressif.cn", socketPort)) //80 for http,8000 for socket
            pc.printf("connect OK!\r\n");
        else{
            pc.printf("connct ERR!\r\n");
            out = true;
            return false;    
        }
    }
    

    cJSON* close_post=NULL;  
    close_post = cJSON_CreateObject();    
    if(NULL == close_post)
    {
         pc.printf("OUT4\r\n");
         out = true;
         return false;
    }
    
    
    cJSON_AddStringToObject(close_post, "path", "/v1/The_Gas/quit/"); 
    cJSON_AddStringToObject(close_post, "method", "POST"); 
    
    cJSON* close_post_token=NULL;  
    close_post_token = cJSON_CreateObject();    
    if(NULL == close_post_token)
    {
         cJSON_Delete(close_post);
         pc.printf("OUT5\r\n");
         out = true;
         return false;
    }
    cJSON_AddStringToObject(close_post_token, "Authorization", "token 514cc9c3aa07a4a56246cb9259c8264fd2ae56f6");
    cJSON_AddItemToObject(close_post, "meta", close_post_token);  
    
    char* close_pJSON = cJSON_PrintUnformatted(close_post);

    if(NULL == close_pJSON)
    {
        cJSON_Delete(close_post);
        pc.printf("OUT7\r\n");
        out = true;
        return false;
    } 
    strcat(close_pJSON,"\n");
    
    conn.send_all(close_pJSON, strlen(close_pJSON));//http_cmd for http,pJSON for socket,should be three changes
    pc.printf("%s\r\n",close_pJSON); 
    
    char *buffer = NULL;
    buffer = (char *)malloc(MallocSize);
    if(!buffer)pc.printf("malloc buffer err\r\n");

    int ret;

    while (true) {
        ret = conn.receive(buffer, MallocSize-1);
        pc.printf("ret = %d\r\n",ret);
        if (ret <= 0) {
            break;
        }
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server: %s\n", ret, buffer);     
    }
    pc.printf("close_POST OUT\r\n");
    
    free(close_pJSON);
    free(buffer);
    cJSON_Delete(close_post);

    return true;
}
