/*
#include "mbed.h"
AnalogIn battery(A3);
Serial uart1(PA_13,PA_14);
int main(){
    while(1){
        if(battery > 0.5){
            uart1.printf("%02f\n",battery.read()*3.3);
            wait(1);
        }
    }
}
*/

/********uart1 demo********
#include "mbed.h"
 
Serial uart1(PA_13, PA_14); // tx, rx

int main() {
    uart1.printf("Please input something\n");
 
    while(1) {
        char c = uart1.getc();
        uart1.printf("%s\n",c);
    }
}
*/

/********uart2 demo********
#include "mbed.h"
 
Serial uart2(PC_10, PC_11); // tx, rx

int main() {
    uart2.printf("Please input something\n");
 
    while(1) {
        char c = uart2.getc();
        uart2.printf("%s\n",c);
    }
}
*/

/**********Digital demo**********
#include "mbed.h"

DigitalOut num1(D10);
DigitalOut num2(D11);
DigitalOut num3(D12);
DigitalOut num4(D2);
DigitalOut num5(D3);
DigitalOut num6(D5);
DigitalOut num7(D6);

int main(){
    while(1){
        wait(1);
        num1 = 1;
        num2 = 1;
        num3 = 1;
        
        wait(1);
        num1 = 0;
        num2 = 0;
        num3 = 0;
        
    }    
}
/*  */

/**********analog demo***********
#include "mbed.h"
AnalogIn battery5(A0);
AnalogIn battery4(PC_9);
AnalogIn battery3(D5);
Serial uart1(PA_13,PA_14);
//Serial pc(USBTX,USBRX);
int main(){
    while(1){
        //if(battery3 > 0.5){
           // uart1.printf("%f\n",battery3.read()*3.3);
           // wait(0.2);
       // }
        //if(battery4 > 0.5){
          //  uart1.printf("%f\n",battery4.read());
            //wait(0.2);
        //}
        if(battery5 > 0.5){
            uart1.printf("%f\n",battery5.read());
            wait(0.2);
        }
    }
}
*/

/*
#include"mbed.h"
AnalogIn battery(A2);
Serial uart1(PA_13,PA_14);
int main(){
    while(1){
        if(battery > 0.5){
            uart1.printf("%f",battery.read());
            wait(1);
        }
    }
}
*/
/*
#include "mbed.h"

Serial uart1(PA_13, PA_14); // tx, rx
Serial uart2(PC_10, PC_11); // tx, rx
DigitalOut myD1(D10);
DigitalOut myD2(D11);
DigitalOut myD3(D12);
DigitalOut myD4(D2);
AnalogIn myA1(A1);
AnalogIn myA2(A2);
AnalogIn myA3(A3);
PwmOut PWM1(D3);
PwmOut PWM2(D5);
PwmOut PWM3(D6);

Timeout timeout;

void attimeout()
{
    myD1 = 0;
    myD2 = 0;
    myD3 = 0;
    myD4 = 0; 
}

int main() {
    uart1.baud(115200);
    uart2.baud(115200);   
    PWM1.period_us(500);
    PWM2.period_us(500);
    PWM3.period_us(500);
    PWM1 = 0.2;
    PWM2 = 0.5;
    PWM3 = 0.8;
    uart2.printf("uart2:for Loopback test,please input something\n");
    uart1.printf("start testing uart1 digitalOut and PWM and analogIn\n");
    while(1){
        while(uart2.readable()){
            uart2.printf("%c", uart2.getc());
        }
        
        timeout.attach(&attimeout,2);
         
        myD1 = 1;
        myD2 = 1;
        myD3 = 1;
        myD4 = 1;
        wait(0.25);

        uart1.printf("A1:%02f\n",myA1.read()*3.3);
        uart1.printf("A2:%02f\n",myA2.read()*3.3);
        uart1.printf("A3:%02f\n",myA3.read()*3.3);
    } 
}
*/

#include "mbed.h"
#include <Serial.h>
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include <stdio.h>
#include <string.h>
 
#define ADXL345_I2C_READ        0xA7
#define ADXL345_I2C_WRITE       0xA6
#define ADXL345_I2C_ADDRESS     0x53
#define ADXL345_DEVID_REG       0x00
#define ADXL345_DATAX0_REG      0x32
#define ADXL345_POWER_CTL_REG   0x2D
#define MeasurementMode         0x08

#define MAC     "\x00\x08\xDC\x11\x34\x78"
#define IP      "192.168.1.19"
#define MASK    "255.255.255.0"
#define GATEWAY "192.168.1.1"

#define HTTPD_SERVER_PORT   80
#define HTTPD_MAX_REQ_LENGTH   1023
#define HTTPD_MAX_HDR_LENGTH   255
#define HTTPD_MAX_FNAME_LENGTH   127
#define HTTPD_MAX_DNAME_LENGTH   127

SDFileSystem sd(PB_3, PB_2, PB_1, PB_0, "sd"); // WIZwiki-W7500 
EthernetInterface eth;
TCPSocketServer server;
TCPSocketConnection client;
char buffer[HTTPD_MAX_REQ_LENGTH+1];
char httpHeader[HTTPD_MAX_HDR_LENGTH+1];
char fileName[HTTPD_MAX_FNAME_LENGTH+1];
char dirName[HTTPD_MAX_DNAME_LENGTH+1];
char *uristr;
char *eou;
char *qrystr;
FILE *fp;
int rdCnt;
DigitalOut led1(D10); //server listning status
DigitalOut led2(D11); //socket connecting status
Ticker ledTick;
 
I2C adxl345(PA_10,PA_09);
int16_t xyz[3] = {0, 0, 0};
 
Serial uart0(PA_13, PA_14); // tx, rx
Serial uart2(PC_10, PC_11); // tx, rx
//DigitalOut myD1(D10);
//DigitalOut myD2(D11);
DigitalOut myD3(D12);
DigitalOut myD4(D2);
AnalogIn myA1(A1);
AnalogIn myA2(A2);
AnalogIn myA3(A3);
PwmOut PWM1(D3);
PwmOut PWM2(D5);
PwmOut PWM3(D6);
DigitalIn mybutton(PC_06);
 
Timeout digitalTimeout;
Timeout analogTimeout; 


void attimeoutD()
{
    static int pos = 0;
    if(pos == 0){
        //myD1 = 0;
        //myD2 = 0;
        myD3 = 0;
        myD4 = 0; 
    }else{
        //myD1 = 1;
        //myD2 = 1;
        myD3 = 1;
        myD4 = 1;
    }
    pos = !pos;
    digitalTimeout.attach(&attimeoutD,0.5);
}
void attimeoutA()
{
    uart0.printf("A1:%02fV  ",myA1.read()*3.3);
    uart0.printf("A2:%02fV  ",myA2.read()*3.3);
    uart0.printf("A3:%02fV  \r\n",myA3.read()*3.3);
    analogTimeout.attach(&attimeoutA,1); 
}

void ledTickfunc()
{
    led1 = !led1;
}

void getFile(char* uri)
{
    //uart0.printf("getFile %s\n", uri);
    char *lstchr = strrchr(uri, NULL) -1;
    if ('/' == *lstchr) {
        //uart0.printf("Open directory /sd%s\r\n", uri);
        *lstchr = 0;
        sprintf(fileName, "/sd%s", uri);
        DIR *d = opendir(fileName);
        if (d != NULL) {
            sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            sprintf(httpHeader,"<html><head><title>Directory Listing</title></head><body><h1>%s Directory Listing</h1><ul>", uri);
            client.send(httpHeader,strlen(httpHeader));
            struct dirent *p;
            while((p = readdir(d)) != NULL) {
                sprintf(dirName, "%s/%s", fileName, p->d_name);
                //uart0.printf("%s\n", dirName);
                DIR *subDir = opendir(dirName);
                if (subDir != NULL) {
                    sprintf(httpHeader,"<li><a href=\"./%s/\">%s/</a></li>", p->d_name, p->d_name);
                } else {
                    sprintf(httpHeader,"<li><a href=\"./%s\">%s</a></li>", p->d_name, p->d_name);
                }
                client.send(httpHeader,strlen(httpHeader));
            }
        }
        closedir(d);
        //uart0.printf("Directory closed\r\n");
        sprintf(httpHeader,"</ul></body></html>");
        client.send(httpHeader,strlen(httpHeader));
    } else {
        sprintf(fileName, "/sd%s", uri);
        fp = fopen(fileName, "r");
        if (fp == NULL) {
            //uart0.printf("File not found\r\n");
            sprintf(httpHeader,"HTTP/1.1 404 Not Found \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            client.send(uri,strlen(uri));
        } else {
            //uart0.printf("Sending: header");
            sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            //uart0.printf(" file");
            while ((rdCnt = fread(buffer, sizeof( char ), 1024, fp)) == 1024) {
                client.send(buffer, rdCnt);
                //uart0.printf(".");
            }
            client.send(buffer, rdCnt);
            fclose(fp);
            //uart0.printf("done\r\n");
        }
    }
}
 
int main() {
    uart0.baud(9600);
    uart2.baud(9600);   
    PWM1.period_us(500);
    PWM2.period_us(500);
    PWM3.period_us(500);
    PWM1 = 0.2;
    PWM2 = 0.5;
    PWM3 = 0.8;
    uart2.printf("uart2:for Loopback test,please input something\n");
    uart0.printf("start testing uart1 digitalOut and PWM and analogIn\r\n");
    digitalTimeout.attach(&attimeoutD,1);
    analogTimeout.attach(&attimeoutA,1);
    /*iic*/
    char config[2];
    char data[6];
    config[0] = ADXL345_DEVID_REG;
    char output;
    adxl345.write( ADXL345_I2C_WRITE , config, 1);
    adxl345.read( ADXL345_I2C_READ , &output, 1);
    uart0.printf("ADXL345 device id is 0x%x.\r\n",output);
    config[0] = ADXL345_POWER_CTL_REG;
    config[1] = MeasurementMode;
    adxl345.write( ADXL345_I2C_WRITE, config, 2); //set power

    config[0]=ADXL345_DATAX0_REG;
    /*eth&sd*/
    ledTick.attach(&ledTickfunc,0.5);
    uart0.printf("Initializing\r\n");
    uart0.printf("Checking File System\r\n");
    DIR *d = opendir("/sd/");
    if (d != NULL) {
        uart0.printf("SD Card Present\r\n");
    } else {
        uart0.printf("SD Card Root Directory Not Found\r\n");
    }
    uart0.printf("Initializing Ethernet\r\n");
    eth.init((uint8_t*)MAC,IP,MASK,GATEWAY);  
    uart0.printf("Connecting\r\n");
    eth.connect();
    uart0.printf("IP Address is %s\r\n", eth.getIPAddress());
    server.bind(HTTPD_SERVER_PORT);
    server.listen();
    uart0.printf("Server Listening\r\n"); 
    
    while(1) {
        //wait(0.1);
        /*eth&sd*/
        //uart0.printf("\nWait for new connection...\r\n");
        server.accept(client);

        client.set_blocking(false, 1500); // Timeout after (1.5)s

        //uart0.printf("Connection from: %s\r\n", client.get_address());
        while (1) {
            /**/
            if (mybutton == 0) { 
              uart0.printf("USER Button is Pressed!!!\r\n");
            }
            if(uart0.readable()){
              char ch = uart0.getc();
              uart0.printf("%c", ch);
            }
            if(uart2.readable()){
              char ch2 = uart2.getc();
              uart2.printf("%c", ch2);
            }
            /*iic*/
            adxl345.write( ADXL345_I2C_WRITE, config, 1);
            adxl345.read( ADXL345_I2C_READ , data, 6);
            xyz[0]=(int)data[1]<<8|(int)data[0];
            xyz[1]=(int)data[3]<<8|(int)data[2];
            xyz[2]=(int)data[5]<<8|(int)data[4];
            uart0.printf("%6i, %6i, %6i\r\n", xyz[0], xyz[1], xyz[2]);
            /**/
            
            led2 = true;
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0){
                led2 = false;
                client.close();
                break;
            }
            //uart0.printf("Recieved Data: %d\r\n\r\n%.*s\r\n",n,n,buffer);
            if (n >= 1024) {
                sprintf(httpHeader,"HTTP/1.1 413 Request Entity Too Large \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                client.send(httpHeader,strlen(httpHeader));
                client.send(buffer,n);
                led2 = false;
                client.close();
                break;
            } else {
                buffer[n]=0;
            }
            if (!strncmp(buffer, "GET ", 4)) {
                uristr = buffer + 4;
                eou = strstr(uristr, " ");
                if (eou == NULL) {
                    sprintf(httpHeader,"HTTP/1.1 400 Bad Request \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                    client.send(httpHeader,strlen(httpHeader));
                    client.send(buffer,n);
                } else {
                    *eou = 0;
                    getFile(uristr);
                }
            }
        }
        
    }
}
