

#include "mbed.h"

Serial uart1(PA_13, PA_14); // tx, rx
Serial uart2(PC_10, PC_11); // tx, rx
DigitalOut myD1(D10);
DigitalOut myD2(D11);
DigitalOut myD3(D12);
DigitalOut myD4(D2);
AnalogIn myA1(A1);
AnalogIn myA2(A2);
AnalogIn myA3(A3);
PwmOut PWM1(D3);
PwmOut PWM2(D5);
PwmOut PWM3(D6);

Timeout timeout;

void attimeout()
{
    myD1 = 0;
    myD2 = 0;
    myD3 = 0;
    myD4 = 0; 
}

int main() {
    uart1.baud(115200);
    uart2.baud(115200);   
    PWM1.period_us(500);
    PWM2.period_us(500);
    PWM3.period_us(500);
    PWM1 = 0.2;
    PWM2 = 0.5;
    PWM3 = 0.8;
    uart2.printf("uart2:for Loopback test,please input something\n");
    uart1.printf("start testing uart1 digitalOut and PWM and analogIn\n");
    while(1){
        while(uart2.readable()){
            uart2.printf("%c", uart2.getc());
        }
        
        timeout.attach(&attimeout,2);
         
        myD1 = 1;
        myD2 = 1;
        myD3 = 1;
        myD4 = 1;
        wait(0.25);

        uart1.printf("A1:%02f\n",myA1.read()*3.3);
        uart1.printf("A2:%02f\n",myA2.read()*3.3);
        uart1.printf("A3:%02f\n",myA3.read()*3.3);
    } 
}




