#include "hcsr04.h"
#include "mbed.h"
/*
*HCSR04.cpp
*/
HCSR04::HCSR04(PinName t, PinName e, long to) : trig(t), echo(e), time_out(to){}
 long HCSR04::echo_duration() {
        
    timer.reset();  //reset timer
    trig=0;   // trigger low 
    wait_us(2); //  wait 
    trig=1;   //  trigger high
    wait_us(10);
    trig=0;  // trigger low
    while(!echo); // start pulseIN
    timer.start();
    while(echo)
    {
        if(timer.read_us()>time_out)        
            break;
    }
    timer.stop();
    
    long czas=timer.read_us();
    if(czas<300)
        return 0;
    return timer.read_us(); 
 
}
 
//return distance in cm 
    long HCSR04::distance(){
    duration = echo_duration();
    distance_cm = (duration*34)/1000/2 ;
    return distance_cm;

}