/*
 * Allen Wild
 * Joseph Guinta
 *
 * ECE 4180 Lab 2
 */
 
#include "mbed.h"
#include "rtos.h"
#include "HMC6352.h"
#include "EthernetInterface.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "Speaker.h"
#include "wave_player.h"
#include "Servo.h"

#define ANALOG_OUT_PIN p18
#define ANALOG_IN p19
#define SOUND_WAVFILE        "/sd/wavfiles/coolsound.wav"
#define PWM_PIN p0

void part1Function(void);
void part2Function(void);
void part4Function(void);
void part5Function(void);
void part6Function(void);
void part7Function(void);
void part8Function(void);

//Part 1 - Analog
float Analog_out_data[40];
AnalogOut a_out_signal(ANALOG_OUT_PIN);
AnalogIn a_in(ANALOG_IN);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

//Part 2 and 3 - I2C and Serial
HMC6352 compass(p9, p10);
Serial pc(USBTX, USBRX);


//Part 4 - Ethernet
EthernetInterface eth;


//Part 5 - servo position control
PwmOut servo(p21);

//Part 6 - Color LCD
uLCD_4DGL uLCD(p28, p27, p29); 

// Part 7  - SD
SDFileSystem sd(p5, p6, p7, p8, "sd"); 
//Part 8 - Speaker
AnalogOut DACout(p18);
wave_player waver(&DACout);
int main() {
   part1Function(); //Analog
   part2Function();
   part4Function(); //Ethernet
   part5Function(); //servo
   part6Function(); //Color LCD
   part7Function(); //SD
   part8Function(); //Sound
}


    
void part1Function(void) {
     int i = 0;
    //precompute sine wave values
    for( i=0; i<40; i++) {
        Analog_out_data[i]=((1.0 + sin((float(i)/40.0*6.28318530717959)))/2.0);   // scale the sine wave from 0.0 to 1.0     
    } 
    
    
    //part 1 while loop - consider making each part a separate function (easy to call and comment out)
    while (true) {
        
        //is this what he means by 2 complete cycles for each iteration of the loop??
        for (i = 0; i < 40; i++) { //cycle 1
            a_out_signal = Analog_out_data[i];
            wait(.1);
        }   
         for (i = 0; i < 40; i++) { //cycle 2
            a_out_signal = Analog_out_data[i];
            wait(.1);
        }  
        
        //As the voltage passes a threshold, turn on another LED
        led1 = (a_in > 0.2) ? 1 : 0;
        led2 = (a_in > 0.4) ? 1 : 0;
        led3 = (a_in > 0.6) ? 1 : 0;
        led4 = (a_in > 0.8) ? 1 : 0;
        
        wait(0.3);
     }   
        
}//end of part1
    
void part2Function(void) {
    compass.setOpMode(2, 1, 20); //continuous mode, set/reset, 20Hz
   
    while (1) {
 
        wait(0.1);
 
        pc.printf("Compass reading: %f\n", compass.sample() / 10.0); //Compass.sample() returns value from 0 -3599.xxx or something like that, so divide by 10 to get 0-360 degrees
 
    }  
} //end part 2


void part4Function(void) { //Code taken from http://mbed.org/handbook/Ethernet-Interface
    eth.init(); //Use DHCP
    eth.connect();
    pc.printf("IP Address is %s\n", eth.getIPAddress());
    
    TCPSocketConnection sock;
    sock.connect("mbed.org", 80);
    
    char http_cmd[] = "GET /media/uploads/mbed_official/hello.txt HTTP/1.0\n\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    
    char buffer[300];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server:\n%s\n", ret, buffer);
    }
      
    sock.close();
    
    eth.disconnect();
    while(1) {}
} //end part 4

void part5Function(void) {
    servo.period_ms(20);        //20ms period
    while (1) {
        for(float offset=0.0; offset<0.001; offset+=0.0001) {
            servo.pulsewidth_ms(1 + offset); // servo position determined by a pulsewidth between 1-2ms
            wait(0.2);
        }
    }
    
} //end part 5

void part6Function(void) {
    uLCD.printf("\nHello World!\n");
} //end part 6

void part7Function(void) { 


    mkdir("/sd/mydir", 0777);
    
    FILE *fp = fopen("/sd/mydir/hellosd.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp, "Hello SD file world");
    fclose(fp); 
    
    fp = fopen("/sd/mydir/hellosd.txt", "r"); //open file, read string and write to pc through usb virtual com port
    if(fp == NULL) {
        error("Could not open file for read\n");
    }
     char mystring [100]; //allocate space for string
    if ( fgets (mystring , 100 , fp) != NULL )  //read in line
         pc.printf("%s\n",mystring); //can i do this? i haven't done c in so long
    fclose(fp);
} //end part 7

void part8Function(void) {
    
     //open wav file
    FILE *wave_file;
    wave_file = fopen(SOUND_WAVFILE, "r");
    
    //play wav file
    waver.play(wave_file);
    
    //close wav file
   fclose(wave_file);
}//end part 8