#include "mbed.h"
#include "util.h"
#include "weight.h"
#include "Servo.h"

Servo myservo(PTD4);
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
AnalogIn myADC(A0);
Serial pc(USBTX, USBRX); // tx, rx

int main() {
    int number_pills;
    
    myled1 = 1; //red off
    myled2 = 1; //green off
    myled3 = 1; //blue off
    //uint16_t val;
    //uint16_t val_avg;
    while(1) {
        //val = myADC.read_u16();
        //val_avg = mvgAvg(val, 0);
        //pc.printf("raw: %d  avg: %d\n\r", val, val_avg);
        number_pills = measure_pills();
        //pc.printf("Number of pills: %d\n\r", number_pills);
        wait(0.05);
    }
}

void run_servo() {
    
    /*wait(0.05);
    for(float p=0; p<1.0; p += 0.1) {
        myservo = p;
        pc.printf("%f\n\r", p);
        wait(0.2);
    }*/
    
    printf("Servo Calibration Controls:\n");
    printf("1,2,3 - Position Servo (full left, middle, full right)\n");
    printf("4,5 - Decrease or Increase range\n");
 
    float range = 0.0005;
    float position = 0.5;
    
    while(1) {                   
        switch(pc.getc()) {
            case '1': position = 0.0; break;
            case '2': position = 0.5; break;
            case '3': position = 1.0; break;
            case '4': range += 0.0001; break; 
            case '5': range -= 0.0001; break; 
        }
        printf("position = %.1f, range = +/-%0.4f\n", position, range);
        myservo.calibrate(range, 45.0); 
        myservo = position;
    }
}
