#ifndef _POLLED_QEI_H
#define _POLLED_QEI_H

#define CW   0
#define CCW  1


class PolledQEI  {
public:



    PolledQEI() {
        error("Constructor needs 2(3) Pin as parameters");
    };

    /** PolledQEI constructor
     *
     * @param PinName PhaseA and  PinName PhaseB
     * are a valid pin that supports DigitalIn
     */
    PolledQEI(PinName a, PinName b) {
        init( a, b, NC );
    }

    /** PolledQEI constructor
     *
     * @param PinName PhaseA and  PinName PhaseB and  PinName PhaseZ
     * are a valid pin that supports DigitalIn
     */
    PolledQEI(PinName a, PinName b, PinName z) {
        init( a, b, z );
    }

    /** PolledQEI destructor
     */
    ~PolledQEI() {
        if ( _ticker )  delete( _ticker );
        if ( _phaseA )  delete( _phaseA );
        if ( _phaseB )  delete( _phaseB );
        if ( _phaseZ )  delete( _phaseZ );
    }

    /** Set the sampling time in microseconds.
     *
     * @param int The time between pin samples in microseconds.
     */
    void setSampleFrequency(int i);
    int pos(void);
    int dir(void);
    int rev(void);
    
    
private:


protected:
    DigitalIn       *_phaseA;
    DigitalIn       *_phaseB;
    InterruptIn     *_phaseZ;
    Ticker          *_ticker;
    int             _sample_uSec;
    unsigned int    _actEncPos;
    unsigned int    _actEncRev;
    int             _dir;
    unsigned int    last;

    void init(PinName a, PinName b, PinName z);
    void check (void);
    void countRev(void);

};

#endif