#include "mbed.h"
#include "XBee.h"
#include "Wireless.h"
#include "USBKeyboard.h"

Serial pc(USBTX, USBRX);
WirelessHost host(p28, p27);
USBKeyboard keyboard;
DigitalOut led1(LED1);

WMessage_t message;

int main() {
    int res;

    pc.printf("Xbee should be ready\r\n");
     led1 = 1;
    while(1) {
        res = host.waitForMessage(&message);

        if (res >= 0) {
            switch (message.type) {
            case FOOT_STEP:
                printf("Foot: ");
                break;
            case HAND_GESTURE:
                printf("Hand: ");
                break;
            default:
                printf("[Unknown Type: %d]: ", message.type);
            }

            switch (message.direction) {
            case DIR_UP:
                //printf("UP");
                keyboard.pressKey(UP_ARROW);
                break;
            case DIR_DOWN:
                //printf("DOWN");
                keyboard.pressKey(DOWN_ARROW);
                break;
            case DIR_LEFT:
                //printf("LEFT");
                keyboard.pressKey(LEFT_ARROW);
                break;
            case DIR_RIGHT:
                //printf("RIGHT");
                keyboard.pressKey(RIGHT_ARROW);
                break;
            case DIR_NONE:
                //printf("NONE");
                keyboard.releaseAllKeys(); 
                break;
            case A_BUTTON:
                keyboard.pressKey('a');
                wait(0.2);
                keyboard.releaseAllKeys();
                break;
            case B_BUTTON:
                keyboard.pressKey('b');
                wait(0.2);
                keyboard.releaseAllKeys();
                break;
            default:
                printf("[Unknown Direction: %d]", message.direction);
            }
            printf("\r\n");
        } else if (res == -99) {
            printf("Error: Error response from XBee\r\n");
        } else if (res == -5) {
            printf("Received unexpected packet type from XBee, ignoring\r\n");
        } else if (res == -10) {
            printf("Error: Received unknown packet format\r\n");
        } else if (res != -1) {
            printf("Unknown error receiving message\r\n");
        }
    }
}