#include "mbed.h"
#include "LSM9DS1.h"
#include "Wireless.h"
#define PI 3.14159
// Earth's magnetic field varies by location. Add or subtract
// a declination to get a more accurate heading. Calculate
// your's here:
// http://www.ngdc.noaa.gov/geomag-web/#declination
#define DECLINATION -4.94 // Declination (degrees) in Atlanta,GA.

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
InterruptIn pb(p21);
InterruptIn pb2(p5);
WirelessModule wireless(p28, p27, HAND_GESTURE);

void pb_hit_interruptA() {
    pc.printf("pressed\n\r");
    wireless.sendDirection(A_BUTTON);
}
void pb_hit_interruptB(){
    wireless.sendDirection(B_BUTTON);
    pc.printf("pressedB\n\r");
}
int main()
{
    
    LSM9DS1 IMU(p9, p10, 0xD6, 0x3C);
    IMU.begin();
    if (!IMU.begin()) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
    }
    IMU.calibrate(1);
    //IMU.calibrateMag(0);
    pb.mode(PullUp);
    pb2.mode(PullUp);
    wait(.01);
    pb.fall(&pb_hit_interruptA);
    pb2.fall(&pb_hit_interruptB);
    double inX,inY,inZ;
    int pos=0;
    while(1) {
        while(!IMU.accelAvailable()) {pos = 0;}
        IMU.readAccel();
                      
        inX = IMU.calcAccel(IMU.ax);
        inY = IMU.calcAccel(IMU.ay); 
        inZ = IMU.calcAccel(IMU.az);
        if (inY >= .5)
        {
            pc.printf("left\n\r");
            pos = 1;
            wireless.sendDirection(DIR_LEFT);
        }
        else if( inY <= -.5)
        {
            pc.printf("right\n\r");
            pos = 2;
            wireless.sendDirection(DIR_RIGHT);
        }
        else if (inX >= .5)
        {
            pc.printf("up\n\r");
            pos = 3;
            wireless.sendDirection(DIR_UP);
        }
        else if (inX <= -.5)
        {
            pc.printf("down\n\r");
            pos = 4;
            wireless.sendDirection(DIR_DOWN);
        }
        else
        {
            //pc.printf("error");
            pos = 0;
            wireless.sendDirection(DIR_NONE);
        }
        wait(0.5);
    }
}

