#include "mbed.h"
#include "LSM9DS1.h"
#include "Wireless.h"
//#include "USBKeyboard.h"
//#include "MahonyAHRS.h"
#define PI 3.14159
// Earth's magnetic field varies by location. Add or subtract
// a declination to get a more accurate heading. Calculate
// your's here:
// http://www.ngdc.noaa.gov/geomag-web/#declination
#define DECLINATION -4.94 // Declination (degrees) in Atlanta,GA.

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial pc(USBTX, USBRX);
DigitalIn pb1(p17);






float correctHeading(float currHeading, float forward)
{
    float newHeading = currHeading - forward;
    if(newHeading < 0) newHeading = 360 + newHeading;
    return newHeading;
}

float printAttitude(float ax, float ay, float az, float mx, float my, float mz)
{
    float roll = atan2(ay, az);
    float pitch = atan2(-ax, sqrt(ay * ay + az * az));
// touchy trig stuff to use arctan to get compass heading (scale is 0..360)
    mx = -mx;
    float heading;
    if (my == 0.0)
        heading = (mx < 0.0) ? 180.0 : 0.0;
    else
        heading = atan2(mx, my)*360.0/(2.0*PI);
    //pc.printf("heading atan=%f \n\r",heading);
    heading -= DECLINATION; //correct for geo location
    if(heading>180.0) heading = heading - 360.0;
    else if(heading<-180.0) heading = 360.0 + heading;
    else if(heading<0.0) heading = 360.0  + heading;


    // Convert everything from radians to degrees:
    //heading *= 180.0 / PI;
    pitch *= 180.0 / PI;
    roll  *= 180.0 / PI;

    //pc.printf("Pitch: %f,    Roll: %f degress\n\r",pitch,roll);
    //pc.printf("Magnetic Heading: %f degress\n\r",heading);
    return abs(heading);
}

bool isWalking = false;

Ticker walkingTimer;
Ticker resetStart;
WirelessModule wireless(p9, p10, FOOT_STEP);
float ax ;
float ay ;
float az ;
float gx ;
float gy ;
float gz ;
float mx ;
float my ;
float mz ;
LSM9DS1 IMU(p28, p27, 0xD6, 0x3C);

void printStop()
{
    // pc.printf("stop\n\r");
    wireless.sendDirection(DIR_NONE);
    isWalking = false;
}




int main()
{

    pb1.mode(PullUp);
    IMU.begin();
    float forward;
    if (!IMU.begin()) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
    }
    led4 = 1;
    IMU.calibrate(1);
    led4 = 0;
    wait(0.5);
    led1 = 1;
    led4 = 1;
    IMU.calibrateMag(0);
    led4 = 0;
    led2 = 1;
    pc.printf("Press button to set forward direction");
    while(pb1 == 1) {
        IMU.readMag();
        IMU.readAccel();
        ax = IMU.calcAccel(IMU.ax);
        ay = IMU.calcAccel(IMU.ay);
        az = IMU.calcAccel(IMU.az);
        gx = IMU.calcGyro(IMU.gx);
        gy = IMU.calcGyro(IMU.gy);
        gz = IMU.calcGyro(IMU.gz);
        mx = IMU.calcMag(IMU.mx);
        my = IMU.calcMag(IMU.my);
        mz = IMU.calcMag(IMU.mz);
        forward = printAttitude(IMU.calcAccel(IMU.ax), IMU.calcAccel(IMU.ay), IMU.calcAccel(IMU.az), IMU.calcMag(IMU.mx),
                                IMU.calcMag(IMU.my), IMU.calcMag(IMU.mz));;
    }
    led3 = 1;
    while(1) {
        while(!IMU.tempAvailable());
        IMU.readTemp();
        while(!IMU.magAvailable(X_AXIS));
        IMU.readMag();
        while(!IMU.accelAvailable());
        IMU.readAccel();
        while(!IMU.gyroAvailable());
        IMU.readGyro();

        if(abs(IMU.calcGyro(IMU.gy)) > 100) {

            //Calculate heading relative to forward direction
            float currHeading = printAttitude(IMU.calcAccel(IMU.ax), IMU.calcAccel(IMU.ay), IMU.calcAccel(IMU.az), IMU.calcMag(IMU.mx),IMU.calcMag(IMU.my), IMU.calcMag(IMU.mz));
            currHeading = correctHeading(currHeading, forward);
            pc.printf("heading: %f\n\r", currHeading);
      
            //Start timeout to detect when stopped walking
            walkingTimer.attach(printStop, 0.3);

            //Detect direction and send command to main mbed
            if((currHeading > 225 && currHeading < 315) && !isWalking) {
                pc.printf("left\n\r");
                wireless.sendDirection(DIR_LEFT);

                isWalking = true;
            } else if((currHeading > 45 && currHeading < 135) && !isWalking) {
                pc.printf("right\n\r");
                wireless.sendDirection(DIR_RIGHT);
                isWalking = true;
            } else if((currHeading > 135 && currHeading < 225) && !isWalking) {
                pc.printf("down\n\r");
                wireless.sendDirection(DIR_DOWN);
                isWalking = true;
            } else if((currHeading > 315 || currHeading < 45) && !isWalking) {
                pc.printf("up\n\r");
                wireless.sendDirection(DIR_UP);

                isWalking = true;
            }
        }
    }
}

